$TestApp = "$Env:NINTENDO_SDK_ROOT\Tests\Outputs\NX-NXFP2-a64\Tests\testMultimedia_MediaPlayerTest\Develop\testMultimedia_MediaPlayerTest.nsp"
$nssFile = "$Env:NINTENDO_SDK_ROOT\Tests\Outputs\NX-NXFP2-a64\Tests\testMultimedia_MediaPlayerTest\Develop\testMultimedia_MediaPlayerTest.nss"
	
#Start Video Playback
function startVideo($testContent)
{	
	Start-Process -FilePath "$Env:NINTENDO_SDK_ROOT\Tools\CommandLineTools\RunOnTarget.exe" -ArgumentList "$TestApp -- $testContent -l 1 -enable-profiler" -NoNewWindow
}

#Start Video Playback
function stopVideo()
{
	Start-Process -FilePath "$Env:NINTENDO_SDK_ROOT\Tools\CommandLineTools\ControlTarget.exe" -ArgumentList "terminate" -NoNewWindow
}

# Profile and report cpu usage
function ProfileMM($testName, $testContent){
	startVideo "$testContent"
    sleep 10
    $containedFailure = $false
    $warningCount = [Nintendo.SDSG.Utilities.Logging]::Warnings.Count
	
	write-output "Starting Multimedia CPU Profiling: $testName"
    $samplingSettingsSet = profiler-sample Time 500
    if (!$samplingSettingsSet)
    {
        WriteError "Could not set sampling settings"
        $containedFailure = $true
    }
	Profiler-Connect
    profiler-nx-scenario AttachToProgramId -NssFile $nssFile -Autofill
	$synced = profiler-sync	
    profiler-callstacks $true
    profiler-perfcounters Disabled
    profiler-nx-cores 0
    profiler-start Sampled
    sleep 5
    profiler-stop
    sleep 20
	
	$functionList = Profiler-Copy Threads
	$functionList | write-output

    sleep 10
	stopVideo
	Profiler-Unsync
    sleep 10
}

sleep 5
ProfileMM "MMprofile_mp4" "$Env:NINTENDO_SDK_ROOT\Externals\multimedia\data\mp4\5s_h264_1080x1920_5_1_aac_2ch.mp4"
[Environment]::Exit(0)
