﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <nn/image/image_ExifExtractor.h>
#include <nn/image/image_JpegDecoder.h>
#include "Utilities.h"
#if 1
struct avi_header_t
{
    int TimeBetweenFrames;
    int MaximumDataRate;
    int PaddingGranularity;
    int Flags;
    int TotalNumberOfFrames;
    int NumberOfInitialFrames;
    int NumberOfStreams;
    int SuggestedBufferSize;
    int Width;
    int Height;
    int TimeScale;
    int DataRate;
    int StartTime;
    int DataLength;
};

struct stream_header_t
{
    char DataType[5];
    char DataHandler[5];
    int Flags;
    int Priority;
    int InitialFrames;
    int TimeScale;
    int DataRate;
    int StartTime;
    int DataLength;
    int SuggestedBufferSize;
    int Quality;
    int SampleSize;
};

struct stream_format_t
{
    int header_size;
    int image_width;
    int image_height;
    int number_of_planes;
    int bits_per_pixel;
    int compression_type;
    int image_size_in_bytes;
    int x_pels_per_meter;
    int y_pels_per_meter;
    int colors_used;
    int colors_important;
    int *palette;
};

struct stream_header_auds_t
{
    int format_type;
    int number_of_channels;
    int sample_rate;
    int bytes_per_second;
    int block_size_of_data;
    int bits_per_sample;
    int byte_count_extended;
};

struct stream_format_auds_t
{
    int header_size;
    int format;
    int channels;
    int samples_per_second;
    int bytes_per_second;
    int block_size_of_data;
    int bits_per_sample;
    int extended_size;
};

struct index_entry_t
{
    char ckid[5];
    int dwFlags;
    int dwChunkOffset;
    int dwChunkLength;
};


struct MetaData
{
    // 0th TIFF IFD カテゴリのメタデータ
    const char *maker;  // メーカー名
    size_t makerSize;   // 終端文字を含めたメーカー名のバイト数
    const char *model;  // 撮影機器名
    size_t modelSize;   // 終端文字を含めた撮影機器名のバイト数
    bool hasOrientation;    // 画像方向の情報があるかどうか
    nn::image::ExifOrientation orientation; // 画像方向
    const char *software;   // ソフトウェア名
    size_t softwareSize;    // 終端文字を含めたソフトウェア名のバイト数
    const char *dateTime;   // 撮影日時 (主単文字を含め20 バイト)

    // 0th Exif IFD カテゴリのメタデータ
    const void *makerNote;  // メーカーノート
    size_t makerNoteSize;   // メーカーノートのバイト数
    bool hasEffectiveDimension; // 実効画像サイズがあるかどうか
    nn::image::Dimension effectiveDim;  // 実効画像サイズ
    const char *uniqueId;   // 画像のユニーク ID (終端文字を含め 33 バイト)

    // 1st Tiff IFD カテゴリのメタデータ
    const void *thumbnail;  // サムネイルのバイト数
    size_t thumbnailSize;   // サムネイル画像のバイト数
};
#endif
int parse_riff(FILE *in, char* outFilePath);
//int parse_riff(nn::fs::FileHandle in);
int hex_dump_chunk(FILE *in, int chunk_len);
int hex_dump_file_chunk(FILE *in, int chunk_len);
int parse_idx1(FILE *in, int chunk_len);
int read_avi_header(FILE *in,struct avi_header_t *avi_header);
void print_data_handler(unsigned char *handler);
int read_stream_header(FILE *in,struct stream_header_t *stream_header);
int read_stream_format(FILE *in,struct stream_format_t *stream_format);
int read_stream_format_auds(FILE *in, struct stream_format_auds_t *stream_format);
int parse_hdrl_list(FILE *in,struct avi_header_t *avi_header, struct stream_header_t *stream_header, struct stream_format_t *stream_format);
int parse_hdrl(FILE *in,struct avi_header_t *avi_header, struct stream_header_t *stream_header, struct stream_format_t *stream_format, unsigned int size);
int read_long(FILE *in);
int read_word(FILE *in);
int read_chars(FILE *in, char *s, int count);
int parse_movi_list(struct avi_header_t *avi_header, FILE *in, char* outFilePath);
bool DecodeJpegData(nn::image::Dimension *pOutDim, Buffer *pOutBuf, const int alignment, FILE *in, int chunkSize);
void PrintMetaData(const MetaData &metaData);
void ExtractExifData(MetaData *pOutMetaData, const void *exifData, size_t exifSize);

