﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <movie/Player.h>
#include <string>
#include <chrono>

#include <experimental/vector>

namespace pmr = std::experimental::pmr;

namespace movie { namespace sample {

    struct CommandLineOptions {

        CommandLineOptions(char** arguments_, int count_, pmr::memory_resource&);
        bool valid() const noexcept { return !invalidOptions; }
        auto usage_string() const noexcept {
            return "\n ERROR:: Invalid options, see the Readme\n";
        }
        //-------------------------------------

        bool playAudio = true;
        bool playVideo = true;
        bool setLooping = false;
        bool isVideoTrack = false;
        bool unrestrictedResolution = false;
        bool useHeapTracking = false;
        bool isNetworkFile = false;

        //float playRate = 1.0;

        movie::PlayerResMax maxPlayerRes = movie::PlayerResMax_1080;
        movie::VideoDecodeMode videoDecodeMode = movie::VideoDecodeMode_NativeTexture;
        movie::OutputFormat videoOutputFormat = movie::OutputFormat_VideoColorAbgr;

        uint32_t rng_seed_value_ = std::chrono::high_resolution_clock::now().time_since_epoch().count();

        char const* inputFileName{};
        char const* configFile{};

        bool invalidOptions = false;

        std::string_view working_folder_;
        std::string_view playlist_file_;
        std::string_view lua_file_;

        pmr::vector<std::string_view> playlist_;
    };

}}


