﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testUserMigrationSequence_Facets.h"
#include "testUserMigrationSequence_Util.h"

#include "nntMigration_SaveData.h"

#include <nn/os/os_Mutex.h>
#include <nn/friends/friends_ApiAdmin.h>

namespace {

struct Lock
{
    nn::os::MutexType _lock;

    void lock() NN_NOEXCEPT
    {
        nn::os::LockMutex(&_lock);
    }
    void unlock() NN_NOEXCEPT
    {
        nn::os::UnlockMutex(&_lock);
    }
} g_Lock = {NN_OS_MUTEX_INITIALIZER(false)};

PAGE_ALIGN char g_AsyncThreadStack[32 * 1024 * 2];
PAGE_ALIGN char g_LoginBuffer[nn::account::RequiredBufferSizeForExternalNetworkServiceAccountRegistrar];

#if defined(NNT_MIGRATION_SERVER)
struct SaveDataCreationInfo
{
    nn::ncm::ApplicationId appId;
    size_t size;
    size_t journalSize;
};
const SaveDataCreationInfo SaveDataCreationInfoList[] = {
#if !defined(NNT_MIGRATION_STRESS)
    {{0x010000000000B123ull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B124ull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B125ull}, 64 * 1024 * 1024, 256 * 1024},
#else
    {{0x010000000000B123ull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B124ull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B125ull}, 1024 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B126ull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B127ull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B128ull}, 1024 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B129ull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B12Aull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B12Bull}, 1024 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B12Cull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B12Dull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B12Eull}, 1024 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B12Full}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B130ull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B131ull}, 1024 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B132ull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B133ull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B134ull}, 1024 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B135ull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B136ull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B137ull}, 1024 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B138ull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B139ull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B13Aull}, 1024 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B13Bull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B13Cull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B13Dull}, 1024 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B13Eull}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B13Full}, 64 * 1024 * 1024, 256 * 1024},
    {{0x010000000000B140ull}, 1024 * 1024 * 1024, 256 * 1024},
#endif // NNT_MIGRATION_STRESS
};
#endif // NNT_MIGRATION_SERVER

PAGE_ALIGN static char g_CleanupWorkMemory[32 * 1024 * 1024];
} // ~namespace <anonymous>

const char SharedBufferSequenceTest::StateStorageTag::VolumeName[] = "sbstate";
const char SharedBufferSequenceTest::ServerStorageTag::VolumeName[] = "sbserver";
const char SharedBufferSequenceTest::ClientStorageTag::VolumeName[] = "sbclient";
void SharedBufferSequenceTest::SetUpTestCase() NN_NOEXCEPT
{
    g_Lock.lock();
    Service::Initialize(
        "SharedBufferSequenceTest",
        g_AsyncThreadStack, sizeof(g_AsyncThreadStack),
        g_LoginBuffer, sizeof(g_LoginBuffer));
}
void SharedBufferSequenceTest::TearDownTestCase() NN_NOEXCEPT
{
    Service::Finalize();
    g_Lock.unlock();
}

const char SocketSequenceTest::StateStorageTag::VolumeName[] = "scstate";
const char SocketSequenceTest::ServerStorageTag::VolumeName[] = "scserver";
const char SocketSequenceTest::ClientStorageTag::VolumeName[] = "scclient";
void SocketSequenceTest::SetUpTestCase() NN_NOEXCEPT
{
    g_Lock.lock();
    Service::Initialize(
        "SocketSequenceTest",
        g_AsyncThreadStack, sizeof(g_AsyncThreadStack),
        g_LoginBuffer, sizeof(g_LoginBuffer));
}
void SocketSequenceTest::TearDownTestCase() NN_NOEXCEPT
{
    Service::Finalize();
    g_Lock.unlock();
}

void ProductSequenceTest::SetUpTestCase() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::migration::CleanupUserMigration(g_CleanupWorkMemory, sizeof(g_CleanupWorkMemory)));
    nnt::migration::CleanupUsers();

#if defined(NNT_MIGRATION_SERVER)
    auto uid = nnt::migration::SetupUser("moriyotd1", "N1ntend0");
    for (size_t i = 0; i < std::extent<decltype(SaveDataCreationInfoList)>::value; ++ i)
    {
        const auto& info = SaveDataCreationInfoList[i];
        nnt::migration::CreateSaveData(uid, info.appId, info.size, info.journalSize);
    }
#endif
}
void ProductSequenceTest::TearDownTestCase() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::migration::CleanupUserMigration(g_CleanupWorkMemory, sizeof(g_CleanupWorkMemory)));
    nnt::migration::CleanupUsers();
}
