﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/migration/migration_AsyncContext.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/os/os_MemoryHeapCommon.h>
#include <nn/os/os_SystemEvent.h>

#define LOG(...) NN_LOG("[testUserMigration]" __VA_ARGS__)

#if defined(NN_BUILD_CONFIG_TOOLCHAIN_VC_VS2013)
#define PAGE_ALIGN NN_ALIGNAS(4096)
#else
#define PAGE_ALIGN NN_ALIGNAS(nn::os::MemoryPageSize)
#endif

inline nn::Result WaitAsyncDone(nn::migration::AsyncContext&& ctx)
{
    nn::os::SystemEvent e;
    ctx.GetSystemEvent(&e);
    e.Wait();
    NN_RESULT_DO(ctx.GetResult());
    NN_RESULT_SUCCESS;
}
