﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/migration/idc/migration_SocketConnection.h>
#include <nn/migration/idc/migration_Client.h>
#include <nn/migration/idc/detail/migration_EncryptionPolicy.h>
#include <nn/nifm/nifm_ApiIpAddress.h>
#include <nn/os.h>
#include <nn/socket/socket_Api.h>
#include <nn/socket/socket_SystemConfig.h>
#include <nn/time/time_Api.h>
#include <nn/util/util_StringUtil.h>

#include "testMigrationIdc_TestUserContext.h"
#include "testMigrationIdc_SequenceClient.h"

using namespace nn;

namespace
{
    void Connect(migration::idc::SocketConnection* pOut, const char* address, uint16_t port) NN_NOEXCEPT
    {
        int m_ClientSocketDescriptor = -1;
        nn::socket::InAddr inAddr;
        NN_ABORT_UNLESS(socket::InetAton(address, &inAddr));

        nn::socket::SockAddrIn m_ServerSocketAddress;
        m_ServerSocketAddress.sin_addr = inAddr;
        m_ServerSocketAddress.sin_port = socket::InetHtons(port);
        m_ServerSocketAddress.sin_family = nn::socket::Family::Af_Inet;


        NN_LOG("-- Client startup --\n");
        if( (m_ClientSocketDescriptor = nn::socket::Socket(nn::socket::Family::Af_Inet, nn::socket::Type::Sock_Stream, nn::socket::Protocol::IpProto_Tcp)) < 0 )
        {
            NN_ABORT("client: Socket failed (error %d)\n", nn::socket::GetLastError());
            return;
        }

        NN_LOG("client: connecting to %s:%d\n", socket::InetNtoa(m_ServerSocketAddress.sin_addr), static_cast<int>(socket::InetNtohs(m_ServerSocketAddress.sin_port)));

        if( socket::Connect(m_ClientSocketDescriptor, reinterpret_cast<nn::socket::SockAddr *>(&m_ServerSocketAddress), sizeof(m_ServerSocketAddress)) < 0 )
        {
            NN_ABORT("client: Connect failed (error %d)\n", nn::socket::GetLastError());
        }
        NN_LOG("client: established connection to server\n");

        new (pOut) migration::idc::SocketConnection(m_ClientSocketDescriptor);
    }
}

Result RunClient(const char* address, uint16_t port) NN_NOEXCEPT
{
    migration::idc::SocketConnection connection;
    Connect(&connection, address, port);

    static nn::migration::idc::ClientContext<migration::idc::detail::DefaultEncryptionPolicy> clientContext;
    static nnt::migration::idc::TestUserContext userContext;
    static Bit8 buffer[sizeof(migration::idc::Client::InvokeUserCommandBuffer<decltype(clientContext)>)];

    NN_RESULT_DO(migration::idc::Client::Initiate(connection, clientContext, 0, buffer, sizeof(buffer), nullptr));
    NN_RESULT_DO(migration::idc::Client::InvokeUserCommand(connection, clientContext, userContext, 0, buffer, sizeof(buffer), nullptr));
    NN_RESULT_DO(migration::idc::Client::Terminate(connection, clientContext, 0, buffer, sizeof(buffer), nullptr));

    NN_RESULT_SUCCESS;
}
