﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/migration/detail/migration_Cancellable.h>
#include <nn/migration/idc/migration_Result.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>

using namespace nn;

const size_t                    ThreadStackSize = 8 * 1024;
NN_OS_ALIGNAS_THREAD_STACK Bit8 g_ThreadStackA[ThreadStackSize];
NN_OS_ALIGNAS_THREAD_STACK Bit8 g_ThreadStackB[ThreadStackSize];
os::ThreadType                  g_ThreadA;
os::ThreadType                  g_ThreadB;

class TestCancellable : public migration::detail::Cancellable
{
public:
    TestCancellable() {};
};

void RunOnThreadA(void(*f)(void*), void* arg)
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(os::CreateThread(&g_ThreadA, f, arg, g_ThreadStackA, ThreadStackSize, os::DefaultThreadPriority));
    os::StartThread(&g_ThreadA);
}

void RunOnThreadB(void(*f)(void*), void* arg)
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(os::CreateThread(&g_ThreadB, f, arg, g_ThreadStackB, ThreadStackSize, os::DefaultThreadPriority));
    os::StartThread(&g_ThreadB);
}

void DestroyThreadA()
{
    os::DestroyThread(&g_ThreadA);
}

void DestroyThreadB()
{
    os::DestroyThread(&g_ThreadB);
}
