﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nnt/nntest.h>

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>

#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/mem.h>

namespace {

/**
 * @brief   テストに与えるパラメータです。
 */
enum StandardAllocatorTestParam
{
    StandardAllocatorTestParam_DisableThreadCache = 0,  //!< スレッドキャッシュを利用しない
    StandardAllocatorTestParam_EnableThreadCache        //!< スレッドキャッシュを利用する
};

struct RealTestCommand
{
    char   type;       // 1=alloc 2=free
    size_t size;       // size for alloc, or index number for free
    size_t alignment;
    void*  ptr;

};

RealTestCommand g_CommandList1[] = {
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 112, 4, nullptr },
    { 1, 16777216, 131072, nullptr },
    { 1, 1048576, 131072, nullptr },
    { 1, 167772160, 131072, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 112, 4, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 112, 4, nullptr },
    { 2, 9, 0, nullptr },
    { 2, 10, 0, nullptr },
    { 2, 11, 0, nullptr },
    { 2, 6, 0, nullptr },
    { 2, 7, 0, nullptr },
    { 2, 8, 0, nullptr },
};

RealTestCommand g_CommandList2[] = {
    { 1, 232, 8, nullptr },
    { 1, 131072, 8, nullptr },
    { 1, 232, 8, nullptr },
    { 1, 131072, 8, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 64, 4, nullptr },
    { 1, 216, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 64, 4, nullptr },
    { 1, 216, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 64, 4, nullptr },
    { 1, 216, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 64, 4, nullptr },
    { 1, 216, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 64, 4, nullptr },
    { 1, 216, 4, nullptr },
    { 1, 432, 4, nullptr },
    { 1, 432, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 64, 4, nullptr },
    { 1, 216, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 64, 4, nullptr },
    { 1, 216, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 64, 4, nullptr },
    { 1, 216, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 64, 4, nullptr },
    { 1, 216, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 64, 4, nullptr },
    { 1, 216, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 1024, 4, nullptr },
    { 1, 1024, 4, nullptr },
    { 1, 2048, 4, nullptr },
    { 1, 8192, 4, nullptr },
    { 1, 16384, 4, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 2, 56, 0, nullptr },
    { 2, 57, 0, nullptr },
    { 2, 58, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 214316, 4, nullptr },
    { 2, 62, 0, nullptr },
    { 2, 63, 0, nullptr },
    { 2, 64, 0, nullptr },
    { 2, 65, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 214316, 4096, nullptr },
    { 2, 70, 0, nullptr },
    { 2, 71, 0, nullptr },
    { 2, 72, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 2, 77, 0, nullptr },
    { 2, 78, 0, nullptr },
    { 2, 79, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 99364, 4, nullptr },
    { 2, 83, 0, nullptr },
    { 2, 84, 0, nullptr },
    { 2, 85, 0, nullptr },
    { 2, 86, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 99364, 4096, nullptr },
    { 2, 91, 0, nullptr },
    { 2, 92, 0, nullptr },
    { 2, 93, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 2, 98, 0, nullptr },
    { 2, 99, 0, nullptr },
    { 2, 100, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 873020, 4, nullptr },
    { 2, 104, 0, nullptr },
    { 2, 105, 0, nullptr },
    { 2, 106, 0, nullptr },
    { 2, 107, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 873020, 4096, nullptr },
    { 2, 112, 0, nullptr },
    { 2, 113, 0, nullptr },
    { 2, 114, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 2, 119, 0, nullptr },
    { 2, 120, 0, nullptr },
    { 2, 121, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 31637284, 4, nullptr },
    { 2, 125, 0, nullptr },
    { 2, 126, 0, nullptr },
    { 2, 127, 0, nullptr },
    { 2, 128, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 31637284, 4096, nullptr },
    { 2, 133, 0, nullptr },
    { 2, 134, 0, nullptr },
    { 2, 135, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 2, 140, 0, nullptr },
    { 2, 141, 0, nullptr },
    { 2, 142, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 394908, 4, nullptr },
    { 2, 146, 0, nullptr },
    { 2, 147, 0, nullptr },
    { 2, 148, 0, nullptr },
    { 2, 149, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 394908, 4096, nullptr },
    { 2, 154, 0, nullptr },
    { 2, 155, 0, nullptr },
    { 2, 156, 0, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 120, 4, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 207084, 4, nullptr },
    { 2, 164, 0, nullptr },
    { 2, 165, 0, nullptr },
    { 2, 166, 0, nullptr },
    { 2, 167, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 207084, 4096, nullptr },
    { 2, 172, 0, nullptr },
    { 2, 173, 0, nullptr },
    { 2, 174, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 103804756, 4, nullptr },
    { 2, 179, 0, nullptr },
    { 2, 180, 0, nullptr },
    { 2, 181, 0, nullptr },
    { 2, 182, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 103804756, 4096, nullptr },
    { 2, 187, 0, nullptr },
    { 2, 188, 0, nullptr },
    { 2, 189, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 1746940, 4, nullptr },
    { 2, 194, 0, nullptr },
    { 2, 195, 0, nullptr },
    { 2, 196, 0, nullptr },
    { 2, 197, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 1746940, 4096, nullptr },
    { 2, 202, 0, nullptr },
    { 2, 203, 0, nullptr },
    { 2, 204, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 15317740, 4, nullptr },
    { 2, 209, 0, nullptr },
    { 2, 210, 0, nullptr },
    { 2, 211, 0, nullptr },
    { 2, 212, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 15317740, 4096, nullptr },
    { 2, 217, 0, nullptr },
    { 2, 218, 0, nullptr },
    { 2, 219, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 1393508, 4, nullptr },
    { 2, 224, 0, nullptr },
    { 2, 225, 0, nullptr },
    { 2, 226, 0, nullptr },
    { 2, 227, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 1393508, 4096, nullptr },
    { 2, 232, 0, nullptr },
    { 2, 233, 0, nullptr },
    { 2, 234, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 18908780, 4, nullptr },
    { 2, 239, 0, nullptr },
    { 2, 240, 0, nullptr },
    { 2, 241, 0, nullptr },
    { 2, 242, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 18908780, 4096, nullptr },
    { 2, 247, 0, nullptr },
    { 2, 248, 0, nullptr },
    { 2, 249, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 2237692, 4, nullptr },
    { 2, 254, 0, nullptr },
    { 2, 255, 0, nullptr },
    { 2, 256, 0, nullptr },
    { 2, 257, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 2237692, 4096, nullptr },
    { 2, 262, 0, nullptr },
    { 2, 263, 0, nullptr },
    { 2, 264, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 3574468, 4, nullptr },
    { 2, 269, 0, nullptr },
    { 2, 270, 0, nullptr },
    { 2, 271, 0, nullptr },
    { 2, 272, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 3574468, 4096, nullptr },
    { 2, 277, 0, nullptr },
    { 2, 278, 0, nullptr },
    { 2, 279, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 35268, 4, nullptr },
    { 2, 284, 0, nullptr },
    { 2, 285, 0, nullptr },
    { 2, 286, 0, nullptr },
    { 2, 287, 0, nullptr },
    { 1, 56, 4, nullptr },
    { 1, 16, 4, nullptr },
    { 1, 40, 4, nullptr },
    { 1, 35268, 4096, nullptr },
    { 2, 292, 0, nullptr },
    { 2, 293, 0, nullptr },
    { 2, 294, 0, nullptr },
    { 1, 17080, 4, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 1232, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 1388184, 4, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 64944, 16, nullptr },
    { 1, 8720, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 5280, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 440, 8, nullptr },
    { 1, 440, 8, nullptr },
    { 1, 440, 8, nullptr },
    { 1, 440, 8, nullptr },
    { 1, 440, 8, nullptr },
    { 1, 440, 8, nullptr },
    { 1, 440, 8, nullptr },
    { 1, 440, 8, nullptr },
    { 1, 480, 8, nullptr },
    { 1, 480, 8, nullptr },
    { 1, 480, 8, nullptr },
    { 1, 480, 8, nullptr },
    { 1, 47832, 4, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 5872, 16, nullptr },
    { 1, 808, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 2080, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 148, 8, nullptr },
    { 1, 148, 8, nullptr },
    { 1, 148, 8, nullptr },
    { 1, 148, 8, nullptr },
    { 1, 17080, 4, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 1232, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 129776, 4, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 13200, 16, nullptr },
    { 1, 1296, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 4400, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 296, 8, nullptr },
    { 1, 296, 8, nullptr },
    { 1, 296, 8, nullptr },
    { 1, 296, 8, nullptr },
    { 1, 296, 8, nullptr },
    { 1, 296, 8, nullptr },
    { 1, 296, 8, nullptr },
    { 1, 296, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 216784, 4, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 19088, 16, nullptr },
    { 1, 1832, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 5360, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 320, 8, nullptr },
    { 1, 320, 8, nullptr },
    { 1, 320, 8, nullptr },
    { 1, 320, 8, nullptr },
    { 1, 320, 8, nullptr },
    { 1, 320, 8, nullptr },
    { 1, 320, 8, nullptr },
    { 1, 320, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 34144, 4, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 4864, 16, nullptr },
    { 1, 736, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 1520, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 144, 8, nullptr },
    { 1, 144, 8, nullptr },
    { 1, 144, 8, nullptr },
    { 1, 144, 8, nullptr },
    { 1, 247536, 4, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 16, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 24, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 20784, 16, nullptr },
    { 1, 2008, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 320, 8, nullptr },
    { 1, 320, 8, nullptr },
    { 1, 320, 8, nullptr },
    { 1, 320, 8, nullptr },
    { 1, 320, 8, nullptr },
    { 1, 320, 8, nullptr },
    { 1, 320, 8, nullptr },
    { 1, 320, 8, nullptr },
    { 1, 196, 8, nullptr },
    { 1, 196, 8, nullptr },
    { 1, 196, 8, nullptr },
    { 1, 196, 8, nullptr },
    { 1, 17080, 4, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 1248, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 34144, 4, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 44, 8, nullptr },
    { 1, 48, 8, nullptr },
    { 1, 1968, 16, nullptr },
    { 1, 736, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 144, 8, nullptr },
    { 1, 144, 8, nullptr },
    { 1, 144, 8, nullptr },
    { 1, 144, 8, nullptr },
    { 1, 17080, 4, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 188, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 168, 8, nullptr },
    { 1, 8, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 12, 8, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 72, 4, nullptr },
    { 1, 2048, 4, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 948, 16, nullptr },
    { 1, 632, 16, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 68, 8, nullptr },
    { 1, 80, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 5920, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 128, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 288, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 140, 8, nullptr },
    { 1, 72, 4, nullptr },
    { 2, 3555, 0, nullptr },
    { 2, 1850, 0, nullptr },
    { 2, 1851, 0, nullptr },
    { 2, 1852, 0, nullptr },
    { 2, 1853, 0, nullptr },
    { 2, 1854, 0, nullptr },
    { 2, 1855, 0, nullptr },
    { 2, 1856, 0, nullptr },
    { 2, 1857, 0, nullptr },
    { 2, 1858, 0, nullptr },
    { 2, 1859, 0, nullptr },
    { 2, 1860, 0, nullptr },
    { 2, 1861, 0, nullptr },
    { 2, 1862, 0, nullptr },
    { 2, 1863, 0, nullptr },
    { 2, 1864, 0, nullptr },
    { 2, 1865, 0, nullptr },
    { 2, 1866, 0, nullptr },
    { 2, 1867, 0, nullptr },
    { 2, 1868, 0, nullptr },
    { 2, 1869, 0, nullptr },
    { 2, 1870, 0, nullptr },
    { 2, 1334, 0, nullptr },
    { 2, 1335, 0, nullptr },
    { 2, 1336, 0, nullptr },
    { 2, 1337, 0, nullptr },
    { 2, 1338, 0, nullptr },
    { 2, 1339, 0, nullptr },
    { 2, 1340, 0, nullptr },
    { 2, 1341, 0, nullptr },
    { 2, 1342, 0, nullptr },
    { 2, 1343, 0, nullptr },
    { 2, 1344, 0, nullptr },
    { 2, 1345, 0, nullptr },
    { 2, 1346, 0, nullptr },
    { 2, 1347, 0, nullptr },
    { 2, 1348, 0, nullptr },
    { 2, 1349, 0, nullptr },
    { 2, 1350, 0, nullptr },
    { 2, 1351, 0, nullptr },
    { 2, 1352, 0, nullptr },
    { 2, 1353, 0, nullptr },
    { 2, 1354, 0, nullptr },
    { 2, 1355, 0, nullptr },
    { 2, 1356, 0, nullptr },
    { 2, 1357, 0, nullptr },
    { 2, 1358, 0, nullptr },
    { 2, 1359, 0, nullptr },
    { 2, 1360, 0, nullptr },
    { 2, 1361, 0, nullptr },
    { 2, 1362, 0, nullptr },
    { 2, 1363, 0, nullptr },
    { 2, 1364, 0, nullptr },
    { 2, 1365, 0, nullptr },
    { 2, 1366, 0, nullptr },
    { 2, 1367, 0, nullptr },
    { 2, 1368, 0, nullptr },
    { 2, 1369, 0, nullptr },
    { 2, 1370, 0, nullptr },
    { 2, 1371, 0, nullptr },
    { 2, 1372, 0, nullptr },
    { 2, 1373, 0, nullptr },
    { 2, 1374, 0, nullptr },
    { 2, 1375, 0, nullptr },
    { 2, 1376, 0, nullptr },
    { 2, 1377, 0, nullptr },
    { 2, 1378, 0, nullptr },
    { 2, 1379, 0, nullptr },
    { 2, 1380, 0, nullptr },
    { 2, 1381, 0, nullptr },
    { 2, 1382, 0, nullptr },
    { 2, 1383, 0, nullptr },
    { 2, 1384, 0, nullptr },
    { 2, 1385, 0, nullptr },
    { 2, 1386, 0, nullptr },
    { 2, 1387, 0, nullptr },
    { 2, 1388, 0, nullptr },
    { 2, 1389, 0, nullptr },
    { 2, 1390, 0, nullptr },
    { 2, 1391, 0, nullptr },
    { 2, 1392, 0, nullptr },
    { 2, 1393, 0, nullptr },
    { 2, 1394, 0, nullptr },
    { 2, 1395, 0, nullptr },
    { 2, 1396, 0, nullptr },
    { 2, 1397, 0, nullptr },
    { 2, 1398, 0, nullptr },
    { 2, 1399, 0, nullptr },
    { 2, 1400, 0, nullptr },
    { 2, 1401, 0, nullptr },
    { 2, 1402, 0, nullptr },
    { 2, 1403, 0, nullptr },
    { 2, 1404, 0, nullptr },
    { 2, 1405, 0, nullptr },
    { 2, 1406, 0, nullptr },
    { 2, 1407, 0, nullptr },
    { 2, 1408, 0, nullptr },
    { 2, 1409, 0, nullptr },
    { 2, 1410, 0, nullptr },
    { 2, 1411, 0, nullptr },
    { 2, 1412, 0, nullptr },
    { 2, 1413, 0, nullptr },
    { 2, 1414, 0, nullptr },
    { 2, 1415, 0, nullptr },
    { 2, 1416, 0, nullptr },
    { 2, 1417, 0, nullptr },
    { 2, 1418, 0, nullptr },
    { 2, 1419, 0, nullptr },
    { 2, 1420, 0, nullptr },
    { 2, 1421, 0, nullptr },
    { 2, 1422, 0, nullptr },
    { 2, 1423, 0, nullptr },
    { 2, 1424, 0, nullptr },
    { 2, 1425, 0, nullptr },
    { 2, 1426, 0, nullptr },
    { 2, 1427, 0, nullptr },
    { 2, 1428, 0, nullptr },
    { 2, 1429, 0, nullptr },
    { 2, 1430, 0, nullptr },
    { 2, 1431, 0, nullptr },
    { 2, 1432, 0, nullptr },
    { 2, 1433, 0, nullptr },
    { 2, 1434, 0, nullptr },
    { 2, 1435, 0, nullptr },
    { 2, 1436, 0, nullptr },
    { 2, 1437, 0, nullptr },
    { 2, 1438, 0, nullptr },
    { 2, 1439, 0, nullptr },
    { 2, 1440, 0, nullptr },
    { 2, 1441, 0, nullptr },
    { 2, 1442, 0, nullptr },
    { 2, 1443, 0, nullptr },
    { 2, 1444, 0, nullptr },
    { 2, 1445, 0, nullptr },
    { 2, 1446, 0, nullptr },
    { 2, 1447, 0, nullptr },
    { 2, 1448, 0, nullptr },
    { 2, 1449, 0, nullptr },
    { 2, 1450, 0, nullptr },
    { 2, 1451, 0, nullptr },
    { 2, 1452, 0, nullptr },
    { 2, 1453, 0, nullptr },
    { 2, 1454, 0, nullptr },
    { 2, 1455, 0, nullptr },
    { 2, 1456, 0, nullptr },
    { 2, 1457, 0, nullptr },
    { 2, 1458, 0, nullptr },
    { 2, 1459, 0, nullptr },
    { 2, 1460, 0, nullptr },
    { 2, 1461, 0, nullptr },
    { 2, 1462, 0, nullptr },
    { 2, 1463, 0, nullptr },
    { 2, 1464, 0, nullptr },
    { 2, 1465, 0, nullptr },
    { 2, 1466, 0, nullptr },
    { 2, 1467, 0, nullptr },
    { 2, 1468, 0, nullptr },
    { 2, 1469, 0, nullptr },
    { 2, 1470, 0, nullptr },
    { 2, 1471, 0, nullptr },
    { 2, 1472, 0, nullptr },
    { 2, 1473, 0, nullptr },
    { 2, 1474, 0, nullptr },
    { 2, 1475, 0, nullptr },
    { 2, 1476, 0, nullptr },
    { 2, 1477, 0, nullptr },
    { 2, 1478, 0, nullptr },
    { 2, 1479, 0, nullptr },
    { 2, 1480, 0, nullptr },
    { 2, 1481, 0, nullptr },
    { 2, 1482, 0, nullptr },
    { 2, 1483, 0, nullptr },
    { 2, 1484, 0, nullptr },
    { 2, 1485, 0, nullptr },
    { 2, 1486, 0, nullptr },
    { 2, 1487, 0, nullptr },
    { 2, 1488, 0, nullptr },
    { 2, 1489, 0, nullptr },
    { 2, 1490, 0, nullptr },
    { 2, 1491, 0, nullptr },
    { 2, 1492, 0, nullptr },
    { 2, 1493, 0, nullptr },
    { 2, 1494, 0, nullptr },
    { 2, 1495, 0, nullptr },
    { 2, 1496, 0, nullptr },
    { 2, 1497, 0, nullptr },
    { 2, 1498, 0, nullptr },
    { 2, 1499, 0, nullptr },
    { 2, 1500, 0, nullptr },
    { 2, 1501, 0, nullptr },
    { 2, 1502, 0, nullptr },
    { 2, 1503, 0, nullptr },
    { 2, 1504, 0, nullptr },
    { 2, 1505, 0, nullptr },
    { 2, 1506, 0, nullptr },
    { 2, 1507, 0, nullptr },
    { 2, 1508, 0, nullptr },
    { 2, 1509, 0, nullptr },
    { 2, 1510, 0, nullptr },
    { 2, 1511, 0, nullptr },
    { 2, 1512, 0, nullptr },
    { 2, 1513, 0, nullptr },
    { 2, 1514, 0, nullptr },
    { 2, 1515, 0, nullptr },
    { 2, 1516, 0, nullptr },
    { 2, 1517, 0, nullptr },
    { 2, 1518, 0, nullptr },
    { 2, 1519, 0, nullptr },
    { 2, 1520, 0, nullptr },
    { 2, 1521, 0, nullptr },
    { 2, 1522, 0, nullptr },
    { 2, 1523, 0, nullptr },
    { 2, 1524, 0, nullptr },
    { 2, 1525, 0, nullptr },
    { 2, 1526, 0, nullptr },
    { 2, 1527, 0, nullptr },
    { 2, 1528, 0, nullptr },
    { 2, 1529, 0, nullptr },
    { 2, 1530, 0, nullptr },
    { 2, 1531, 0, nullptr },
    { 2, 1532, 0, nullptr },
    { 2, 1533, 0, nullptr },
    { 2, 1534, 0, nullptr },
    { 2, 1535, 0, nullptr },
    { 2, 1536, 0, nullptr },
    { 2, 1537, 0, nullptr },
    { 2, 1538, 0, nullptr },
    { 2, 1539, 0, nullptr },
    { 2, 1540, 0, nullptr },
    { 2, 1541, 0, nullptr },
    { 2, 1542, 0, nullptr },
    { 2, 1543, 0, nullptr },
    { 2, 1544, 0, nullptr },
    { 2, 1545, 0, nullptr },
    { 2, 1546, 0, nullptr },
    { 2, 1547, 0, nullptr },
    { 2, 1548, 0, nullptr },
    { 2, 1549, 0, nullptr },
    { 2, 1550, 0, nullptr },
    { 2, 1551, 0, nullptr },
    { 2, 1552, 0, nullptr },
    { 2, 1553, 0, nullptr },
    { 2, 1554, 0, nullptr },
    { 2, 1555, 0, nullptr },
    { 2, 1556, 0, nullptr },
    { 2, 1557, 0, nullptr },
    { 2, 1558, 0, nullptr },
    { 2, 1559, 0, nullptr },
    { 2, 1560, 0, nullptr },
    { 2, 1561, 0, nullptr },
    { 2, 1562, 0, nullptr },
    { 2, 1563, 0, nullptr },
    { 2, 1564, 0, nullptr },
    { 2, 1565, 0, nullptr },
    { 2, 1566, 0, nullptr },
    { 2, 1567, 0, nullptr },
    { 2, 1568, 0, nullptr },
    { 2, 1569, 0, nullptr },
    { 2, 1570, 0, nullptr },
    { 2, 1571, 0, nullptr },
    { 2, 1572, 0, nullptr },
    { 2, 1573, 0, nullptr },
    { 2, 1574, 0, nullptr },
    { 2, 1575, 0, nullptr },
    { 2, 1576, 0, nullptr },
    { 2, 1577, 0, nullptr },
    { 2, 1578, 0, nullptr },
    { 2, 1579, 0, nullptr },
    { 2, 1580, 0, nullptr },
    { 2, 1581, 0, nullptr },
    { 2, 1582, 0, nullptr },
    { 2, 1583, 0, nullptr },
    { 2, 1584, 0, nullptr },
    { 2, 1585, 0, nullptr },
    { 2, 1586, 0, nullptr },
    { 2, 1587, 0, nullptr },
    { 2, 1588, 0, nullptr },
    { 2, 1589, 0, nullptr },
    { 2, 1590, 0, nullptr },
    { 2, 1591, 0, nullptr },
    { 2, 1592, 0, nullptr },
    { 2, 1593, 0, nullptr },
    { 2, 1594, 0, nullptr },
    { 2, 1595, 0, nullptr },
    { 2, 1596, 0, nullptr },
    { 2, 1597, 0, nullptr },
    { 2, 1598, 0, nullptr },
    { 2, 1599, 0, nullptr },
    { 2, 1600, 0, nullptr },
    { 2, 1601, 0, nullptr },
    { 2, 1602, 0, nullptr },
    { 2, 1603, 0, nullptr },
    { 2, 1604, 0, nullptr },
    { 2, 1605, 0, nullptr },
    { 2, 1606, 0, nullptr },
    { 2, 1607, 0, nullptr },
    { 2, 1608, 0, nullptr },
    { 2, 1609, 0, nullptr },
    { 2, 1610, 0, nullptr },
    { 2, 1611, 0, nullptr },
    { 2, 1612, 0, nullptr },
    { 2, 1613, 0, nullptr },
    { 2, 1614, 0, nullptr },
    { 2, 1615, 0, nullptr },
    { 2, 1616, 0, nullptr },
    { 2, 1617, 0, nullptr },
    { 2, 1618, 0, nullptr },
    { 2, 1619, 0, nullptr },
    { 2, 1620, 0, nullptr },
    { 2, 1621, 0, nullptr },
    { 2, 1622, 0, nullptr },
    { 2, 1623, 0, nullptr },
    { 2, 1624, 0, nullptr },
    { 2, 1625, 0, nullptr },
    { 2, 1626, 0, nullptr },
    { 2, 1627, 0, nullptr },
    { 2, 1628, 0, nullptr },
    { 2, 1629, 0, nullptr },
    { 2, 1630, 0, nullptr },
    { 2, 1631, 0, nullptr },
    { 2, 1632, 0, nullptr },
    { 2, 1633, 0, nullptr },
    { 2, 1634, 0, nullptr },
    { 2, 1635, 0, nullptr },
    { 2, 1636, 0, nullptr },
    { 2, 1637, 0, nullptr },
    { 2, 1638, 0, nullptr },
    { 2, 1639, 0, nullptr },
    { 2, 1640, 0, nullptr },
    { 2, 1641, 0, nullptr },
    { 2, 1642, 0, nullptr },
    { 2, 1643, 0, nullptr },
    { 2, 1644, 0, nullptr },
    { 2, 1645, 0, nullptr },
    { 2, 1646, 0, nullptr },
    { 2, 1647, 0, nullptr },
    { 2, 1648, 0, nullptr },
    { 2, 1649, 0, nullptr },
    { 2, 1650, 0, nullptr },
    { 2, 1651, 0, nullptr },
    { 2, 1652, 0, nullptr },
    { 2, 1653, 0, nullptr },
    { 2, 1654, 0, nullptr },
    { 2, 1655, 0, nullptr },
    { 2, 1656, 0, nullptr },
    { 2, 1657, 0, nullptr },
    { 2, 1658, 0, nullptr },
    { 2, 1659, 0, nullptr },
    { 2, 1660, 0, nullptr },
    { 2, 1661, 0, nullptr },
    { 2, 1662, 0, nullptr },
    { 2, 1663, 0, nullptr },
    { 2, 1664, 0, nullptr },
    { 2, 1665, 0, nullptr },
    { 2, 1666, 0, nullptr },
    { 2, 1667, 0, nullptr },
    { 2, 1668, 0, nullptr },
    { 2, 1669, 0, nullptr },
    { 2, 1670, 0, nullptr },
    { 2, 1671, 0, nullptr },
    { 2, 1672, 0, nullptr },
    { 2, 1673, 0, nullptr },
    { 2, 1674, 0, nullptr },
    { 2, 1675, 0, nullptr },
    { 2, 1676, 0, nullptr },
    { 2, 1677, 0, nullptr },
    { 2, 1678, 0, nullptr },
    { 2, 1679, 0, nullptr },
    { 2, 1680, 0, nullptr },
    { 2, 1681, 0, nullptr },
    { 2, 1682, 0, nullptr },
    { 2, 1683, 0, nullptr },
    { 2, 1684, 0, nullptr },
    { 2, 1685, 0, nullptr },
    { 2, 1686, 0, nullptr },
    { 2, 1687, 0, nullptr },
    { 2, 1688, 0, nullptr },
    { 2, 1689, 0, nullptr },
    { 2, 1690, 0, nullptr },
    { 2, 1691, 0, nullptr },
    { 2, 1692, 0, nullptr },
    { 2, 1693, 0, nullptr },
    { 2, 1694, 0, nullptr },
    { 2, 1695, 0, nullptr },
    { 2, 1696, 0, nullptr },
    { 2, 1697, 0, nullptr },
    { 2, 1698, 0, nullptr },
    { 2, 1699, 0, nullptr },
    { 2, 1700, 0, nullptr },
    { 2, 1701, 0, nullptr },
    { 2, 1702, 0, nullptr },
    { 2, 1703, 0, nullptr },
    { 2, 1704, 0, nullptr },
    { 2, 1705, 0, nullptr },
    { 2, 1706, 0, nullptr },
    { 2, 1707, 0, nullptr },
    { 2, 1708, 0, nullptr },
    { 2, 1709, 0, nullptr },
    { 2, 1710, 0, nullptr },
    { 2, 1711, 0, nullptr },
    { 2, 1712, 0, nullptr },
    { 2, 1713, 0, nullptr },
    { 2, 1714, 0, nullptr },
    { 2, 1715, 0, nullptr },
    { 2, 1716, 0, nullptr },
    { 2, 1717, 0, nullptr },
    { 2, 1718, 0, nullptr },
    { 2, 1719, 0, nullptr },
    { 2, 1720, 0, nullptr },
    { 2, 1721, 0, nullptr },
    { 2, 1722, 0, nullptr },
    { 2, 1723, 0, nullptr },
    { 2, 1724, 0, nullptr },
    { 2, 1725, 0, nullptr },
    { 2, 1726, 0, nullptr },
    { 2, 1727, 0, nullptr },
    { 2, 1728, 0, nullptr },
    { 2, 1729, 0, nullptr },
    { 2, 1730, 0, nullptr },
    { 2, 1731, 0, nullptr },
    { 2, 1732, 0, nullptr },
    { 2, 1733, 0, nullptr },
    { 2, 1734, 0, nullptr },
    { 2, 1735, 0, nullptr },
    { 2, 1736, 0, nullptr },
    { 2, 1737, 0, nullptr },
    { 2, 1738, 0, nullptr },
    { 2, 1739, 0, nullptr },
    { 2, 1740, 0, nullptr },
    { 2, 1741, 0, nullptr },
    { 2, 1742, 0, nullptr },
    { 2, 1743, 0, nullptr },
    { 2, 1744, 0, nullptr },
    { 2, 1745, 0, nullptr },
    { 2, 1746, 0, nullptr },
    { 2, 1747, 0, nullptr },
    { 2, 1748, 0, nullptr },
    { 2, 1749, 0, nullptr },
    { 2, 1750, 0, nullptr },
    { 2, 1751, 0, nullptr },
    { 2, 1752, 0, nullptr },
    { 2, 1753, 0, nullptr },
    { 2, 1754, 0, nullptr },
    { 2, 1755, 0, nullptr },
    { 2, 1756, 0, nullptr },
    { 2, 1757, 0, nullptr },
    { 2, 1758, 0, nullptr },
    { 2, 1759, 0, nullptr },
    { 2, 1760, 0, nullptr },
    { 2, 1761, 0, nullptr },
    { 2, 1762, 0, nullptr },
    { 2, 1763, 0, nullptr },
    { 2, 1764, 0, nullptr },
    { 2, 1765, 0, nullptr },
    { 2, 1766, 0, nullptr },
    { 2, 1767, 0, nullptr },
    { 2, 1768, 0, nullptr },
    { 2, 1769, 0, nullptr },
    { 2, 1770, 0, nullptr },
    { 2, 1771, 0, nullptr },
    { 2, 1772, 0, nullptr },
    { 2, 1773, 0, nullptr },
    { 2, 1774, 0, nullptr },
    { 2, 1775, 0, nullptr },
    { 2, 1776, 0, nullptr },
    { 2, 1777, 0, nullptr },
    { 2, 1778, 0, nullptr },
    { 2, 1779, 0, nullptr },
    { 2, 1780, 0, nullptr },
    { 2, 1781, 0, nullptr },
    { 2, 1782, 0, nullptr },
    { 2, 1783, 0, nullptr },
    { 2, 1784, 0, nullptr },
    { 2, 1785, 0, nullptr },
    { 2, 1786, 0, nullptr },
    { 2, 1787, 0, nullptr },
    { 2, 1788, 0, nullptr },
    { 2, 1789, 0, nullptr },
    { 2, 1790, 0, nullptr },
    { 2, 1791, 0, nullptr },
    { 2, 1792, 0, nullptr },
    { 2, 1793, 0, nullptr },
    { 2, 1794, 0, nullptr },
    { 2, 1795, 0, nullptr },
    { 2, 1796, 0, nullptr },
    { 2, 1797, 0, nullptr },
    { 2, 1798, 0, nullptr },
    { 2, 1799, 0, nullptr },
    { 2, 1800, 0, nullptr },
    { 2, 1801, 0, nullptr },
    { 2, 1802, 0, nullptr },
    { 2, 1803, 0, nullptr },
    { 2, 1804, 0, nullptr },
    { 2, 1805, 0, nullptr },
    { 2, 1806, 0, nullptr },
    { 2, 1807, 0, nullptr },
    { 2, 1808, 0, nullptr },
    { 2, 1809, 0, nullptr },
    { 2, 1810, 0, nullptr },
    { 2, 1811, 0, nullptr },
    { 2, 1812, 0, nullptr },
    { 2, 1813, 0, nullptr },
    { 2, 1814, 0, nullptr },
    { 2, 1815, 0, nullptr },
    { 2, 1816, 0, nullptr },
    { 2, 1817, 0, nullptr },
    { 2, 1818, 0, nullptr },
    { 2, 1819, 0, nullptr },
    { 2, 1820, 0, nullptr },
    { 2, 1821, 0, nullptr },
    { 2, 1822, 0, nullptr },
    { 2, 1823, 0, nullptr },
    { 2, 1824, 0, nullptr },
    { 2, 1825, 0, nullptr },
    { 2, 1826, 0, nullptr },
    { 2, 1827, 0, nullptr },
    { 2, 1828, 0, nullptr },
    { 2, 1829, 0, nullptr },
    { 2, 1830, 0, nullptr },
    { 2, 1831, 0, nullptr },
    { 2, 1832, 0, nullptr },
    { 2, 1833, 0, nullptr },
    { 2, 1834, 0, nullptr },
    { 2, 1835, 0, nullptr },
    { 2, 1836, 0, nullptr },
    { 2, 1837, 0, nullptr },
    { 2, 1838, 0, nullptr },
    { 2, 1839, 0, nullptr },
    { 2, 1840, 0, nullptr },
    { 2, 1841, 0, nullptr },
    { 2, 1842, 0, nullptr },
    { 2, 1843, 0, nullptr },
    { 2, 1844, 0, nullptr },
    { 2, 1845, 0, nullptr },
    { 2, 1846, 0, nullptr },
    { 2, 1847, 0, nullptr },
    { 2, 1848, 0, nullptr },
    { 2, 1849, 0, nullptr },
    { 2, 1333, 0, nullptr },
    { 2, 1332, 0, nullptr },
    { 2, 1922, 0, nullptr },
    { 2, 1923, 0, nullptr },
    { 2, 1924, 0, nullptr },
    { 2, 1925, 0, nullptr },
    { 2, 1926, 0, nullptr },
    { 2, 1927, 0, nullptr },
    { 2, 1928, 0, nullptr },
    { 2, 1929, 0, nullptr },
    { 2, 1930, 0, nullptr },
    { 2, 1931, 0, nullptr },
    { 2, 1932, 0, nullptr },
    { 2, 1933, 0, nullptr },
    { 2, 1934, 0, nullptr },
    { 2, 1935, 0, nullptr },
    { 2, 1936, 0, nullptr },
    { 2, 1937, 0, nullptr },
    { 2, 1938, 0, nullptr },
    { 2, 1939, 0, nullptr },
    { 2, 1940, 0, nullptr },
    { 2, 1941, 0, nullptr },
    { 2, 1942, 0, nullptr },
    { 2, 1904, 0, nullptr },
    { 2, 1905, 0, nullptr },
    { 2, 1906, 0, nullptr },
    { 2, 1907, 0, nullptr },
    { 2, 1908, 0, nullptr },
    { 2, 1909, 0, nullptr },
    { 2, 1910, 0, nullptr },
    { 2, 1911, 0, nullptr },
    { 2, 1912, 0, nullptr },
    { 2, 1913, 0, nullptr },
    { 2, 1914, 0, nullptr },
    { 2, 1915, 0, nullptr },
    { 2, 1916, 0, nullptr },
    { 2, 1917, 0, nullptr },
    { 2, 1918, 0, nullptr },
    { 2, 1919, 0, nullptr },
    { 2, 1920, 0, nullptr },
    { 2, 1921, 0, nullptr },
    { 2, 1903, 0, nullptr },
    { 2, 1902, 0, nullptr },
    { 2, 1970, 0, nullptr },
    { 2, 1971, 0, nullptr },
    { 2, 1972, 0, nullptr },
    { 2, 1973, 0, nullptr },
    { 2, 1974, 0, nullptr },
    { 2, 1975, 0, nullptr },
    { 2, 1976, 0, nullptr },
    { 2, 1977, 0, nullptr },
    { 2, 1978, 0, nullptr },
    { 2, 1979, 0, nullptr },
    { 2, 1980, 0, nullptr },
    { 2, 1981, 0, nullptr },
    { 2, 1982, 0, nullptr },
    { 2, 1983, 0, nullptr },
    { 2, 1984, 0, nullptr },
    { 2, 1985, 0, nullptr },
    { 2, 1986, 0, nullptr },
    { 2, 1987, 0, nullptr },
    { 2, 1988, 0, nullptr },
    { 2, 1989, 0, nullptr },
    { 2, 1990, 0, nullptr },
    { 2, 1964, 0, nullptr },
    { 2, 1965, 0, nullptr },
    { 2, 1966, 0, nullptr },
    { 2, 1967, 0, nullptr },
    { 2, 1968, 0, nullptr },
    { 2, 1969, 0, nullptr },
    { 2, 1963, 0, nullptr },
    { 2, 1962, 0, nullptr },
    { 2, 2138, 0, nullptr },
    { 2, 2139, 0, nullptr },
    { 2, 2140, 0, nullptr },
    { 2, 2141, 0, nullptr },
    { 2, 2142, 0, nullptr },
    { 2, 2143, 0, nullptr },
    { 2, 2144, 0, nullptr },
    { 2, 2145, 0, nullptr },
    { 2, 2146, 0, nullptr },
    { 2, 2147, 0, nullptr },
    { 2, 2148, 0, nullptr },
    { 2, 2149, 0, nullptr },
    { 2, 2150, 0, nullptr },
    { 2, 2151, 0, nullptr },
    { 2, 2152, 0, nullptr },
    { 2, 2153, 0, nullptr },
    { 2, 2154, 0, nullptr },
    { 2, 2155, 0, nullptr },
    { 2, 2156, 0, nullptr },
    { 2, 2157, 0, nullptr },
    { 2, 2158, 0, nullptr },
    { 2, 2090, 0, nullptr },
    { 2, 2091, 0, nullptr },
    { 2, 2092, 0, nullptr },
    { 2, 2093, 0, nullptr },
    { 2, 2094, 0, nullptr },
    { 2, 2095, 0, nullptr },
    { 2, 2096, 0, nullptr },
    { 2, 2097, 0, nullptr },
    { 2, 2098, 0, nullptr },
    { 2, 2099, 0, nullptr },
    { 2, 2100, 0, nullptr },
    { 2, 2101, 0, nullptr },
    { 2, 2102, 0, nullptr },
    { 2, 2103, 0, nullptr },
    { 2, 2104, 0, nullptr },
    { 2, 2105, 0, nullptr },
    { 2, 2106, 0, nullptr },
    { 2, 2107, 0, nullptr },
    { 2, 2108, 0, nullptr },
    { 2, 2109, 0, nullptr },
    { 2, 2110, 0, nullptr },
    { 2, 2111, 0, nullptr },
    { 2, 2112, 0, nullptr },
    { 2, 2113, 0, nullptr },
    { 2, 2114, 0, nullptr },
    { 2, 2115, 0, nullptr },
    { 2, 2116, 0, nullptr },
    { 2, 2117, 0, nullptr },
    { 2, 2118, 0, nullptr },
    { 2, 2119, 0, nullptr },
    { 2, 2120, 0, nullptr },
    { 2, 2121, 0, nullptr },
    { 2, 2122, 0, nullptr },
    { 2, 2123, 0, nullptr },
    { 2, 2124, 0, nullptr },
    { 2, 2125, 0, nullptr },
    { 2, 2126, 0, nullptr },
    { 2, 2127, 0, nullptr },
    { 2, 2128, 0, nullptr },
    { 2, 2129, 0, nullptr },
    { 2, 2130, 0, nullptr },
    { 2, 2131, 0, nullptr },
    { 2, 2132, 0, nullptr },
    { 2, 2133, 0, nullptr },
    { 2, 2134, 0, nullptr },
    { 2, 2135, 0, nullptr },
    { 2, 2136, 0, nullptr },
    { 2, 2137, 0, nullptr },
    { 2, 2089, 0, nullptr },
    { 2, 2088, 0, nullptr },
    { 2, 2438, 0, nullptr },
    { 2, 2439, 0, nullptr },
    { 2, 2440, 0, nullptr },
    { 2, 2441, 0, nullptr },
    { 2, 2442, 0, nullptr },
    { 2, 2443, 0, nullptr },
    { 2, 2444, 0, nullptr },
    { 2, 2445, 0, nullptr },
    { 2, 2446, 0, nullptr },
    { 2, 2447, 0, nullptr },
    { 2, 2448, 0, nullptr },
    { 2, 2449, 0, nullptr },
    { 2, 2450, 0, nullptr },
    { 2, 2451, 0, nullptr },
    { 2, 2452, 0, nullptr },
    { 2, 2453, 0, nullptr },
    { 2, 2454, 0, nullptr },
    { 2, 2455, 0, nullptr },
    { 2, 2456, 0, nullptr },
    { 2, 2457, 0, nullptr },
    { 2, 2458, 0, nullptr },
    { 2, 2360, 0, nullptr },
    { 2, 2361, 0, nullptr },
    { 2, 2362, 0, nullptr },
    { 2, 2363, 0, nullptr },
    { 2, 2364, 0, nullptr },
    { 2, 2365, 0, nullptr },
    { 2, 2366, 0, nullptr },
    { 2, 2367, 0, nullptr },
    { 2, 2368, 0, nullptr },
    { 2, 2369, 0, nullptr },
    { 2, 2370, 0, nullptr },
    { 2, 2371, 0, nullptr },
    { 2, 2372, 0, nullptr },
    { 2, 2373, 0, nullptr },
    { 2, 2374, 0, nullptr },
    { 2, 2375, 0, nullptr },
    { 2, 2376, 0, nullptr },
    { 2, 2377, 0, nullptr },
    { 2, 2378, 0, nullptr },
    { 2, 2379, 0, nullptr },
    { 2, 2380, 0, nullptr },
    { 2, 2381, 0, nullptr },
    { 2, 2382, 0, nullptr },
    { 2, 2383, 0, nullptr },
    { 2, 2384, 0, nullptr },
    { 2, 2385, 0, nullptr },
    { 2, 2386, 0, nullptr },
    { 2, 2387, 0, nullptr },
    { 2, 2388, 0, nullptr },
    { 2, 2389, 0, nullptr },
    { 2, 2390, 0, nullptr },
    { 2, 2391, 0, nullptr },
    { 2, 2392, 0, nullptr },
    { 2, 2393, 0, nullptr },
    { 2, 2394, 0, nullptr },
    { 2, 2395, 0, nullptr },
    { 2, 2396, 0, nullptr },
    { 2, 2397, 0, nullptr },
    { 2, 2398, 0, nullptr },
    { 2, 2399, 0, nullptr },
    { 2, 2400, 0, nullptr },
    { 2, 2401, 0, nullptr },
    { 2, 2402, 0, nullptr },
    { 2, 2403, 0, nullptr },
    { 2, 2404, 0, nullptr },
    { 2, 2405, 0, nullptr },
    { 2, 2406, 0, nullptr },
    { 2, 2407, 0, nullptr },
    { 2, 2408, 0, nullptr },
    { 2, 2409, 0, nullptr },
    { 2, 2410, 0, nullptr },
    { 2, 2411, 0, nullptr },
    { 2, 2412, 0, nullptr },
    { 2, 2413, 0, nullptr },
    { 2, 2414, 0, nullptr },
    { 2, 2415, 0, nullptr },
    { 2, 2416, 0, nullptr },
    { 2, 2417, 0, nullptr },
    { 2, 2418, 0, nullptr },
    { 2, 2419, 0, nullptr },
    { 2, 2420, 0, nullptr },
    { 2, 2421, 0, nullptr },
    { 2, 2422, 0, nullptr },
    { 2, 2423, 0, nullptr },
    { 2, 2424, 0, nullptr },
    { 2, 2425, 0, nullptr },
    { 2, 2426, 0, nullptr },
    { 2, 2427, 0, nullptr },
    { 2, 2428, 0, nullptr },
    { 2, 2429, 0, nullptr },
    { 2, 2430, 0, nullptr },
    { 2, 2431, 0, nullptr },
    { 2, 2432, 0, nullptr },
    { 2, 2433, 0, nullptr },
    { 2, 2434, 0, nullptr },
    { 2, 2435, 0, nullptr },
    { 2, 2436, 0, nullptr },
    { 2, 2437, 0, nullptr },
    { 2, 2359, 0, nullptr },
    { 2, 2358, 0, nullptr },
    { 2, 2510, 0, nullptr },
    { 2, 2511, 0, nullptr },
    { 2, 2512, 0, nullptr },
    { 2, 2513, 0, nullptr },
    { 2, 2514, 0, nullptr },
    { 2, 2515, 0, nullptr },
    { 2, 2516, 0, nullptr },
    { 2, 2517, 0, nullptr },
    { 2, 2518, 0, nullptr },
    { 2, 2519, 0, nullptr },
    { 2, 2520, 0, nullptr },
    { 2, 2521, 0, nullptr },
    { 2, 2522, 0, nullptr },
    { 2, 2523, 0, nullptr },
    { 2, 2524, 0, nullptr },
    { 2, 2525, 0, nullptr },
    { 2, 2526, 0, nullptr },
    { 2, 2527, 0, nullptr },
    { 2, 2528, 0, nullptr },
    { 2, 2529, 0, nullptr },
    { 2, 2530, 0, nullptr },
    { 2, 2498, 0, nullptr },
    { 2, 2499, 0, nullptr },
    { 2, 2500, 0, nullptr },
    { 2, 2501, 0, nullptr },
    { 2, 2502, 0, nullptr },
    { 2, 2503, 0, nullptr },
    { 2, 2504, 0, nullptr },
    { 2, 2505, 0, nullptr },
    { 2, 2506, 0, nullptr },
    { 2, 2507, 0, nullptr },
    { 2, 2508, 0, nullptr },
    { 2, 2509, 0, nullptr },
    { 2, 2497, 0, nullptr },
    { 2, 2496, 0, nullptr },
    { 2, 2834, 0, nullptr },
    { 2, 2835, 0, nullptr },
    { 2, 2836, 0, nullptr },
    { 2, 2837, 0, nullptr },
    { 2, 2838, 0, nullptr },
    { 2, 2839, 0, nullptr },
    { 2, 2840, 0, nullptr },
    { 2, 2841, 0, nullptr },
    { 2, 2842, 0, nullptr },
    { 2, 2843, 0, nullptr },
    { 2, 2844, 0, nullptr },
    { 2, 2845, 0, nullptr },
    { 2, 2846, 0, nullptr },
    { 2, 2847, 0, nullptr },
    { 2, 2848, 0, nullptr },
    { 2, 2849, 0, nullptr },
    { 2, 2850, 0, nullptr },
    { 2, 2851, 0, nullptr },
    { 2, 2852, 0, nullptr },
    { 2, 2853, 0, nullptr },
    { 2, 2854, 0, nullptr },
    { 2, 2744, 0, nullptr },
    { 2, 2745, 0, nullptr },
    { 2, 2746, 0, nullptr },
    { 2, 2747, 0, nullptr },
    { 2, 2748, 0, nullptr },
    { 2, 2749, 0, nullptr },
    { 2, 2750, 0, nullptr },
    { 2, 2751, 0, nullptr },
    { 2, 2752, 0, nullptr },
    { 2, 2753, 0, nullptr },
    { 2, 2754, 0, nullptr },
    { 2, 2755, 0, nullptr },
    { 2, 2756, 0, nullptr },
    { 2, 2757, 0, nullptr },
    { 2, 2758, 0, nullptr },
    { 2, 2759, 0, nullptr },
    { 2, 2760, 0, nullptr },
    { 2, 2761, 0, nullptr },
    { 2, 2762, 0, nullptr },
    { 2, 2763, 0, nullptr },
    { 2, 2764, 0, nullptr },
    { 2, 2765, 0, nullptr },
    { 2, 2766, 0, nullptr },
    { 2, 2767, 0, nullptr },
    { 2, 2768, 0, nullptr },
    { 2, 2769, 0, nullptr },
    { 2, 2770, 0, nullptr },
    { 2, 2771, 0, nullptr },
    { 2, 2772, 0, nullptr },
    { 2, 2773, 0, nullptr },
    { 2, 2774, 0, nullptr },
    { 2, 2775, 0, nullptr },
    { 2, 2776, 0, nullptr },
    { 2, 2777, 0, nullptr },
    { 2, 2778, 0, nullptr },
    { 2, 2779, 0, nullptr },
    { 2, 2780, 0, nullptr },
    { 2, 2781, 0, nullptr },
    { 2, 2782, 0, nullptr },
    { 2, 2783, 0, nullptr },
    { 2, 2784, 0, nullptr },
    { 2, 2785, 0, nullptr },
    { 2, 2786, 0, nullptr },
    { 2, 2787, 0, nullptr },
    { 2, 2788, 0, nullptr },
    { 2, 2789, 0, nullptr },
    { 2, 2790, 0, nullptr },
    { 2, 2791, 0, nullptr },
    { 2, 2792, 0, nullptr },
    { 2, 2793, 0, nullptr },
    { 2, 2794, 0, nullptr },
    { 2, 2795, 0, nullptr },
    { 2, 2796, 0, nullptr },
    { 2, 2797, 0, nullptr },
    { 2, 2798, 0, nullptr },
    { 2, 2799, 0, nullptr },
    { 2, 2800, 0, nullptr },
    { 2, 2801, 0, nullptr },
    { 2, 2802, 0, nullptr },
    { 2, 2803, 0, nullptr },
    { 2, 2804, 0, nullptr },
    { 2, 2805, 0, nullptr },
    { 2, 2806, 0, nullptr },
    { 2, 2807, 0, nullptr },
    { 2, 2808, 0, nullptr },
    { 2, 2809, 0, nullptr },
    { 2, 2810, 0, nullptr },
    { 2, 2811, 0, nullptr },
    { 2, 2812, 0, nullptr },
    { 2, 2813, 0, nullptr },
    { 2, 2814, 0, nullptr },
    { 2, 2815, 0, nullptr },
    { 2, 2816, 0, nullptr },
    { 2, 2817, 0, nullptr },
    { 2, 2818, 0, nullptr },
    { 2, 2819, 0, nullptr },
    { 2, 2820, 0, nullptr },
    { 2, 2821, 0, nullptr },
    { 2, 2822, 0, nullptr },
    { 2, 2823, 0, nullptr },
    { 2, 2824, 0, nullptr },
    { 2, 2825, 0, nullptr },
    { 2, 2826, 0, nullptr },
    { 2, 2827, 0, nullptr },
    { 2, 2828, 0, nullptr },
    { 2, 2829, 0, nullptr },
    { 2, 2830, 0, nullptr },
    { 2, 2831, 0, nullptr },
    { 2, 2832, 0, nullptr },
    { 2, 2833, 0, nullptr },
    { 2, 2743, 0, nullptr },
    { 2, 2742, 0, nullptr },
    { 2, 2882, 0, nullptr },
    { 2, 2883, 0, nullptr },
    { 2, 2884, 0, nullptr },
    { 2, 2885, 0, nullptr },
    { 2, 2886, 0, nullptr },
    { 2, 2887, 0, nullptr },
    { 2, 2888, 0, nullptr },
    { 2, 2889, 0, nullptr },
    { 2, 2890, 0, nullptr },
    { 2, 2891, 0, nullptr },
    { 2, 2892, 0, nullptr },
    { 2, 2893, 0, nullptr },
    { 2, 2894, 0, nullptr },
    { 2, 2895, 0, nullptr },
    { 2, 2896, 0, nullptr },
    { 2, 2897, 0, nullptr },
    { 2, 2898, 0, nullptr },
    { 2, 2899, 0, nullptr },
    { 2, 2900, 0, nullptr },
    { 2, 2901, 0, nullptr },
    { 2, 2902, 0, nullptr },
    { 2, 2876, 0, nullptr },
    { 2, 2877, 0, nullptr },
    { 2, 2878, 0, nullptr },
    { 2, 2879, 0, nullptr },
    { 2, 2880, 0, nullptr },
    { 2, 2881, 0, nullptr },
    { 2, 2875, 0, nullptr },
    { 2, 2874, 0, nullptr },
    { 2, 2954, 0, nullptr },
    { 2, 2955, 0, nullptr },
    { 2, 2956, 0, nullptr },
    { 2, 2957, 0, nullptr },
    { 2, 2958, 0, nullptr },
    { 2, 2959, 0, nullptr },
    { 2, 2960, 0, nullptr },
    { 2, 2961, 0, nullptr },
    { 2, 2962, 0, nullptr },
    { 2, 2963, 0, nullptr },
    { 2, 2964, 0, nullptr },
    { 2, 2965, 0, nullptr },
    { 2, 2966, 0, nullptr },
    { 2, 2967, 0, nullptr },
    { 2, 2968, 0, nullptr },
    { 2, 2969, 0, nullptr },
    { 2, 2970, 0, nullptr },
    { 2, 2971, 0, nullptr },
    { 2, 2972, 0, nullptr },
    { 2, 2973, 0, nullptr },
    { 2, 2974, 0, nullptr },
    { 2, 2942, 0, nullptr },
    { 2, 2943, 0, nullptr },
    { 2, 2944, 0, nullptr },
    { 2, 2945, 0, nullptr },
    { 2, 2946, 0, nullptr },
    { 2, 2947, 0, nullptr },
    { 2, 2948, 0, nullptr },
    { 2, 2949, 0, nullptr },
    { 2, 2950, 0, nullptr },
    { 2, 2951, 0, nullptr },
    { 2, 2952, 0, nullptr },
    { 2, 2953, 0, nullptr },
    { 2, 2941, 0, nullptr },
    { 2, 2940, 0, nullptr },
    { 2, 326, 0, nullptr },
    { 2, 327, 0, nullptr },
    { 2, 328, 0, nullptr },
    { 2, 329, 0, nullptr },
    { 2, 330, 0, nullptr },
    { 2, 331, 0, nullptr },
    { 2, 332, 0, nullptr },
    { 2, 333, 0, nullptr },
    { 2, 334, 0, nullptr },
    { 2, 335, 0, nullptr },
    { 2, 336, 0, nullptr },
    { 2, 337, 0, nullptr },
    { 2, 338, 0, nullptr },
    { 2, 339, 0, nullptr },
    { 2, 340, 0, nullptr },
    { 2, 341, 0, nullptr },
    { 2, 342, 0, nullptr },
    { 2, 343, 0, nullptr },
    { 2, 344, 0, nullptr },
    { 2, 345, 0, nullptr },
    { 2, 346, 0, nullptr },
    { 2, 320, 0, nullptr },
    { 2, 321, 0, nullptr },
    { 2, 322, 0, nullptr },
    { 2, 323, 0, nullptr },
    { 2, 324, 0, nullptr },
    { 2, 325, 0, nullptr },
    { 2, 319, 0, nullptr },
    { 2, 318, 0, nullptr },
    { 2, 300, 0, nullptr },
    { 2, 301, 0, nullptr },
    { 2, 302, 0, nullptr },
    { 2, 303, 0, nullptr },
    { 2, 304, 0, nullptr },
    { 2, 305, 0, nullptr },
    { 2, 306, 0, nullptr },
    { 2, 307, 0, nullptr },
    { 2, 308, 0, nullptr },
    { 2, 309, 0, nullptr },
    { 2, 310, 0, nullptr },
    { 2, 311, 0, nullptr },
    { 2, 312, 0, nullptr },
    { 2, 313, 0, nullptr },
    { 2, 314, 0, nullptr },
    { 2, 315, 0, nullptr },
    { 2, 316, 0, nullptr },
    { 2, 317, 0, nullptr },
    { 2, 299, 0, nullptr },
    { 2, 348, 0, nullptr },
    { 2, 349, 0, nullptr },
    { 2, 350, 0, nullptr },
    { 2, 351, 0, nullptr },
    { 2, 352, 0, nullptr },
    { 2, 353, 0, nullptr },
    { 2, 354, 0, nullptr },
    { 2, 355, 0, nullptr },
    { 2, 356, 0, nullptr },
    { 2, 357, 0, nullptr },
    { 2, 358, 0, nullptr },
    { 2, 359, 0, nullptr },
    { 2, 360, 0, nullptr },
    { 2, 361, 0, nullptr },
    { 2, 362, 0, nullptr },
    { 2, 363, 0, nullptr },
    { 2, 364, 0, nullptr },
    { 2, 365, 0, nullptr },
    { 2, 366, 0, nullptr },
    { 2, 367, 0, nullptr },
    { 2, 368, 0, nullptr },
    { 2, 369, 0, nullptr },
    { 2, 370, 0, nullptr },
    { 2, 371, 0, nullptr },
    { 2, 372, 0, nullptr },
    { 2, 373, 0, nullptr },
    { 2, 374, 0, nullptr },
    { 2, 375, 0, nullptr },
    { 2, 376, 0, nullptr },
    { 2, 377, 0, nullptr },
    { 2, 378, 0, nullptr },
    { 2, 379, 0, nullptr },
    { 2, 380, 0, nullptr },
    { 2, 381, 0, nullptr },
    { 2, 382, 0, nullptr },
    { 2, 383, 0, nullptr },
    { 2, 384, 0, nullptr },
    { 2, 385, 0, nullptr },
    { 2, 386, 0, nullptr },
    { 2, 387, 0, nullptr },
    { 2, 388, 0, nullptr },
    { 2, 389, 0, nullptr },
    { 2, 390, 0, nullptr },
    { 2, 391, 0, nullptr },
    { 2, 392, 0, nullptr },
    { 2, 393, 0, nullptr },
    { 2, 394, 0, nullptr },
    { 2, 395, 0, nullptr },
    { 2, 396, 0, nullptr },
    { 2, 397, 0, nullptr },
    { 2, 398, 0, nullptr },
    { 2, 399, 0, nullptr },
    { 2, 400, 0, nullptr },
    { 2, 401, 0, nullptr },
    { 2, 402, 0, nullptr },
    { 2, 403, 0, nullptr },
    { 2, 404, 0, nullptr },
    { 2, 405, 0, nullptr },
    { 2, 406, 0, nullptr },
    { 2, 407, 0, nullptr },
    { 2, 408, 0, nullptr },
    { 2, 409, 0, nullptr },
    { 2, 410, 0, nullptr },
    { 2, 411, 0, nullptr },
    { 2, 412, 0, nullptr },
    { 2, 413, 0, nullptr },
    { 2, 414, 0, nullptr },
    { 2, 415, 0, nullptr },
    { 2, 416, 0, nullptr },
    { 2, 417, 0, nullptr },
    { 2, 418, 0, nullptr },
    { 2, 419, 0, nullptr },
    { 2, 420, 0, nullptr },
    { 2, 421, 0, nullptr },
    { 2, 422, 0, nullptr },
    { 2, 423, 0, nullptr },
    { 2, 424, 0, nullptr },
    { 2, 425, 0, nullptr },
    { 2, 426, 0, nullptr },
    { 2, 427, 0, nullptr },
    { 2, 428, 0, nullptr },
    { 2, 429, 0, nullptr },
    { 2, 430, 0, nullptr },
    { 2, 431, 0, nullptr },
    { 2, 432, 0, nullptr },
    { 2, 433, 0, nullptr },
    { 2, 434, 0, nullptr },
    { 2, 435, 0, nullptr },
    { 2, 436, 0, nullptr },
    { 2, 437, 0, nullptr },
    { 2, 438, 0, nullptr },
    { 2, 439, 0, nullptr },
    { 2, 440, 0, nullptr },
    { 2, 441, 0, nullptr },
    { 2, 442, 0, nullptr },
    { 2, 443, 0, nullptr },
    { 2, 444, 0, nullptr },
    { 2, 445, 0, nullptr },
    { 2, 446, 0, nullptr },
    { 2, 447, 0, nullptr },
    { 2, 448, 0, nullptr },
    { 2, 449, 0, nullptr },
    { 2, 450, 0, nullptr },
    { 2, 451, 0, nullptr },
    { 2, 452, 0, nullptr },
    { 2, 453, 0, nullptr },
    { 2, 454, 0, nullptr },
    { 2, 455, 0, nullptr },
    { 2, 456, 0, nullptr },
    { 2, 457, 0, nullptr },
    { 2, 458, 0, nullptr },
    { 2, 459, 0, nullptr },
    { 2, 460, 0, nullptr },
    { 2, 461, 0, nullptr },
    { 2, 462, 0, nullptr },
    { 2, 463, 0, nullptr },
    { 2, 464, 0, nullptr },
    { 2, 465, 0, nullptr },
    { 2, 466, 0, nullptr },
    { 2, 467, 0, nullptr },
    { 2, 468, 0, nullptr },
    { 2, 469, 0, nullptr },
    { 2, 470, 0, nullptr },
    { 2, 471, 0, nullptr },
    { 2, 472, 0, nullptr },
    { 2, 473, 0, nullptr },
    { 2, 474, 0, nullptr },
    { 2, 475, 0, nullptr },
    { 2, 476, 0, nullptr },
    { 2, 477, 0, nullptr },
    { 2, 478, 0, nullptr },
    { 2, 479, 0, nullptr },
    { 2, 480, 0, nullptr },
    { 2, 481, 0, nullptr },
    { 2, 482, 0, nullptr },
    { 2, 483, 0, nullptr },
    { 2, 484, 0, nullptr },
    { 2, 485, 0, nullptr },
    { 2, 486, 0, nullptr },
    { 2, 487, 0, nullptr },
    { 2, 488, 0, nullptr },
    { 2, 489, 0, nullptr },
    { 2, 490, 0, nullptr },
    { 2, 491, 0, nullptr },
    { 2, 492, 0, nullptr },
    { 2, 493, 0, nullptr },
    { 2, 494, 0, nullptr },
    { 2, 495, 0, nullptr },
    { 2, 496, 0, nullptr },
    { 2, 497, 0, nullptr },
    { 2, 498, 0, nullptr },
    { 2, 499, 0, nullptr },
    { 2, 500, 0, nullptr },
    { 2, 501, 0, nullptr },
    { 2, 502, 0, nullptr },
    { 2, 503, 0, nullptr },
    { 2, 504, 0, nullptr },
    { 2, 505, 0, nullptr },
    { 2, 506, 0, nullptr },
    { 2, 507, 0, nullptr },
    { 2, 508, 0, nullptr },
    { 2, 509, 0, nullptr },
    { 2, 510, 0, nullptr },
    { 2, 511, 0, nullptr },
    { 2, 512, 0, nullptr },
    { 2, 513, 0, nullptr },
    { 2, 514, 0, nullptr },
    { 2, 515, 0, nullptr },
    { 2, 516, 0, nullptr },
    { 2, 517, 0, nullptr },
    { 2, 518, 0, nullptr },
    { 2, 519, 0, nullptr },
    { 2, 520, 0, nullptr },
    { 2, 521, 0, nullptr },
    { 2, 522, 0, nullptr },
    { 2, 523, 0, nullptr },
    { 2, 524, 0, nullptr },
    { 2, 525, 0, nullptr },
    { 2, 526, 0, nullptr },
    { 2, 527, 0, nullptr },
    { 2, 528, 0, nullptr },
    { 2, 529, 0, nullptr },
    { 2, 530, 0, nullptr },
    { 2, 531, 0, nullptr },
    { 2, 532, 0, nullptr },
    { 2, 533, 0, nullptr },
    { 2, 534, 0, nullptr },
    { 2, 535, 0, nullptr },
    { 2, 536, 0, nullptr },
    { 2, 537, 0, nullptr },
    { 2, 538, 0, nullptr },
    { 2, 539, 0, nullptr },
    { 2, 540, 0, nullptr },
    { 2, 541, 0, nullptr },
    { 2, 542, 0, nullptr },
    { 2, 543, 0, nullptr },
    { 2, 544, 0, nullptr },
    { 2, 545, 0, nullptr },
    { 2, 546, 0, nullptr },
    { 2, 547, 0, nullptr },
    { 2, 548, 0, nullptr },
    { 2, 549, 0, nullptr },
    { 2, 550, 0, nullptr },
    { 2, 551, 0, nullptr },
    { 2, 552, 0, nullptr },
    { 2, 553, 0, nullptr },
    { 2, 554, 0, nullptr },
    { 2, 555, 0, nullptr },
    { 2, 556, 0, nullptr },
    { 2, 557, 0, nullptr },
    { 2, 558, 0, nullptr },
    { 2, 559, 0, nullptr },
    { 2, 560, 0, nullptr },
    { 2, 561, 0, nullptr },
    { 2, 562, 0, nullptr },
    { 2, 563, 0, nullptr },
    { 2, 564, 0, nullptr },
    { 2, 565, 0, nullptr },
    { 2, 566, 0, nullptr },
    { 2, 567, 0, nullptr },
    { 2, 568, 0, nullptr },
    { 2, 569, 0, nullptr },
    { 2, 570, 0, nullptr },
    { 2, 571, 0, nullptr },
    { 2, 572, 0, nullptr },
    { 2, 573, 0, nullptr },
    { 2, 574, 0, nullptr },
    { 2, 575, 0, nullptr },
    { 2, 576, 0, nullptr },
    { 2, 577, 0, nullptr },
    { 2, 578, 0, nullptr },
    { 2, 579, 0, nullptr },
    { 2, 580, 0, nullptr },
    { 2, 581, 0, nullptr },
    { 2, 582, 0, nullptr },
    { 2, 583, 0, nullptr },
    { 2, 584, 0, nullptr },
    { 2, 585, 0, nullptr },
    { 2, 586, 0, nullptr },
    { 2, 587, 0, nullptr },
    { 2, 588, 0, nullptr },
    { 2, 589, 0, nullptr },
    { 2, 590, 0, nullptr },
    { 2, 591, 0, nullptr },
    { 2, 592, 0, nullptr },
    { 2, 593, 0, nullptr },
    { 2, 594, 0, nullptr },
    { 2, 595, 0, nullptr },
    { 2, 596, 0, nullptr },
    { 2, 597, 0, nullptr },
    { 2, 598, 0, nullptr },
    { 2, 599, 0, nullptr },
    { 2, 600, 0, nullptr },
    { 2, 601, 0, nullptr },
    { 2, 602, 0, nullptr },
    { 2, 603, 0, nullptr },
    { 2, 604, 0, nullptr },
    { 2, 605, 0, nullptr },
    { 2, 606, 0, nullptr },
    { 2, 607, 0, nullptr },
    { 2, 608, 0, nullptr },
    { 2, 609, 0, nullptr },
    { 2, 610, 0, nullptr },
    { 2, 611, 0, nullptr },
    { 2, 612, 0, nullptr },
    { 2, 613, 0, nullptr },
    { 2, 614, 0, nullptr },
    { 2, 615, 0, nullptr },
    { 2, 616, 0, nullptr },
    { 2, 617, 0, nullptr },
    { 2, 618, 0, nullptr },
    { 2, 619, 0, nullptr },
    { 2, 620, 0, nullptr },
    { 2, 621, 0, nullptr },
    { 2, 622, 0, nullptr },
    { 2, 623, 0, nullptr },
    { 2, 624, 0, nullptr },
    { 2, 625, 0, nullptr },
    { 2, 626, 0, nullptr },
    { 2, 627, 0, nullptr },
    { 2, 628, 0, nullptr },
    { 2, 629, 0, nullptr },
    { 2, 630, 0, nullptr },
    { 2, 631, 0, nullptr },
    { 2, 632, 0, nullptr },
    { 2, 633, 0, nullptr },
    { 2, 634, 0, nullptr },
    { 2, 635, 0, nullptr },
    { 2, 636, 0, nullptr },
    { 2, 637, 0, nullptr },
    { 2, 638, 0, nullptr },
    { 2, 639, 0, nullptr },
    { 2, 640, 0, nullptr },
    { 2, 641, 0, nullptr },
    { 2, 642, 0, nullptr },
    { 2, 643, 0, nullptr },
    { 2, 644, 0, nullptr },
    { 2, 645, 0, nullptr },
    { 2, 646, 0, nullptr },
    { 2, 647, 0, nullptr },
    { 2, 648, 0, nullptr },
    { 2, 649, 0, nullptr },
    { 2, 650, 0, nullptr },
    { 2, 651, 0, nullptr },
    { 2, 652, 0, nullptr },
    { 2, 653, 0, nullptr },
    { 2, 654, 0, nullptr },
    { 2, 655, 0, nullptr },
    { 2, 656, 0, nullptr },
    { 2, 657, 0, nullptr },
    { 2, 658, 0, nullptr },
    { 2, 659, 0, nullptr },
    { 2, 660, 0, nullptr },
    { 2, 661, 0, nullptr },
    { 2, 662, 0, nullptr },
    { 2, 663, 0, nullptr },
    { 2, 664, 0, nullptr },
    { 2, 665, 0, nullptr },
    { 2, 666, 0, nullptr },
    { 2, 667, 0, nullptr },
    { 2, 668, 0, nullptr },
    { 2, 669, 0, nullptr },
    { 2, 670, 0, nullptr },
    { 2, 671, 0, nullptr },
    { 2, 672, 0, nullptr },
    { 2, 673, 0, nullptr },
    { 2, 674, 0, nullptr },
    { 2, 675, 0, nullptr },
    { 2, 676, 0, nullptr },
    { 2, 677, 0, nullptr },
    { 2, 678, 0, nullptr },
    { 2, 679, 0, nullptr },
    { 2, 680, 0, nullptr },
    { 2, 681, 0, nullptr },
    { 2, 682, 0, nullptr },
    { 2, 683, 0, nullptr },
    { 2, 684, 0, nullptr },
    { 2, 685, 0, nullptr },
    { 2, 686, 0, nullptr },
    { 2, 687, 0, nullptr },
    { 2, 688, 0, nullptr },
    { 2, 689, 0, nullptr },
    { 2, 690, 0, nullptr },
    { 2, 691, 0, nullptr },
    { 2, 692, 0, nullptr },
    { 2, 693, 0, nullptr },
    { 2, 694, 0, nullptr },
    { 2, 695, 0, nullptr },
    { 2, 696, 0, nullptr },
    { 2, 697, 0, nullptr },
    { 2, 698, 0, nullptr },
    { 2, 699, 0, nullptr },
    { 2, 700, 0, nullptr },
    { 2, 701, 0, nullptr },
    { 2, 702, 0, nullptr },
    { 2, 703, 0, nullptr },
    { 2, 704, 0, nullptr },
    { 2, 705, 0, nullptr },
    { 2, 706, 0, nullptr },
    { 2, 707, 0, nullptr },
    { 2, 708, 0, nullptr },
    { 2, 709, 0, nullptr },
    { 2, 710, 0, nullptr },
    { 2, 711, 0, nullptr },
    { 2, 712, 0, nullptr },
    { 2, 713, 0, nullptr },
    { 2, 714, 0, nullptr },
    { 2, 715, 0, nullptr },
    { 2, 716, 0, nullptr },
    { 2, 717, 0, nullptr },
    { 2, 718, 0, nullptr },
    { 2, 719, 0, nullptr },
    { 2, 720, 0, nullptr },
    { 2, 721, 0, nullptr },
    { 2, 722, 0, nullptr },
    { 2, 723, 0, nullptr },
    { 2, 724, 0, nullptr },
    { 2, 725, 0, nullptr },
    { 2, 726, 0, nullptr },
    { 2, 727, 0, nullptr },
    { 2, 728, 0, nullptr },
    { 2, 729, 0, nullptr },
    { 2, 730, 0, nullptr },
    { 2, 731, 0, nullptr },
    { 2, 732, 0, nullptr },
    { 2, 733, 0, nullptr },
    { 2, 734, 0, nullptr },
    { 2, 735, 0, nullptr },
    { 2, 736, 0, nullptr },
    { 2, 737, 0, nullptr },
    { 2, 738, 0, nullptr },
    { 2, 739, 0, nullptr },
    { 2, 740, 0, nullptr },
    { 2, 741, 0, nullptr },
    { 2, 742, 0, nullptr },
    { 2, 743, 0, nullptr },
    { 2, 744, 0, nullptr },
    { 2, 745, 0, nullptr },
    { 2, 746, 0, nullptr },
    { 2, 747, 0, nullptr },
    { 2, 748, 0, nullptr },
    { 2, 749, 0, nullptr },
    { 2, 750, 0, nullptr },
    { 2, 751, 0, nullptr },
    { 2, 752, 0, nullptr },
    { 2, 753, 0, nullptr },
    { 2, 754, 0, nullptr },
    { 2, 755, 0, nullptr },
    { 2, 756, 0, nullptr },
    { 2, 757, 0, nullptr },
    { 2, 758, 0, nullptr },
    { 2, 759, 0, nullptr },
    { 2, 760, 0, nullptr },
    { 2, 761, 0, nullptr },
    { 2, 762, 0, nullptr },
    { 2, 763, 0, nullptr },
    { 2, 764, 0, nullptr },
    { 2, 765, 0, nullptr },
    { 2, 766, 0, nullptr },
    { 2, 767, 0, nullptr },
    { 2, 768, 0, nullptr },
    { 2, 769, 0, nullptr },
    { 2, 770, 0, nullptr },
    { 2, 771, 0, nullptr },
    { 2, 772, 0, nullptr },
    { 2, 773, 0, nullptr },
    { 2, 774, 0, nullptr },
    { 2, 775, 0, nullptr },
    { 2, 776, 0, nullptr },
    { 2, 777, 0, nullptr },
    { 2, 778, 0, nullptr },
    { 2, 779, 0, nullptr },
    { 2, 780, 0, nullptr },
    { 2, 781, 0, nullptr },
    { 2, 782, 0, nullptr },
    { 2, 783, 0, nullptr },
    { 2, 784, 0, nullptr },
    { 2, 785, 0, nullptr },
    { 2, 786, 0, nullptr },
    { 2, 787, 0, nullptr },
    { 2, 788, 0, nullptr },
    { 2, 789, 0, nullptr },
    { 2, 790, 0, nullptr },
    { 2, 791, 0, nullptr },
    { 2, 792, 0, nullptr },
    { 2, 793, 0, nullptr },
    { 2, 794, 0, nullptr },
    { 2, 795, 0, nullptr },
    { 2, 796, 0, nullptr },
    { 2, 797, 0, nullptr },
    { 2, 798, 0, nullptr },
    { 2, 799, 0, nullptr },
    { 2, 800, 0, nullptr },
    { 2, 801, 0, nullptr },
    { 2, 802, 0, nullptr },
    { 2, 803, 0, nullptr },
    { 2, 804, 0, nullptr },
    { 2, 805, 0, nullptr },
    { 2, 806, 0, nullptr },
    { 2, 807, 0, nullptr },
    { 2, 808, 0, nullptr },
    { 2, 809, 0, nullptr },
    { 2, 810, 0, nullptr },
    { 2, 811, 0, nullptr },
    { 2, 812, 0, nullptr },
    { 2, 813, 0, nullptr },
    { 2, 814, 0, nullptr },
    { 2, 815, 0, nullptr },
    { 2, 816, 0, nullptr },
    { 2, 817, 0, nullptr },
    { 2, 818, 0, nullptr },
    { 2, 819, 0, nullptr },
    { 2, 820, 0, nullptr },
    { 2, 821, 0, nullptr },
    { 2, 822, 0, nullptr },
    { 2, 823, 0, nullptr },
    { 2, 824, 0, nullptr },
    { 2, 825, 0, nullptr },
    { 2, 826, 0, nullptr },
    { 2, 827, 0, nullptr },
    { 2, 828, 0, nullptr },
    { 2, 829, 0, nullptr },
    { 2, 830, 0, nullptr },
    { 2, 831, 0, nullptr },
    { 2, 832, 0, nullptr },
    { 2, 833, 0, nullptr },
    { 2, 834, 0, nullptr },
    { 2, 835, 0, nullptr },
    { 2, 836, 0, nullptr },
    { 2, 837, 0, nullptr },
    { 2, 838, 0, nullptr },
    { 2, 839, 0, nullptr },
    { 2, 840, 0, nullptr },
    { 2, 841, 0, nullptr },
    { 2, 842, 0, nullptr },
    { 2, 843, 0, nullptr },
    { 2, 844, 0, nullptr },
    { 2, 845, 0, nullptr },
    { 2, 846, 0, nullptr },
    { 2, 847, 0, nullptr },
    { 2, 848, 0, nullptr },
    { 2, 849, 0, nullptr },
    { 2, 850, 0, nullptr },
    { 2, 851, 0, nullptr },
    { 2, 852, 0, nullptr },
    { 2, 853, 0, nullptr },
    { 2, 854, 0, nullptr },
    { 2, 855, 0, nullptr },
    { 2, 856, 0, nullptr },
    { 2, 857, 0, nullptr },
    { 2, 858, 0, nullptr },
    { 2, 859, 0, nullptr },
    { 2, 860, 0, nullptr },
    { 2, 861, 0, nullptr },
    { 2, 862, 0, nullptr },
    { 2, 863, 0, nullptr },
    { 2, 864, 0, nullptr },
    { 2, 865, 0, nullptr },
    { 2, 866, 0, nullptr },
    { 2, 867, 0, nullptr },
    { 2, 868, 0, nullptr },
    { 2, 869, 0, nullptr },
    { 2, 870, 0, nullptr },
    { 2, 871, 0, nullptr },
    { 2, 872, 0, nullptr },
    { 2, 873, 0, nullptr },
    { 2, 874, 0, nullptr },
    { 2, 875, 0, nullptr },
    { 2, 876, 0, nullptr },
    { 2, 877, 0, nullptr },
    { 2, 878, 0, nullptr },
    { 2, 879, 0, nullptr },
    { 2, 880, 0, nullptr },
    { 2, 881, 0, nullptr },
    { 2, 882, 0, nullptr },
    { 2, 883, 0, nullptr },
    { 2, 884, 0, nullptr },
    { 2, 885, 0, nullptr },
    { 2, 886, 0, nullptr },
    { 2, 887, 0, nullptr },
    { 2, 888, 0, nullptr },
    { 2, 889, 0, nullptr },
    { 2, 890, 0, nullptr },
    { 2, 891, 0, nullptr },
    { 2, 892, 0, nullptr },
    { 2, 893, 0, nullptr },
    { 2, 894, 0, nullptr },
    { 2, 895, 0, nullptr },
    { 2, 896, 0, nullptr },
    { 2, 897, 0, nullptr },
    { 2, 898, 0, nullptr },
    { 2, 899, 0, nullptr },
    { 2, 900, 0, nullptr },
    { 2, 901, 0, nullptr },
    { 2, 902, 0, nullptr },
    { 2, 903, 0, nullptr },
    { 2, 904, 0, nullptr },
    { 2, 905, 0, nullptr },
    { 2, 906, 0, nullptr },
    { 2, 907, 0, nullptr },
    { 2, 908, 0, nullptr },
    { 2, 909, 0, nullptr },
    { 2, 910, 0, nullptr },
    { 2, 911, 0, nullptr },
    { 2, 912, 0, nullptr },
    { 2, 913, 0, nullptr },
    { 2, 914, 0, nullptr },
    { 2, 915, 0, nullptr },
    { 2, 916, 0, nullptr },
    { 2, 917, 0, nullptr },
    { 2, 918, 0, nullptr },
    { 2, 919, 0, nullptr },
    { 2, 920, 0, nullptr },
    { 2, 921, 0, nullptr },
    { 2, 922, 0, nullptr },
    { 2, 923, 0, nullptr },
    { 2, 924, 0, nullptr },
    { 2, 925, 0, nullptr },
    { 2, 926, 0, nullptr },
    { 2, 927, 0, nullptr },
    { 2, 928, 0, nullptr },
    { 2, 929, 0, nullptr },
    { 2, 930, 0, nullptr },
    { 2, 931, 0, nullptr },
    { 2, 932, 0, nullptr },
    { 2, 933, 0, nullptr },
    { 2, 934, 0, nullptr },
    { 2, 935, 0, nullptr },
    { 2, 936, 0, nullptr },
    { 2, 937, 0, nullptr },
    { 2, 938, 0, nullptr },
    { 2, 939, 0, nullptr },
    { 2, 940, 0, nullptr },
    { 2, 941, 0, nullptr },
    { 2, 942, 0, nullptr },
    { 2, 943, 0, nullptr },
    { 2, 944, 0, nullptr },
    { 2, 945, 0, nullptr },
    { 2, 946, 0, nullptr },
    { 2, 947, 0, nullptr },
    { 2, 948, 0, nullptr },
    { 2, 949, 0, nullptr },
    { 2, 950, 0, nullptr },
    { 2, 951, 0, nullptr },
    { 2, 952, 0, nullptr },
    { 2, 953, 0, nullptr },
    { 2, 954, 0, nullptr },
    { 2, 955, 0, nullptr },
    { 2, 956, 0, nullptr },
    { 2, 957, 0, nullptr },
    { 2, 958, 0, nullptr },
    { 2, 959, 0, nullptr },
    { 2, 960, 0, nullptr },
    { 2, 961, 0, nullptr },
    { 2, 962, 0, nullptr },
    { 2, 963, 0, nullptr },
    { 2, 964, 0, nullptr },
    { 2, 965, 0, nullptr },
    { 2, 966, 0, nullptr },
    { 2, 967, 0, nullptr },
    { 2, 968, 0, nullptr },
    { 2, 969, 0, nullptr },
    { 2, 970, 0, nullptr },
    { 2, 971, 0, nullptr },
    { 2, 972, 0, nullptr },
    { 2, 973, 0, nullptr },
    { 2, 974, 0, nullptr },
    { 2, 975, 0, nullptr },
    { 2, 976, 0, nullptr },
    { 2, 977, 0, nullptr },
    { 2, 978, 0, nullptr },
    { 2, 979, 0, nullptr },
    { 2, 980, 0, nullptr },
    { 2, 981, 0, nullptr },
    { 2, 982, 0, nullptr },
    { 2, 983, 0, nullptr },
    { 2, 984, 0, nullptr },
    { 2, 985, 0, nullptr },
    { 2, 986, 0, nullptr },
    { 2, 987, 0, nullptr },
    { 2, 988, 0, nullptr },
    { 2, 989, 0, nullptr },
    { 2, 990, 0, nullptr },
    { 2, 991, 0, nullptr },
    { 2, 992, 0, nullptr },
    { 2, 993, 0, nullptr },
    { 2, 994, 0, nullptr },
    { 2, 995, 0, nullptr },
    { 2, 996, 0, nullptr },
    { 2, 997, 0, nullptr },
    { 2, 998, 0, nullptr },
    { 2, 999, 0, nullptr },
    { 2, 1000, 0, nullptr },
    { 2, 1001, 0, nullptr },
    { 2, 1002, 0, nullptr },
    { 2, 1003, 0, nullptr },
    { 2, 1004, 0, nullptr },
    { 2, 1005, 0, nullptr },
    { 2, 1006, 0, nullptr },
    { 2, 1007, 0, nullptr },
    { 2, 1008, 0, nullptr },
    { 2, 1009, 0, nullptr },
    { 2, 1010, 0, nullptr },
    { 2, 1011, 0, nullptr },
    { 2, 1012, 0, nullptr },
    { 2, 1013, 0, nullptr },
    { 2, 1014, 0, nullptr },
    { 2, 1015, 0, nullptr },
    { 2, 1016, 0, nullptr },
    { 2, 1017, 0, nullptr },
    { 2, 1018, 0, nullptr },
    { 2, 1019, 0, nullptr },
    { 2, 1020, 0, nullptr },
    { 2, 1021, 0, nullptr },
    { 2, 1022, 0, nullptr },
    { 2, 1023, 0, nullptr },
    { 2, 1024, 0, nullptr },
    { 2, 1025, 0, nullptr },
    { 2, 1026, 0, nullptr },
    { 2, 1027, 0, nullptr },
    { 2, 1028, 0, nullptr },
    { 2, 1029, 0, nullptr },
    { 2, 1030, 0, nullptr },
    { 2, 1031, 0, nullptr },
    { 2, 1032, 0, nullptr },
    { 2, 1033, 0, nullptr },
    { 2, 1034, 0, nullptr },
    { 2, 1035, 0, nullptr },
    { 2, 1036, 0, nullptr },
    { 2, 1037, 0, nullptr },
    { 2, 1038, 0, nullptr },
    { 2, 1039, 0, nullptr },
    { 2, 1040, 0, nullptr },
    { 2, 1041, 0, nullptr },
    { 2, 1042, 0, nullptr },
    { 2, 1043, 0, nullptr },
    { 2, 1044, 0, nullptr },
    { 2, 1045, 0, nullptr },
    { 2, 1046, 0, nullptr },
    { 2, 1047, 0, nullptr },
    { 2, 1048, 0, nullptr },
    { 2, 1049, 0, nullptr },
    { 2, 1050, 0, nullptr },
    { 2, 1051, 0, nullptr },
    { 2, 1052, 0, nullptr },
    { 2, 1053, 0, nullptr },
    { 2, 1054, 0, nullptr },
    { 2, 1055, 0, nullptr },
    { 2, 1056, 0, nullptr },
    { 2, 1057, 0, nullptr },
    { 2, 1058, 0, nullptr },
    { 2, 1059, 0, nullptr },
    { 2, 1060, 0, nullptr },
    { 2, 1061, 0, nullptr },
    { 2, 1062, 0, nullptr },
    { 2, 1063, 0, nullptr },
    { 2, 1064, 0, nullptr },
    { 2, 1065, 0, nullptr },
    { 2, 1066, 0, nullptr },
    { 2, 1067, 0, nullptr },
    { 2, 1068, 0, nullptr },
    { 2, 1069, 0, nullptr },
    { 2, 1070, 0, nullptr },
    { 2, 1071, 0, nullptr },
    { 2, 1072, 0, nullptr },
    { 2, 1073, 0, nullptr },
    { 2, 1074, 0, nullptr },
    { 2, 1075, 0, nullptr },
    { 2, 1076, 0, nullptr },
    { 2, 1077, 0, nullptr },
    { 2, 1078, 0, nullptr },
    { 2, 1079, 0, nullptr },
    { 2, 1080, 0, nullptr },
    { 2, 1081, 0, nullptr },
    { 2, 1082, 0, nullptr },
    { 2, 1083, 0, nullptr },
    { 2, 1084, 0, nullptr },
    { 2, 1085, 0, nullptr },
    { 2, 1086, 0, nullptr },
    { 2, 1087, 0, nullptr },
    { 2, 1088, 0, nullptr },
    { 2, 1089, 0, nullptr },
    { 2, 1090, 0, nullptr },
    { 2, 1091, 0, nullptr },
    { 2, 1092, 0, nullptr },
    { 2, 1093, 0, nullptr },
    { 2, 1094, 0, nullptr },
    { 2, 1095, 0, nullptr },
    { 2, 1096, 0, nullptr },
    { 2, 1097, 0, nullptr },
    { 2, 1098, 0, nullptr },
    { 2, 1099, 0, nullptr },
    { 2, 1100, 0, nullptr },
    { 2, 1101, 0, nullptr },
    { 2, 1102, 0, nullptr },
    { 2, 1103, 0, nullptr },
    { 2, 1104, 0, nullptr },
    { 2, 1105, 0, nullptr },
    { 2, 1106, 0, nullptr },
    { 2, 1107, 0, nullptr },
    { 2, 1108, 0, nullptr },
    { 2, 1109, 0, nullptr },
    { 2, 1110, 0, nullptr },
    { 2, 1111, 0, nullptr },
    { 2, 1112, 0, nullptr },
    { 2, 1113, 0, nullptr },
    { 2, 1114, 0, nullptr },
    { 2, 1115, 0, nullptr },
    { 2, 1116, 0, nullptr },
    { 2, 1117, 0, nullptr },
    { 2, 1118, 0, nullptr },
    { 2, 1119, 0, nullptr },
    { 2, 1120, 0, nullptr },
    { 2, 1121, 0, nullptr },
    { 2, 1122, 0, nullptr },
    { 2, 1123, 0, nullptr },
    { 2, 1124, 0, nullptr },
    { 2, 1125, 0, nullptr },
    { 2, 1126, 0, nullptr },
    { 2, 1127, 0, nullptr },
    { 2, 1128, 0, nullptr },
    { 2, 1129, 0, nullptr },
    { 2, 1130, 0, nullptr },
    { 2, 1131, 0, nullptr },
    { 2, 1132, 0, nullptr },
    { 2, 1133, 0, nullptr },
    { 2, 1134, 0, nullptr },
    { 2, 1135, 0, nullptr },
    { 2, 1136, 0, nullptr },
    { 2, 1137, 0, nullptr },
    { 2, 1138, 0, nullptr },
    { 2, 1139, 0, nullptr },
    { 2, 1140, 0, nullptr },
    { 2, 1141, 0, nullptr },
    { 2, 1142, 0, nullptr },
    { 2, 1143, 0, nullptr },
    { 2, 1144, 0, nullptr },
    { 2, 1145, 0, nullptr },
    { 2, 1146, 0, nullptr },
    { 2, 1147, 0, nullptr },
    { 2, 1148, 0, nullptr },
    { 2, 1149, 0, nullptr },
    { 2, 1150, 0, nullptr },
    { 2, 1151, 0, nullptr },
    { 2, 1152, 0, nullptr },
    { 2, 1153, 0, nullptr },
    { 2, 1154, 0, nullptr },
    { 2, 1155, 0, nullptr },
    { 2, 1156, 0, nullptr },
    { 2, 1157, 0, nullptr },
    { 2, 1158, 0, nullptr },
    { 2, 1159, 0, nullptr },
    { 2, 1160, 0, nullptr },
    { 2, 1161, 0, nullptr },
    { 2, 1162, 0, nullptr },
    { 2, 1163, 0, nullptr },
    { 2, 1164, 0, nullptr },
    { 2, 1165, 0, nullptr },
    { 2, 1166, 0, nullptr },
    { 2, 1167, 0, nullptr },
    { 2, 1168, 0, nullptr },
    { 2, 1169, 0, nullptr },
    { 2, 1170, 0, nullptr },
    { 2, 1171, 0, nullptr },
    { 2, 1172, 0, nullptr },
    { 2, 1173, 0, nullptr },
    { 2, 1174, 0, nullptr },
    { 2, 1175, 0, nullptr },
    { 2, 1176, 0, nullptr },
    { 2, 1177, 0, nullptr },
    { 2, 1178, 0, nullptr },
    { 2, 1179, 0, nullptr },
    { 2, 1180, 0, nullptr },
    { 2, 1181, 0, nullptr },
    { 2, 1182, 0, nullptr },
    { 2, 1183, 0, nullptr },
    { 2, 1184, 0, nullptr },
    { 2, 1185, 0, nullptr },
    { 2, 1186, 0, nullptr },
    { 2, 1187, 0, nullptr },
    { 2, 1188, 0, nullptr },
    { 2, 1189, 0, nullptr },
    { 2, 1190, 0, nullptr },
    { 2, 1191, 0, nullptr },
    { 2, 1192, 0, nullptr },
    { 2, 1193, 0, nullptr },
    { 2, 1194, 0, nullptr },
    { 2, 1195, 0, nullptr },
    { 2, 1196, 0, nullptr },
    { 2, 1197, 0, nullptr },
    { 2, 1198, 0, nullptr },
    { 2, 1199, 0, nullptr },
    { 2, 1200, 0, nullptr },
    { 2, 1201, 0, nullptr },
    { 2, 1202, 0, nullptr },
    { 2, 1203, 0, nullptr },
    { 2, 1204, 0, nullptr },
    { 2, 1205, 0, nullptr },
    { 2, 1206, 0, nullptr },
    { 2, 1207, 0, nullptr },
    { 2, 1208, 0, nullptr },
    { 2, 1209, 0, nullptr },
    { 2, 1210, 0, nullptr },
    { 2, 1211, 0, nullptr },
    { 2, 1212, 0, nullptr },
    { 2, 1213, 0, nullptr },
    { 2, 1214, 0, nullptr },
    { 2, 1215, 0, nullptr },
    { 2, 1216, 0, nullptr },
    { 2, 1217, 0, nullptr },
    { 2, 1218, 0, nullptr },
    { 2, 1219, 0, nullptr },
    { 2, 1220, 0, nullptr },
    { 2, 1221, 0, nullptr },
    { 2, 1222, 0, nullptr },
    { 2, 1223, 0, nullptr },
    { 2, 1224, 0, nullptr },
    { 2, 1225, 0, nullptr },
    { 2, 1226, 0, nullptr },
    { 2, 1227, 0, nullptr },
    { 2, 1228, 0, nullptr },
    { 2, 1229, 0, nullptr },
    { 2, 1230, 0, nullptr },
    { 2, 1231, 0, nullptr },
    { 2, 1232, 0, nullptr },
    { 2, 1233, 0, nullptr },
    { 2, 1234, 0, nullptr },
    { 2, 1235, 0, nullptr },
    { 2, 1236, 0, nullptr },
    { 2, 1237, 0, nullptr },
    { 2, 1238, 0, nullptr },
    { 2, 1239, 0, nullptr },
    { 2, 1240, 0, nullptr },
    { 2, 1241, 0, nullptr },
    { 2, 1242, 0, nullptr },
    { 2, 1243, 0, nullptr },
    { 2, 1244, 0, nullptr },
    { 2, 1245, 0, nullptr },
    { 2, 1246, 0, nullptr },
    { 2, 1247, 0, nullptr },
    { 2, 1248, 0, nullptr },
    { 2, 1249, 0, nullptr },
    { 2, 1250, 0, nullptr },
    { 2, 1251, 0, nullptr },
    { 2, 1252, 0, nullptr },
    { 2, 1253, 0, nullptr },
    { 2, 1254, 0, nullptr },
    { 2, 1255, 0, nullptr },
    { 2, 1256, 0, nullptr },
    { 2, 1257, 0, nullptr },
    { 2, 1258, 0, nullptr },
    { 2, 1259, 0, nullptr },
    { 2, 1260, 0, nullptr },
    { 2, 1261, 0, nullptr },
    { 2, 1262, 0, nullptr },
    { 2, 1263, 0, nullptr },
    { 2, 1264, 0, nullptr },
    { 2, 1265, 0, nullptr },
    { 2, 1266, 0, nullptr },
    { 2, 1267, 0, nullptr },
    { 2, 1268, 0, nullptr },
    { 2, 1269, 0, nullptr },
    { 2, 1270, 0, nullptr },
    { 2, 1271, 0, nullptr },
    { 2, 1272, 0, nullptr },
    { 2, 1273, 0, nullptr },
    { 2, 1274, 0, nullptr },
    { 2, 1275, 0, nullptr },
    { 2, 1276, 0, nullptr },
    { 2, 1277, 0, nullptr },
    { 2, 1278, 0, nullptr },
    { 2, 1279, 0, nullptr },
    { 2, 1280, 0, nullptr },
    { 2, 1281, 0, nullptr },
    { 2, 1282, 0, nullptr },
    { 2, 1283, 0, nullptr },
    { 2, 1284, 0, nullptr },
    { 2, 1285, 0, nullptr },
    { 2, 1286, 0, nullptr },
    { 2, 1287, 0, nullptr },
    { 2, 1288, 0, nullptr },
    { 2, 1289, 0, nullptr },
    { 2, 1290, 0, nullptr },
    { 2, 1291, 0, nullptr },
    { 2, 1292, 0, nullptr },
    { 2, 1293, 0, nullptr },
    { 2, 1294, 0, nullptr },
    { 2, 1295, 0, nullptr },
    { 2, 1296, 0, nullptr },
    { 2, 1297, 0, nullptr },
    { 2, 1298, 0, nullptr },
    { 2, 1299, 0, nullptr },
    { 2, 1300, 0, nullptr },
    { 2, 1301, 0, nullptr },
    { 2, 1302, 0, nullptr },
    { 2, 1303, 0, nullptr },
    { 2, 1304, 0, nullptr },
    { 2, 1305, 0, nullptr },
    { 2, 1306, 0, nullptr },
    { 2, 1307, 0, nullptr },
    { 2, 1308, 0, nullptr },
    { 2, 1309, 0, nullptr },
    { 2, 1310, 0, nullptr },
    { 2, 1311, 0, nullptr },
    { 2, 1312, 0, nullptr },
    { 2, 1313, 0, nullptr },
    { 2, 1314, 0, nullptr },
    { 2, 1315, 0, nullptr },
    { 2, 1316, 0, nullptr },
    { 2, 1317, 0, nullptr },
    { 2, 1318, 0, nullptr },
    { 2, 1319, 0, nullptr },
    { 2, 1320, 0, nullptr },
    { 2, 1321, 0, nullptr },
    { 2, 1322, 0, nullptr },
    { 2, 1323, 0, nullptr },
    { 2, 1324, 0, nullptr },
    { 2, 1325, 0, nullptr },
    { 2, 1326, 0, nullptr },
    { 2, 1327, 0, nullptr },
    { 2, 1328, 0, nullptr },
    { 2, 1329, 0, nullptr },
    { 2, 1330, 0, nullptr },
    { 2, 1331, 0, nullptr },
    { 2, 347, 0, nullptr },
    { 2, 1872, 0, nullptr },
    { 2, 1873, 0, nullptr },
    { 2, 1874, 0, nullptr },
    { 2, 1875, 0, nullptr },
    { 2, 1876, 0, nullptr },
    { 2, 1877, 0, nullptr },
    { 2, 1878, 0, nullptr },
    { 2, 1879, 0, nullptr },
    { 2, 1880, 0, nullptr },
    { 2, 1881, 0, nullptr },
    { 2, 1882, 0, nullptr },
    { 2, 1883, 0, nullptr },
    { 2, 1884, 0, nullptr },
    { 2, 1885, 0, nullptr },
    { 2, 1886, 0, nullptr },
    { 2, 1887, 0, nullptr },
    { 2, 1888, 0, nullptr },
    { 2, 1889, 0, nullptr },
    { 2, 1890, 0, nullptr },
    { 2, 1891, 0, nullptr },
    { 2, 1892, 0, nullptr },
    { 2, 1893, 0, nullptr },
    { 2, 1894, 0, nullptr },
    { 2, 1895, 0, nullptr },
    { 2, 1896, 0, nullptr },
    { 2, 1897, 0, nullptr },
    { 2, 1898, 0, nullptr },
    { 2, 1899, 0, nullptr },
    { 2, 1900, 0, nullptr },
    { 2, 1901, 0, nullptr },
    { 2, 1871, 0, nullptr },
    { 2, 1944, 0, nullptr },
    { 2, 1945, 0, nullptr },
    { 2, 1946, 0, nullptr },
    { 2, 1947, 0, nullptr },
    { 2, 1948, 0, nullptr },
    { 2, 1949, 0, nullptr },
    { 2, 1950, 0, nullptr },
    { 2, 1951, 0, nullptr },
    { 2, 1952, 0, nullptr },
    { 2, 1953, 0, nullptr },
    { 2, 1954, 0, nullptr },
    { 2, 1955, 0, nullptr },
    { 2, 1956, 0, nullptr },
    { 2, 1957, 0, nullptr },
    { 2, 1958, 0, nullptr },
    { 2, 1959, 0, nullptr },
    { 2, 1960, 0, nullptr },
    { 2, 1961, 0, nullptr },
    { 2, 1943, 0, nullptr },
    { 2, 1992, 0, nullptr },
    { 2, 1993, 0, nullptr },
    { 2, 1994, 0, nullptr },
    { 2, 1995, 0, nullptr },
    { 2, 1996, 0, nullptr },
    { 2, 1997, 0, nullptr },
    { 2, 1998, 0, nullptr },
    { 2, 1999, 0, nullptr },
    { 2, 2000, 0, nullptr },
    { 2, 2001, 0, nullptr },
    { 2, 2002, 0, nullptr },
    { 2, 2003, 0, nullptr },
    { 2, 2004, 0, nullptr },
    { 2, 2005, 0, nullptr },
    { 2, 2006, 0, nullptr },
    { 2, 2007, 0, nullptr },
    { 2, 2008, 0, nullptr },
    { 2, 2009, 0, nullptr },
    { 2, 2010, 0, nullptr },
    { 2, 2011, 0, nullptr },
    { 2, 2012, 0, nullptr },
    { 2, 2013, 0, nullptr },
    { 2, 2014, 0, nullptr },
    { 2, 2015, 0, nullptr },
    { 2, 2016, 0, nullptr },
    { 2, 2017, 0, nullptr },
    { 2, 2018, 0, nullptr },
    { 2, 2019, 0, nullptr },
    { 2, 2020, 0, nullptr },
    { 2, 2021, 0, nullptr },
    { 2, 2022, 0, nullptr },
    { 2, 2023, 0, nullptr },
    { 2, 2024, 0, nullptr },
    { 2, 2025, 0, nullptr },
    { 2, 2026, 0, nullptr },
    { 2, 2027, 0, nullptr },
    { 2, 2028, 0, nullptr },
    { 2, 2029, 0, nullptr },
    { 2, 2030, 0, nullptr },
    { 2, 2031, 0, nullptr },
    { 2, 2032, 0, nullptr },
    { 2, 2033, 0, nullptr },
    { 2, 2034, 0, nullptr },
    { 2, 2035, 0, nullptr },
    { 2, 2036, 0, nullptr },
    { 2, 2037, 0, nullptr },
    { 2, 2038, 0, nullptr },
    { 2, 2039, 0, nullptr },
    { 2, 2040, 0, nullptr },
    { 2, 2041, 0, nullptr },
    { 2, 2042, 0, nullptr },
    { 2, 2043, 0, nullptr },
    { 2, 2044, 0, nullptr },
    { 2, 2045, 0, nullptr },
    { 2, 2046, 0, nullptr },
    { 2, 2047, 0, nullptr },
    { 2, 2048, 0, nullptr },
    { 2, 2049, 0, nullptr },
    { 2, 2050, 0, nullptr },
    { 2, 2051, 0, nullptr },
    { 2, 2052, 0, nullptr },
    { 2, 2053, 0, nullptr },
    { 2, 2054, 0, nullptr },
    { 2, 2055, 0, nullptr },
    { 2, 2056, 0, nullptr },
    { 2, 2057, 0, nullptr },
    { 2, 2058, 0, nullptr },
    { 2, 2059, 0, nullptr },
    { 2, 2060, 0, nullptr },
    { 2, 2061, 0, nullptr },
    { 2, 2062, 0, nullptr },
    { 2, 2063, 0, nullptr },
    { 2, 2064, 0, nullptr },
    { 2, 2065, 0, nullptr },
    { 2, 2066, 0, nullptr },
    { 2, 2067, 0, nullptr },
    { 2, 2068, 0, nullptr },
    { 2, 2069, 0, nullptr },
    { 2, 2070, 0, nullptr },
    { 2, 2071, 0, nullptr },
    { 2, 2072, 0, nullptr },
    { 2, 2073, 0, nullptr },
    { 2, 2074, 0, nullptr },
    { 2, 2075, 0, nullptr },
    { 2, 2076, 0, nullptr },
    { 2, 2077, 0, nullptr },
    { 2, 2078, 0, nullptr },
    { 2, 2079, 0, nullptr },
    { 2, 2080, 0, nullptr },
    { 2, 2081, 0, nullptr },
    { 2, 2082, 0, nullptr },
    { 2, 2083, 0, nullptr },
    { 2, 2084, 0, nullptr },
    { 2, 2085, 0, nullptr },
    { 2, 2086, 0, nullptr },
    { 2, 2087, 0, nullptr },
    { 2, 1991, 0, nullptr },
    { 2, 2160, 0, nullptr },
    { 2, 2161, 0, nullptr },
    { 2, 2162, 0, nullptr },
    { 2, 2163, 0, nullptr },
    { 2, 2164, 0, nullptr },
    { 2, 2165, 0, nullptr },
    { 2, 2166, 0, nullptr },
    { 2, 2167, 0, nullptr },
    { 2, 2168, 0, nullptr },
    { 2, 2169, 0, nullptr },
    { 2, 2170, 0, nullptr },
    { 2, 2171, 0, nullptr },
    { 2, 2172, 0, nullptr },
    { 2, 2173, 0, nullptr },
    { 2, 2174, 0, nullptr },
    { 2, 2175, 0, nullptr },
    { 2, 2176, 0, nullptr },
    { 2, 2177, 0, nullptr },
    { 2, 2178, 0, nullptr },
    { 2, 2179, 0, nullptr },
    { 2, 2180, 0, nullptr },
    { 2, 2181, 0, nullptr },
    { 2, 2182, 0, nullptr },
    { 2, 2183, 0, nullptr },
    { 2, 2184, 0, nullptr },
    { 2, 2185, 0, nullptr },
    { 2, 2186, 0, nullptr },
    { 2, 2187, 0, nullptr },
    { 2, 2188, 0, nullptr },
    { 2, 2189, 0, nullptr },
    { 2, 2190, 0, nullptr },
    { 2, 2191, 0, nullptr },
    { 2, 2192, 0, nullptr },
    { 2, 2193, 0, nullptr },
    { 2, 2194, 0, nullptr },
    { 2, 2195, 0, nullptr },
    { 2, 2196, 0, nullptr },
    { 2, 2197, 0, nullptr },
    { 2, 2198, 0, nullptr },
    { 2, 2199, 0, nullptr },
    { 2, 2200, 0, nullptr },
    { 2, 2201, 0, nullptr },
    { 2, 2202, 0, nullptr },
    { 2, 2203, 0, nullptr },
    { 2, 2204, 0, nullptr },
    { 2, 2205, 0, nullptr },
    { 2, 2206, 0, nullptr },
    { 2, 2207, 0, nullptr },
    { 2, 2208, 0, nullptr },
    { 2, 2209, 0, nullptr },
    { 2, 2210, 0, nullptr },
    { 2, 2211, 0, nullptr },
    { 2, 2212, 0, nullptr },
    { 2, 2213, 0, nullptr },
    { 2, 2214, 0, nullptr },
    { 2, 2215, 0, nullptr },
    { 2, 2216, 0, nullptr },
    { 2, 2217, 0, nullptr },
    { 2, 2218, 0, nullptr },
    { 2, 2219, 0, nullptr },
    { 2, 2220, 0, nullptr },
    { 2, 2221, 0, nullptr },
    { 2, 2222, 0, nullptr },
    { 2, 2223, 0, nullptr },
    { 2, 2224, 0, nullptr },
    { 2, 2225, 0, nullptr },
    { 2, 2226, 0, nullptr },
    { 2, 2227, 0, nullptr },
    { 2, 2228, 0, nullptr },
    { 2, 2229, 0, nullptr },
    { 2, 2230, 0, nullptr },
    { 2, 2231, 0, nullptr },
    { 2, 2232, 0, nullptr },
    { 2, 2233, 0, nullptr },
    { 2, 2234, 0, nullptr },
    { 2, 2235, 0, nullptr },
    { 2, 2236, 0, nullptr },
    { 2, 2237, 0, nullptr },
    { 2, 2238, 0, nullptr },
    { 2, 2239, 0, nullptr },
    { 2, 2240, 0, nullptr },
    { 2, 2241, 0, nullptr },
    { 2, 2242, 0, nullptr },
    { 2, 2243, 0, nullptr },
    { 2, 2244, 0, nullptr },
    { 2, 2245, 0, nullptr },
    { 2, 2246, 0, nullptr },
    { 2, 2247, 0, nullptr },
    { 2, 2248, 0, nullptr },
    { 2, 2249, 0, nullptr },
    { 2, 2250, 0, nullptr },
    { 2, 2251, 0, nullptr },
    { 2, 2252, 0, nullptr },
    { 2, 2253, 0, nullptr },
    { 2, 2254, 0, nullptr },
    { 2, 2255, 0, nullptr },
    { 2, 2256, 0, nullptr },
    { 2, 2257, 0, nullptr },
    { 2, 2258, 0, nullptr },
    { 2, 2259, 0, nullptr },
    { 2, 2260, 0, nullptr },
    { 2, 2261, 0, nullptr },
    { 2, 2262, 0, nullptr },
    { 2, 2263, 0, nullptr },
    { 2, 2264, 0, nullptr },
    { 2, 2265, 0, nullptr },
    { 2, 2266, 0, nullptr },
    { 2, 2267, 0, nullptr },
    { 2, 2268, 0, nullptr },
    { 2, 2269, 0, nullptr },
    { 2, 2270, 0, nullptr },
    { 2, 2271, 0, nullptr },
    { 2, 2272, 0, nullptr },
    { 2, 2273, 0, nullptr },
    { 2, 2274, 0, nullptr },
    { 2, 2275, 0, nullptr },
    { 2, 2276, 0, nullptr },
    { 2, 2277, 0, nullptr },
    { 2, 2278, 0, nullptr },
    { 2, 2279, 0, nullptr },
    { 2, 2280, 0, nullptr },
    { 2, 2281, 0, nullptr },
    { 2, 2282, 0, nullptr },
    { 2, 2283, 0, nullptr },
    { 2, 2284, 0, nullptr },
    { 2, 2285, 0, nullptr },
    { 2, 2286, 0, nullptr },
    { 2, 2287, 0, nullptr },
    { 2, 2288, 0, nullptr },
    { 2, 2289, 0, nullptr },
    { 2, 2290, 0, nullptr },
    { 2, 2291, 0, nullptr },
    { 2, 2292, 0, nullptr },
    { 2, 2293, 0, nullptr },
    { 2, 2294, 0, nullptr },
    { 2, 2295, 0, nullptr },
    { 2, 2296, 0, nullptr },
    { 2, 2297, 0, nullptr },
    { 2, 2298, 0, nullptr },
    { 2, 2299, 0, nullptr },
    { 2, 2300, 0, nullptr },
    { 2, 2301, 0, nullptr },
    { 2, 2302, 0, nullptr },
    { 2, 2303, 0, nullptr },
    { 2, 2304, 0, nullptr },
    { 2, 2305, 0, nullptr },
    { 2, 2306, 0, nullptr },
    { 2, 2307, 0, nullptr },
    { 2, 2308, 0, nullptr },
    { 2, 2309, 0, nullptr },
    { 2, 2310, 0, nullptr },
    { 2, 2311, 0, nullptr },
    { 2, 2312, 0, nullptr },
    { 2, 2313, 0, nullptr },
    { 2, 2314, 0, nullptr },
    { 2, 2315, 0, nullptr },
    { 2, 2316, 0, nullptr },
    { 2, 2317, 0, nullptr },
    { 2, 2318, 0, nullptr },
    { 2, 2319, 0, nullptr },
    { 2, 2320, 0, nullptr },
    { 2, 2321, 0, nullptr },
    { 2, 2322, 0, nullptr },
    { 2, 2323, 0, nullptr },
    { 2, 2324, 0, nullptr },
    { 2, 2325, 0, nullptr },
    { 2, 2326, 0, nullptr },
    { 2, 2327, 0, nullptr },
    { 2, 2328, 0, nullptr },
    { 2, 2329, 0, nullptr },
    { 2, 2330, 0, nullptr },
    { 2, 2331, 0, nullptr },
    { 2, 2332, 0, nullptr },
    { 2, 2333, 0, nullptr },
    { 2, 2334, 0, nullptr },
    { 2, 2335, 0, nullptr },
    { 2, 2336, 0, nullptr },
    { 2, 2337, 0, nullptr },
    { 2, 2338, 0, nullptr },
    { 2, 2339, 0, nullptr },
    { 2, 2340, 0, nullptr },
    { 2, 2341, 0, nullptr },
    { 2, 2342, 0, nullptr },
    { 2, 2343, 0, nullptr },
    { 2, 2344, 0, nullptr },
    { 2, 2345, 0, nullptr },
    { 2, 2346, 0, nullptr },
    { 2, 2347, 0, nullptr },
    { 2, 2348, 0, nullptr },
    { 2, 2349, 0, nullptr },
    { 2, 2350, 0, nullptr },
    { 2, 2351, 0, nullptr },
    { 2, 2352, 0, nullptr },
    { 2, 2353, 0, nullptr },
    { 2, 2354, 0, nullptr },
    { 2, 2355, 0, nullptr },
    { 2, 2356, 0, nullptr },
    { 2, 2357, 0, nullptr },
    { 2, 2159, 0, nullptr },
    { 2, 2460, 0, nullptr },
    { 2, 2461, 0, nullptr },
    { 2, 2462, 0, nullptr },
    { 2, 2463, 0, nullptr },
    { 2, 2464, 0, nullptr },
    { 2, 2465, 0, nullptr },
    { 2, 2466, 0, nullptr },
    { 2, 2467, 0, nullptr },
    { 2, 2468, 0, nullptr },
    { 2, 2469, 0, nullptr },
    { 2, 2470, 0, nullptr },
    { 2, 2471, 0, nullptr },
    { 2, 2472, 0, nullptr },
    { 2, 2473, 0, nullptr },
    { 2, 2474, 0, nullptr },
    { 2, 2475, 0, nullptr },
    { 2, 2476, 0, nullptr },
    { 2, 2477, 0, nullptr },
    { 2, 2478, 0, nullptr },
    { 2, 2479, 0, nullptr },
    { 2, 2480, 0, nullptr },
    { 2, 2481, 0, nullptr },
    { 2, 2482, 0, nullptr },
    { 2, 2483, 0, nullptr },
    { 2, 2484, 0, nullptr },
    { 2, 2485, 0, nullptr },
    { 2, 2486, 0, nullptr },
    { 2, 2487, 0, nullptr },
    { 2, 2488, 0, nullptr },
    { 2, 2489, 0, nullptr },
    { 2, 2490, 0, nullptr },
    { 2, 2491, 0, nullptr },
    { 2, 2492, 0, nullptr },
    { 2, 2493, 0, nullptr },
    { 2, 2494, 0, nullptr },
    { 2, 2495, 0, nullptr },
    { 2, 2459, 0, nullptr },
    { 2, 2532, 0, nullptr },
    { 2, 2533, 0, nullptr },
    { 2, 2534, 0, nullptr },
    { 2, 2535, 0, nullptr },
    { 2, 2536, 0, nullptr },
    { 2, 2537, 0, nullptr },
    { 2, 2538, 0, nullptr },
    { 2, 2539, 0, nullptr },
    { 2, 2540, 0, nullptr },
    { 2, 2541, 0, nullptr },
    { 2, 2542, 0, nullptr },
    { 2, 2543, 0, nullptr },
    { 2, 2544, 0, nullptr },
    { 2, 2545, 0, nullptr },
    { 2, 2546, 0, nullptr },
    { 2, 2547, 0, nullptr },
    { 2, 2548, 0, nullptr },
    { 2, 2549, 0, nullptr },
    { 2, 2550, 0, nullptr },
    { 2, 2551, 0, nullptr },
    { 2, 2552, 0, nullptr },
    { 2, 2553, 0, nullptr },
    { 2, 2554, 0, nullptr },
    { 2, 2555, 0, nullptr },
    { 2, 2556, 0, nullptr },
    { 2, 2557, 0, nullptr },
    { 2, 2558, 0, nullptr },
    { 2, 2559, 0, nullptr },
    { 2, 2560, 0, nullptr },
    { 2, 2561, 0, nullptr },
    { 2, 2562, 0, nullptr },
    { 2, 2563, 0, nullptr },
    { 2, 2564, 0, nullptr },
    { 2, 2565, 0, nullptr },
    { 2, 2566, 0, nullptr },
    { 2, 2567, 0, nullptr },
    { 2, 2568, 0, nullptr },
    { 2, 2569, 0, nullptr },
    { 2, 2570, 0, nullptr },
    { 2, 2571, 0, nullptr },
    { 2, 2572, 0, nullptr },
    { 2, 2573, 0, nullptr },
    { 2, 2574, 0, nullptr },
    { 2, 2575, 0, nullptr },
    { 2, 2576, 0, nullptr },
    { 2, 2577, 0, nullptr },
    { 2, 2578, 0, nullptr },
    { 2, 2579, 0, nullptr },
    { 2, 2580, 0, nullptr },
    { 2, 2581, 0, nullptr },
    { 2, 2582, 0, nullptr },
    { 2, 2583, 0, nullptr },
    { 2, 2584, 0, nullptr },
    { 2, 2585, 0, nullptr },
    { 2, 2586, 0, nullptr },
    { 2, 2587, 0, nullptr },
    { 2, 2588, 0, nullptr },
    { 2, 2589, 0, nullptr },
    { 2, 2590, 0, nullptr },
    { 2, 2591, 0, nullptr },
    { 2, 2592, 0, nullptr },
    { 2, 2593, 0, nullptr },
    { 2, 2594, 0, nullptr },
    { 2, 2595, 0, nullptr },
    { 2, 2596, 0, nullptr },
    { 2, 2597, 0, nullptr },
    { 2, 2598, 0, nullptr },
    { 2, 2599, 0, nullptr },
    { 2, 2600, 0, nullptr },
    { 2, 2601, 0, nullptr },
    { 2, 2602, 0, nullptr },
    { 2, 2603, 0, nullptr },
    { 2, 2604, 0, nullptr },
    { 2, 2605, 0, nullptr },
    { 2, 2606, 0, nullptr },
    { 2, 2607, 0, nullptr },
    { 2, 2608, 0, nullptr },
    { 2, 2609, 0, nullptr },
    { 2, 2610, 0, nullptr },
    { 2, 2611, 0, nullptr },
    { 2, 2612, 0, nullptr },
    { 2, 2613, 0, nullptr },
    { 2, 2614, 0, nullptr },
    { 2, 2615, 0, nullptr },
    { 2, 2616, 0, nullptr },
    { 2, 2617, 0, nullptr },
    { 2, 2618, 0, nullptr },
    { 2, 2619, 0, nullptr },
    { 2, 2620, 0, nullptr },
    { 2, 2621, 0, nullptr },
    { 2, 2622, 0, nullptr },
    { 2, 2623, 0, nullptr },
    { 2, 2624, 0, nullptr },
    { 2, 2625, 0, nullptr },
    { 2, 2626, 0, nullptr },
    { 2, 2627, 0, nullptr },
    { 2, 2628, 0, nullptr },
    { 2, 2629, 0, nullptr },
    { 2, 2630, 0, nullptr },
    { 2, 2631, 0, nullptr },
    { 2, 2632, 0, nullptr },
    { 2, 2633, 0, nullptr },
    { 2, 2634, 0, nullptr },
    { 2, 2635, 0, nullptr },
    { 2, 2636, 0, nullptr },
    { 2, 2637, 0, nullptr },
    { 2, 2638, 0, nullptr },
    { 2, 2639, 0, nullptr },
    { 2, 2640, 0, nullptr },
    { 2, 2641, 0, nullptr },
    { 2, 2642, 0, nullptr },
    { 2, 2643, 0, nullptr },
    { 2, 2644, 0, nullptr },
    { 2, 2645, 0, nullptr },
    { 2, 2646, 0, nullptr },
    { 2, 2647, 0, nullptr },
    { 2, 2648, 0, nullptr },
    { 2, 2649, 0, nullptr },
    { 2, 2650, 0, nullptr },
    { 2, 2651, 0, nullptr },
    { 2, 2652, 0, nullptr },
    { 2, 2653, 0, nullptr },
    { 2, 2654, 0, nullptr },
    { 2, 2655, 0, nullptr },
    { 2, 2656, 0, nullptr },
    { 2, 2657, 0, nullptr },
    { 2, 2658, 0, nullptr },
    { 2, 2659, 0, nullptr },
    { 2, 2660, 0, nullptr },
    { 2, 2661, 0, nullptr },
    { 2, 2662, 0, nullptr },
    { 2, 2663, 0, nullptr },
    { 2, 2664, 0, nullptr },
    { 2, 2665, 0, nullptr },
    { 2, 2666, 0, nullptr },
    { 2, 2667, 0, nullptr },
    { 2, 2668, 0, nullptr },
    { 2, 2669, 0, nullptr },
    { 2, 2670, 0, nullptr },
    { 2, 2671, 0, nullptr },
    { 2, 2672, 0, nullptr },
    { 2, 2673, 0, nullptr },
    { 2, 2674, 0, nullptr },
    { 2, 2675, 0, nullptr },
    { 2, 2676, 0, nullptr },
    { 2, 2677, 0, nullptr },
    { 2, 2678, 0, nullptr },
    { 2, 2679, 0, nullptr },
    { 2, 2680, 0, nullptr },
    { 2, 2681, 0, nullptr },
    { 2, 2682, 0, nullptr },
    { 2, 2683, 0, nullptr },
    { 2, 2684, 0, nullptr },
    { 2, 2685, 0, nullptr },
    { 2, 2686, 0, nullptr },
    { 2, 2687, 0, nullptr },
    { 2, 2688, 0, nullptr },
    { 2, 2689, 0, nullptr },
    { 2, 2690, 0, nullptr },
    { 2, 2691, 0, nullptr },
    { 2, 2692, 0, nullptr },
    { 2, 2693, 0, nullptr },
    { 2, 2694, 0, nullptr },
    { 2, 2695, 0, nullptr },
    { 2, 2696, 0, nullptr },
    { 2, 2697, 0, nullptr },
    { 2, 2698, 0, nullptr },
    { 2, 2699, 0, nullptr },
    { 2, 2700, 0, nullptr },
    { 2, 2701, 0, nullptr },
    { 2, 2702, 0, nullptr },
    { 2, 2703, 0, nullptr },
    { 2, 2704, 0, nullptr },
    { 2, 2705, 0, nullptr },
    { 2, 2706, 0, nullptr },
    { 2, 2707, 0, nullptr },
    { 2, 2708, 0, nullptr },
    { 2, 2709, 0, nullptr },
    { 2, 2710, 0, nullptr },
    { 2, 2711, 0, nullptr },
    { 2, 2712, 0, nullptr },
    { 2, 2713, 0, nullptr },
    { 2, 2714, 0, nullptr },
    { 2, 2715, 0, nullptr },
    { 2, 2716, 0, nullptr },
    { 2, 2717, 0, nullptr },
    { 2, 2718, 0, nullptr },
    { 2, 2719, 0, nullptr },
    { 2, 2720, 0, nullptr },
    { 2, 2721, 0, nullptr },
    { 2, 2722, 0, nullptr },
    { 2, 2723, 0, nullptr },
    { 2, 2724, 0, nullptr },
    { 2, 2725, 0, nullptr },
    { 2, 2726, 0, nullptr },
    { 2, 2727, 0, nullptr },
    { 2, 2728, 0, nullptr },
    { 2, 2729, 0, nullptr },
    { 2, 2730, 0, nullptr },
    { 2, 2731, 0, nullptr },
    { 2, 2732, 0, nullptr },
    { 2, 2733, 0, nullptr },
    { 2, 2734, 0, nullptr },
    { 2, 2735, 0, nullptr },
    { 2, 2736, 0, nullptr },
    { 2, 2737, 0, nullptr },
    { 2, 2738, 0, nullptr },
    { 2, 2739, 0, nullptr },
    { 2, 2740, 0, nullptr },
    { 2, 2741, 0, nullptr },
    { 2, 2531, 0, nullptr },
    { 2, 2856, 0, nullptr },
    { 2, 2857, 0, nullptr },
    { 2, 2858, 0, nullptr },
    { 2, 2859, 0, nullptr },
    { 2, 2860, 0, nullptr },
    { 2, 2861, 0, nullptr },
    { 2, 2862, 0, nullptr },
    { 2, 2863, 0, nullptr },
    { 2, 2864, 0, nullptr },
    { 2, 2865, 0, nullptr },
    { 2, 2866, 0, nullptr },
    { 2, 2867, 0, nullptr },
    { 2, 2868, 0, nullptr },
    { 2, 2869, 0, nullptr },
    { 2, 2870, 0, nullptr },
    { 2, 2871, 0, nullptr },
    { 2, 2872, 0, nullptr },
    { 2, 2873, 0, nullptr },
    { 2, 2855, 0, nullptr },
    { 2, 2904, 0, nullptr },
    { 2, 2905, 0, nullptr },
    { 2, 2906, 0, nullptr },
    { 2, 2907, 0, nullptr },
    { 2, 2908, 0, nullptr },
    { 2, 2909, 0, nullptr },
    { 2, 2910, 0, nullptr },
    { 2, 2911, 0, nullptr },
    { 2, 2912, 0, nullptr },
    { 2, 2913, 0, nullptr },
    { 2, 2914, 0, nullptr },
    { 2, 2915, 0, nullptr },
    { 2, 2916, 0, nullptr },
    { 2, 2917, 0, nullptr },
    { 2, 2918, 0, nullptr },
    { 2, 2919, 0, nullptr },
    { 2, 2920, 0, nullptr },
    { 2, 2921, 0, nullptr },
    { 2, 2922, 0, nullptr },
    { 2, 2923, 0, nullptr },
    { 2, 2924, 0, nullptr },
    { 2, 2925, 0, nullptr },
    { 2, 2926, 0, nullptr },
    { 2, 2927, 0, nullptr },
    { 2, 2928, 0, nullptr },
    { 2, 2929, 0, nullptr },
    { 2, 2930, 0, nullptr },
    { 2, 2931, 0, nullptr },
    { 2, 2932, 0, nullptr },
    { 2, 2933, 0, nullptr },
    { 2, 2934, 0, nullptr },
    { 2, 2935, 0, nullptr },
    { 2, 2936, 0, nullptr },
    { 2, 2937, 0, nullptr },
    { 2, 2938, 0, nullptr },
    { 2, 2939, 0, nullptr },
    { 2, 2903, 0, nullptr },
    { 2, 2976, 0, nullptr },
    { 2, 2977, 0, nullptr },
    { 2, 2978, 0, nullptr },
    { 2, 2979, 0, nullptr },
    { 2, 2980, 0, nullptr },
    { 2, 2981, 0, nullptr },
    { 2, 2982, 0, nullptr },
    { 2, 2983, 0, nullptr },
    { 2, 2984, 0, nullptr },
    { 2, 2985, 0, nullptr },
    { 2, 2986, 0, nullptr },
    { 2, 2987, 0, nullptr },
    { 2, 2988, 0, nullptr },
    { 2, 2989, 0, nullptr },
    { 2, 2990, 0, nullptr },
    { 2, 2991, 0, nullptr },
    { 2, 2992, 0, nullptr },
    { 2, 2993, 0, nullptr },
    { 2, 2975, 0, nullptr },
    { 2, 175, 0, nullptr },
    { 2, 190, 0, nullptr },
    { 2, 205, 0, nullptr },
    { 2, 220, 0, nullptr },
    { 2, 235, 0, nullptr },
    { 2, 250, 0, nullptr },
    { 2, 265, 0, nullptr },
    { 2, 280, 0, nullptr },
    { 2, 295, 0, nullptr },
    { 2, 2994, 0, nullptr },
    { 2, 2995, 0, nullptr },
    { 2, 2996, 0, nullptr },
    { 2, 73, 0, nullptr },
    { 2, 2997, 0, nullptr },
    { 2, 94, 0, nullptr },
    { 2, 2998, 0, nullptr },
    { 2, 115, 0, nullptr },
    { 2, 2999, 0, nullptr },
    { 2, 3000, 0, nullptr },
    { 2, 3001, 0, nullptr },
    { 2, 136, 0, nullptr },
    { 2, 3002, 0, nullptr },
    { 2, 157, 0, nullptr },
    { 2, 51, 0, nullptr },
    { 2, 52, 0, nullptr },
    { 2, 53, 0, nullptr },
    { 2, 54, 0, nullptr },
    { 2, 55, 0, nullptr },
    { 2, 3012, 0, nullptr },
    { 2, 3013, 0, nullptr },
    { 2, 3014, 0, nullptr },
    { 2, 3015, 0, nullptr },
    { 2, 3016, 0, nullptr },
    { 2, 3017, 0, nullptr },
    { 2, 3018, 0, nullptr },
    { 2, 3019, 0, nullptr },
    { 2, 3020, 0, nullptr },
    { 2, 3021, 0, nullptr },
    { 2, 3022, 0, nullptr },
    { 2, 3023, 0, nullptr },
    { 2, 3024, 0, nullptr },
    { 2, 3025, 0, nullptr },
    { 2, 3026, 0, nullptr },
    { 2, 3027, 0, nullptr },
    { 2, 3028, 0, nullptr },
    { 2, 3029, 0, nullptr },
    { 2, 3030, 0, nullptr },
    { 2, 3031, 0, nullptr },
    { 2, 3032, 0, nullptr },
    { 2, 3006, 0, nullptr },
    { 2, 3007, 0, nullptr },
    { 2, 3008, 0, nullptr },
    { 2, 3009, 0, nullptr },
    { 2, 3010, 0, nullptr },
    { 2, 3011, 0, nullptr },
    { 2, 3005, 0, nullptr },
    { 2, 3004, 0, nullptr },
    { 2, 3041, 0, nullptr },
    { 2, 3042, 0, nullptr },
    { 2, 3043, 0, nullptr },
    { 2, 3044, 0, nullptr },
    { 2, 3045, 0, nullptr },
    { 2, 3046, 0, nullptr },
    { 2, 3047, 0, nullptr },
    { 2, 3048, 0, nullptr },
    { 2, 3049, 0, nullptr },
    { 2, 3050, 0, nullptr },
    { 2, 3051, 0, nullptr },
    { 2, 3052, 0, nullptr },
    { 2, 3053, 0, nullptr },
    { 2, 3054, 0, nullptr },
    { 2, 3055, 0, nullptr },
    { 2, 3056, 0, nullptr },
    { 2, 3057, 0, nullptr },
    { 2, 3058, 0, nullptr },
    { 2, 3059, 0, nullptr },
    { 2, 3060, 0, nullptr },
    { 2, 3061, 0, nullptr },
    { 2, 3035, 0, nullptr },
    { 2, 3036, 0, nullptr },
    { 2, 3037, 0, nullptr },
    { 2, 3038, 0, nullptr },
    { 2, 3039, 0, nullptr },
    { 2, 3040, 0, nullptr },
    { 2, 3034, 0, nullptr },
    { 2, 3033, 0, nullptr },
    { 2, 3070, 0, nullptr },
    { 2, 3071, 0, nullptr },
    { 2, 3072, 0, nullptr },
    { 2, 3073, 0, nullptr },
    { 2, 3074, 0, nullptr },
    { 2, 3075, 0, nullptr },
    { 2, 3076, 0, nullptr },
    { 2, 3077, 0, nullptr },
    { 2, 3078, 0, nullptr },
    { 2, 3079, 0, nullptr },
    { 2, 3080, 0, nullptr },
    { 2, 3081, 0, nullptr },
    { 2, 3082, 0, nullptr },
    { 2, 3083, 0, nullptr },
    { 2, 3084, 0, nullptr },
    { 2, 3085, 0, nullptr },
    { 2, 3086, 0, nullptr },
    { 2, 3087, 0, nullptr },
    { 2, 3088, 0, nullptr },
    { 2, 3089, 0, nullptr },
    { 2, 3090, 0, nullptr },
    { 2, 3064, 0, nullptr },
    { 2, 3065, 0, nullptr },
    { 2, 3066, 0, nullptr },
    { 2, 3067, 0, nullptr },
    { 2, 3068, 0, nullptr },
    { 2, 3069, 0, nullptr },
    { 2, 3063, 0, nullptr },
    { 2, 3062, 0, nullptr },
    { 2, 3099, 0, nullptr },
    { 2, 3100, 0, nullptr },
    { 2, 3101, 0, nullptr },
    { 2, 3102, 0, nullptr },
    { 2, 3103, 0, nullptr },
    { 2, 3104, 0, nullptr },
    { 2, 3105, 0, nullptr },
    { 2, 3106, 0, nullptr },
    { 2, 3107, 0, nullptr },
    { 2, 3108, 0, nullptr },
    { 2, 3109, 0, nullptr },
    { 2, 3110, 0, nullptr },
    { 2, 3111, 0, nullptr },
    { 2, 3112, 0, nullptr },
    { 2, 3113, 0, nullptr },
    { 2, 3114, 0, nullptr },
    { 2, 3115, 0, nullptr },
    { 2, 3116, 0, nullptr },
    { 2, 3117, 0, nullptr },
    { 2, 3118, 0, nullptr },
    { 2, 3119, 0, nullptr },
    { 2, 3093, 0, nullptr },
    { 2, 3094, 0, nullptr },
    { 2, 3095, 0, nullptr },
    { 2, 3096, 0, nullptr },
    { 2, 3097, 0, nullptr },
    { 2, 3098, 0, nullptr },
    { 2, 3092, 0, nullptr },
    { 2, 3091, 0, nullptr },
    { 2, 3128, 0, nullptr },
    { 2, 3129, 0, nullptr },
    { 2, 3130, 0, nullptr },
    { 2, 3131, 0, nullptr },
    { 2, 3132, 0, nullptr },
    { 2, 3133, 0, nullptr },
    { 2, 3134, 0, nullptr },
    { 2, 3135, 0, nullptr },
    { 2, 3136, 0, nullptr },
    { 2, 3137, 0, nullptr },
    { 2, 3138, 0, nullptr },
    { 2, 3139, 0, nullptr },
    { 2, 3140, 0, nullptr },
    { 2, 3141, 0, nullptr },
    { 2, 3142, 0, nullptr },
    { 2, 3143, 0, nullptr },
    { 2, 3144, 0, nullptr },
    { 2, 3145, 0, nullptr },
    { 2, 3146, 0, nullptr },
    { 2, 3147, 0, nullptr },
    { 2, 3148, 0, nullptr },
    { 2, 3122, 0, nullptr },
    { 2, 3123, 0, nullptr },
    { 2, 3124, 0, nullptr },
    { 2, 3125, 0, nullptr },
    { 2, 3126, 0, nullptr },
    { 2, 3127, 0, nullptr },
    { 2, 3121, 0, nullptr },
    { 2, 3120, 0, nullptr },
    { 2, 3157, 0, nullptr },
    { 2, 3158, 0, nullptr },
    { 2, 3159, 0, nullptr },
    { 2, 3160, 0, nullptr },
    { 2, 3161, 0, nullptr },
    { 2, 3162, 0, nullptr },
    { 2, 3163, 0, nullptr },
    { 2, 3164, 0, nullptr },
    { 2, 3165, 0, nullptr },
    { 2, 3166, 0, nullptr },
    { 2, 3167, 0, nullptr },
    { 2, 3168, 0, nullptr },
    { 2, 3169, 0, nullptr },
    { 2, 3170, 0, nullptr },
    { 2, 3171, 0, nullptr },
    { 2, 3172, 0, nullptr },
    { 2, 3173, 0, nullptr },
    { 2, 3174, 0, nullptr },
    { 2, 3175, 0, nullptr },
    { 2, 3176, 0, nullptr },
    { 2, 3177, 0, nullptr },
    { 2, 3151, 0, nullptr },
    { 2, 3152, 0, nullptr },
    { 2, 3153, 0, nullptr },
    { 2, 3154, 0, nullptr },
    { 2, 3155, 0, nullptr },
    { 2, 3156, 0, nullptr },
    { 2, 3150, 0, nullptr },
    { 2, 3149, 0, nullptr },
    { 2, 3186, 0, nullptr },
    { 2, 3187, 0, nullptr },
    { 2, 3188, 0, nullptr },
    { 2, 3189, 0, nullptr },
    { 2, 3190, 0, nullptr },
    { 2, 3191, 0, nullptr },
    { 2, 3192, 0, nullptr },
    { 2, 3193, 0, nullptr },
    { 2, 3194, 0, nullptr },
    { 2, 3195, 0, nullptr },
    { 2, 3196, 0, nullptr },
    { 2, 3197, 0, nullptr },
    { 2, 3198, 0, nullptr },
    { 2, 3199, 0, nullptr },
    { 2, 3200, 0, nullptr },
    { 2, 3201, 0, nullptr },
    { 2, 3202, 0, nullptr },
    { 2, 3203, 0, nullptr },
    { 2, 3204, 0, nullptr },
    { 2, 3205, 0, nullptr },
    { 2, 3206, 0, nullptr },
    { 2, 3180, 0, nullptr },
    { 2, 3181, 0, nullptr },
    { 2, 3182, 0, nullptr },
    { 2, 3183, 0, nullptr },
    { 2, 3184, 0, nullptr },
    { 2, 3185, 0, nullptr },
    { 2, 3179, 0, nullptr },
    { 2, 3178, 0, nullptr },
    { 2, 3215, 0, nullptr },
    { 2, 3216, 0, nullptr },
    { 2, 3217, 0, nullptr },
    { 2, 3218, 0, nullptr },
    { 2, 3219, 0, nullptr },
    { 2, 3220, 0, nullptr },
    { 2, 3221, 0, nullptr },
    { 2, 3222, 0, nullptr },
    { 2, 3223, 0, nullptr },
    { 2, 3224, 0, nullptr },
    { 2, 3225, 0, nullptr },
    { 2, 3226, 0, nullptr },
    { 2, 3227, 0, nullptr },
    { 2, 3228, 0, nullptr },
    { 2, 3229, 0, nullptr },
    { 2, 3230, 0, nullptr },
    { 2, 3231, 0, nullptr },
    { 2, 3232, 0, nullptr },
    { 2, 3233, 0, nullptr },
    { 2, 3234, 0, nullptr },
    { 2, 3235, 0, nullptr },
    { 2, 3209, 0, nullptr },
    { 2, 3210, 0, nullptr },
    { 2, 3211, 0, nullptr },
    { 2, 3212, 0, nullptr },
    { 2, 3213, 0, nullptr },
    { 2, 3214, 0, nullptr },
    { 2, 3208, 0, nullptr },
    { 2, 3207, 0, nullptr },
    { 2, 3244, 0, nullptr },
    { 2, 3245, 0, nullptr },
    { 2, 3246, 0, nullptr },
    { 2, 3247, 0, nullptr },
    { 2, 3248, 0, nullptr },
    { 2, 3249, 0, nullptr },
    { 2, 3250, 0, nullptr },
    { 2, 3251, 0, nullptr },
    { 2, 3252, 0, nullptr },
    { 2, 3253, 0, nullptr },
    { 2, 3254, 0, nullptr },
    { 2, 3255, 0, nullptr },
    { 2, 3256, 0, nullptr },
    { 2, 3257, 0, nullptr },
    { 2, 3258, 0, nullptr },
    { 2, 3259, 0, nullptr },
    { 2, 3260, 0, nullptr },
    { 2, 3261, 0, nullptr },
    { 2, 3262, 0, nullptr },
    { 2, 3263, 0, nullptr },
    { 2, 3264, 0, nullptr },
    { 2, 3238, 0, nullptr },
    { 2, 3239, 0, nullptr },
    { 2, 3240, 0, nullptr },
    { 2, 3241, 0, nullptr },
    { 2, 3242, 0, nullptr },
    { 2, 3243, 0, nullptr },
    { 2, 3237, 0, nullptr },
    { 2, 3236, 0, nullptr },
    { 2, 3273, 0, nullptr },
    { 2, 3274, 0, nullptr },
    { 2, 3275, 0, nullptr },
    { 2, 3276, 0, nullptr },
    { 2, 3277, 0, nullptr },
    { 2, 3278, 0, nullptr },
    { 2, 3279, 0, nullptr },
    { 2, 3280, 0, nullptr },
    { 2, 3281, 0, nullptr },
    { 2, 3282, 0, nullptr },
    { 2, 3283, 0, nullptr },
    { 2, 3284, 0, nullptr },
    { 2, 3285, 0, nullptr },
    { 2, 3286, 0, nullptr },
    { 2, 3287, 0, nullptr },
    { 2, 3288, 0, nullptr },
    { 2, 3289, 0, nullptr },
    { 2, 3290, 0, nullptr },
    { 2, 3291, 0, nullptr },
    { 2, 3292, 0, nullptr },
    { 2, 3293, 0, nullptr },
    { 2, 3267, 0, nullptr },
    { 2, 3268, 0, nullptr },
    { 2, 3269, 0, nullptr },
    { 2, 3270, 0, nullptr },
    { 2, 3271, 0, nullptr },
    { 2, 3272, 0, nullptr },
    { 2, 3266, 0, nullptr },
    { 2, 3265, 0, nullptr },
    { 2, 3302, 0, nullptr },
    { 2, 3303, 0, nullptr },
    { 2, 3304, 0, nullptr },
    { 2, 3305, 0, nullptr },
    { 2, 3306, 0, nullptr },
    { 2, 3307, 0, nullptr },
    { 2, 3308, 0, nullptr },
    { 2, 3309, 0, nullptr },
    { 2, 3310, 0, nullptr },
    { 2, 3311, 0, nullptr },
    { 2, 3312, 0, nullptr },
    { 2, 3313, 0, nullptr },
    { 2, 3314, 0, nullptr },
    { 2, 3315, 0, nullptr },
    { 2, 3316, 0, nullptr },
    { 2, 3317, 0, nullptr },
    { 2, 3318, 0, nullptr },
    { 2, 3319, 0, nullptr },
    { 2, 3320, 0, nullptr },
    { 2, 3321, 0, nullptr },
    { 2, 3322, 0, nullptr },
    { 2, 3296, 0, nullptr },
    { 2, 3297, 0, nullptr },
    { 2, 3298, 0, nullptr },
    { 2, 3299, 0, nullptr },
    { 2, 3300, 0, nullptr },
    { 2, 3301, 0, nullptr },
    { 2, 3295, 0, nullptr },
    { 2, 3294, 0, nullptr },
    { 2, 3331, 0, nullptr },
    { 2, 3332, 0, nullptr },
    { 2, 3333, 0, nullptr },
    { 2, 3334, 0, nullptr },
    { 2, 3335, 0, nullptr },
    { 2, 3336, 0, nullptr },
    { 2, 3337, 0, nullptr },
    { 2, 3338, 0, nullptr },
    { 2, 3339, 0, nullptr },
    { 2, 3340, 0, nullptr },
    { 2, 3341, 0, nullptr },
    { 2, 3342, 0, nullptr },
    { 2, 3343, 0, nullptr },
    { 2, 3344, 0, nullptr },
    { 2, 3345, 0, nullptr },
    { 2, 3346, 0, nullptr },
    { 2, 3347, 0, nullptr },
    { 2, 3348, 0, nullptr },
    { 2, 3349, 0, nullptr },
    { 2, 3350, 0, nullptr },
    { 2, 3351, 0, nullptr },
    { 2, 3325, 0, nullptr },
    { 2, 3326, 0, nullptr },
    { 2, 3327, 0, nullptr },
    { 2, 3328, 0, nullptr },
    { 2, 3329, 0, nullptr },
    { 2, 3330, 0, nullptr },
    { 2, 3324, 0, nullptr },
    { 2, 3323, 0, nullptr },
    { 2, 3360, 0, nullptr },
    { 2, 3361, 0, nullptr },
    { 2, 3362, 0, nullptr },
    { 2, 3363, 0, nullptr },
    { 2, 3364, 0, nullptr },
    { 2, 3365, 0, nullptr },
    { 2, 3366, 0, nullptr },
    { 2, 3367, 0, nullptr },
    { 2, 3368, 0, nullptr },
    { 2, 3369, 0, nullptr },
    { 2, 3370, 0, nullptr },
    { 2, 3371, 0, nullptr },
    { 2, 3372, 0, nullptr },
    { 2, 3373, 0, nullptr },
    { 2, 3374, 0, nullptr },
    { 2, 3375, 0, nullptr },
    { 2, 3376, 0, nullptr },
    { 2, 3377, 0, nullptr },
    { 2, 3378, 0, nullptr },
    { 2, 3379, 0, nullptr },
    { 2, 3380, 0, nullptr },
    { 2, 3354, 0, nullptr },
    { 2, 3355, 0, nullptr },
    { 2, 3356, 0, nullptr },
    { 2, 3357, 0, nullptr },
    { 2, 3358, 0, nullptr },
    { 2, 3359, 0, nullptr },
    { 2, 3353, 0, nullptr },
    { 2, 3352, 0, nullptr },
    { 2, 3389, 0, nullptr },
    { 2, 3390, 0, nullptr },
    { 2, 3391, 0, nullptr },
    { 2, 3392, 0, nullptr },
    { 2, 3393, 0, nullptr },
    { 2, 3394, 0, nullptr },
    { 2, 3395, 0, nullptr },
    { 2, 3396, 0, nullptr },
    { 2, 3397, 0, nullptr },
    { 2, 3398, 0, nullptr },
    { 2, 3399, 0, nullptr },
    { 2, 3400, 0, nullptr },
    { 2, 3401, 0, nullptr },
    { 2, 3402, 0, nullptr },
    { 2, 3403, 0, nullptr },
    { 2, 3404, 0, nullptr },
    { 2, 3405, 0, nullptr },
    { 2, 3406, 0, nullptr },
    { 2, 3407, 0, nullptr },
    { 2, 3408, 0, nullptr },
    { 2, 3409, 0, nullptr },
    { 2, 3383, 0, nullptr },
    { 2, 3384, 0, nullptr },
    { 2, 3385, 0, nullptr },
    { 2, 3386, 0, nullptr },
    { 2, 3387, 0, nullptr },
    { 2, 3388, 0, nullptr },
    { 2, 3382, 0, nullptr },
    { 2, 3381, 0, nullptr },
    { 2, 3418, 0, nullptr },
    { 2, 3419, 0, nullptr },
    { 2, 3420, 0, nullptr },
    { 2, 3421, 0, nullptr },
    { 2, 3422, 0, nullptr },
    { 2, 3423, 0, nullptr },
    { 2, 3424, 0, nullptr },
    { 2, 3425, 0, nullptr },
    { 2, 3426, 0, nullptr },
    { 2, 3427, 0, nullptr },
    { 2, 3428, 0, nullptr },
    { 2, 3429, 0, nullptr },
    { 2, 3430, 0, nullptr },
    { 2, 3431, 0, nullptr },
    { 2, 3432, 0, nullptr },
    { 2, 3433, 0, nullptr },
    { 2, 3434, 0, nullptr },
    { 2, 3435, 0, nullptr },
    { 2, 3436, 0, nullptr },
    { 2, 3437, 0, nullptr },
    { 2, 3438, 0, nullptr },
    { 2, 3412, 0, nullptr },
    { 2, 3413, 0, nullptr },
    { 2, 3414, 0, nullptr },
    { 2, 3415, 0, nullptr },
    { 2, 3416, 0, nullptr },
    { 2, 3417, 0, nullptr },
    { 2, 3411, 0, nullptr },
    { 2, 3410, 0, nullptr },
    { 2, 3447, 0, nullptr },
    { 2, 3448, 0, nullptr },
    { 2, 3449, 0, nullptr },
    { 2, 3450, 0, nullptr },
    { 2, 3451, 0, nullptr },
    { 2, 3452, 0, nullptr },
    { 2, 3453, 0, nullptr },
    { 2, 3454, 0, nullptr },
    { 2, 3455, 0, nullptr },
    { 2, 3456, 0, nullptr },
    { 2, 3457, 0, nullptr },
    { 2, 3458, 0, nullptr },
    { 2, 3459, 0, nullptr },
    { 2, 3460, 0, nullptr },
    { 2, 3461, 0, nullptr },
    { 2, 3462, 0, nullptr },
    { 2, 3463, 0, nullptr },
    { 2, 3464, 0, nullptr },
    { 2, 3465, 0, nullptr },
    { 2, 3466, 0, nullptr },
    { 2, 3467, 0, nullptr },
    { 2, 3441, 0, nullptr },
    { 2, 3442, 0, nullptr },
    { 2, 3443, 0, nullptr },
    { 2, 3444, 0, nullptr },
    { 2, 3445, 0, nullptr },
    { 2, 3446, 0, nullptr },
    { 2, 3440, 0, nullptr },
    { 2, 3439, 0, nullptr },
    { 2, 3476, 0, nullptr },
    { 2, 3477, 0, nullptr },
    { 2, 3478, 0, nullptr },
    { 2, 3479, 0, nullptr },
    { 2, 3480, 0, nullptr },
    { 2, 3481, 0, nullptr },
    { 2, 3482, 0, nullptr },
    { 2, 3483, 0, nullptr },
    { 2, 3484, 0, nullptr },
    { 2, 3485, 0, nullptr },
    { 2, 3486, 0, nullptr },
    { 2, 3487, 0, nullptr },
    { 2, 3488, 0, nullptr },
    { 2, 3489, 0, nullptr },
    { 2, 3490, 0, nullptr },
    { 2, 3491, 0, nullptr },
    { 2, 3492, 0, nullptr },
    { 2, 3493, 0, nullptr },
    { 2, 3494, 0, nullptr },
    { 2, 3495, 0, nullptr },
    { 2, 3496, 0, nullptr },
    { 2, 3470, 0, nullptr },
    { 2, 3471, 0, nullptr },
    { 2, 3472, 0, nullptr },
    { 2, 3473, 0, nullptr },
    { 2, 3474, 0, nullptr },
    { 2, 3475, 0, nullptr },
    { 2, 3469, 0, nullptr },
    { 2, 3468, 0, nullptr },
    { 2, 3505, 0, nullptr },
    { 2, 3506, 0, nullptr },
    { 2, 3507, 0, nullptr },
    { 2, 3508, 0, nullptr },
    { 2, 3509, 0, nullptr },
    { 2, 3510, 0, nullptr },
    { 2, 3511, 0, nullptr },
    { 2, 3512, 0, nullptr },
    { 2, 3513, 0, nullptr },
    { 2, 3514, 0, nullptr },
    { 2, 3515, 0, nullptr },
    { 2, 3516, 0, nullptr },
    { 2, 3517, 0, nullptr },
    { 2, 3518, 0, nullptr },
    { 2, 3519, 0, nullptr },
    { 2, 3520, 0, nullptr },
    { 2, 3521, 0, nullptr },
    { 2, 3522, 0, nullptr },
    { 2, 3523, 0, nullptr },
    { 2, 3524, 0, nullptr },
    { 2, 3525, 0, nullptr },
    { 2, 3499, 0, nullptr },
    { 2, 3500, 0, nullptr },
    { 2, 3501, 0, nullptr },
    { 2, 3502, 0, nullptr },
    { 2, 3503, 0, nullptr },
    { 2, 3504, 0, nullptr },
    { 2, 3498, 0, nullptr },
    { 2, 3497, 0, nullptr },
    { 2, 3534, 0, nullptr },
    { 2, 3535, 0, nullptr },
    { 2, 3536, 0, nullptr },
    { 2, 3537, 0, nullptr },
    { 2, 3538, 0, nullptr },
    { 2, 3539, 0, nullptr },
    { 2, 3540, 0, nullptr },
    { 2, 3541, 0, nullptr },
    { 2, 3542, 0, nullptr },
    { 2, 3543, 0, nullptr },
    { 2, 3544, 0, nullptr },
    { 2, 3545, 0, nullptr },
    { 2, 3546, 0, nullptr },
    { 2, 3547, 0, nullptr },
    { 2, 3548, 0, nullptr },
    { 2, 3549, 0, nullptr },
    { 2, 3550, 0, nullptr },
    { 2, 3551, 0, nullptr },
    { 2, 3552, 0, nullptr },
    { 2, 3553, 0, nullptr },
    { 2, 3554, 0, nullptr },
    { 2, 3528, 0, nullptr },
    { 2, 3529, 0, nullptr },
    { 2, 3530, 0, nullptr },
    { 2, 3531, 0, nullptr },
    { 2, 3532, 0, nullptr },
    { 2, 3533, 0, nullptr },
    { 2, 3527, 0, nullptr },
    { 2, 3526, 0, nullptr },
    { 2, 3003, 0, nullptr },
    { 2, 161, 0, nullptr },
    { 2, 162, 0, nullptr },
    { 2, 163, 0, nullptr },
    { 2, 44, 0, nullptr },
    { 2, 45, 0, nullptr },
    { 2, 46, 0, nullptr },
    { 2, 47, 0, nullptr },
    { 2, 43, 0, nullptr },
    { 2, 34, 0, nullptr },
    { 2, 35, 0, nullptr },
    { 2, 36, 0, nullptr },
    { 2, 37, 0, nullptr },
    { 2, 33, 0, nullptr },
    { 2, 39, 0, nullptr },
    { 2, 40, 0, nullptr },
    { 2, 41, 0, nullptr },
    { 2, 42, 0, nullptr },
    { 2, 38, 0, nullptr },
    { 2, 29, 0, nullptr },
    { 2, 30, 0, nullptr },
    { 2, 31, 0, nullptr },
    { 2, 32, 0, nullptr },
    { 2, 28, 0, nullptr },
    { 2, 15, 0, nullptr },
    { 2, 16, 0, nullptr },
    { 2, 17, 0, nullptr },
    { 2, 18, 0, nullptr },
    { 2, 14, 0, nullptr },
    { 2, 20, 0, nullptr },
    { 2, 21, 0, nullptr },
    { 2, 22, 0, nullptr },
    { 2, 23, 0, nullptr },
    { 2, 19, 0, nullptr },
    { 2, 5, 0, nullptr },
    { 2, 6, 0, nullptr },
    { 2, 7, 0, nullptr },
    { 2, 8, 0, nullptr },
    { 2, 4, 0, nullptr },
    { 2, 10, 0, nullptr },
    { 2, 11, 0, nullptr },
    { 2, 12, 0, nullptr },
    { 2, 13, 0, nullptr },
    { 2, 9, 0, nullptr },
    { 2, 24, 0, nullptr },
    { 2, 25, 0, nullptr },
    { 2, 26, 0, nullptr },
    { 2, 27, 0, nullptr },
    { 2, 48, 0, nullptr },
    { 2, 49, 0, nullptr },
    { 2, 50, 0, nullptr },
    { 2, 0, 0, nullptr },
    { 2, 1, 0, nullptr },
    { 2, 2, 0, nullptr },
    { 2, 3, 0, nullptr },
};

//size_t g_BufferSize = 402653184ul; // 384MB

/**
 * @brief   テストで利用するテストフィクスチャです。
 */
class StandardAllocatorRealPatternTest : public ::testing::TestWithParam< std::pair<StandardAllocatorTestParam, size_t> >
{
protected:

    /**
     * @brief   テスト開始時に毎回呼び出される関数です。
     */
    virtual void SetUp()
    {
        ASSERT_TRUE(nn::os::IsVirtualAddressMemoryEnabled());
        std::pair<StandardAllocatorTestParam, size_t> pattern = GetParam();
        size_t virtualSize = pattern.second * 1024 * 1024 * 1024;
        ASSERT_LE(virtualSize, 63ull * 1024 * 1024 * 1024); // NX での最大値
        m_Param = pattern.first;

        // ヒープを初期化
        if (pattern.first == StandardAllocatorTestParam_DisableThreadCache)
        {
            NN_LOG("ThreadCache: disabled heapSize: %zu GiB\n", pattern.second);
            m_Allocator.Initialize(nullptr, virtualSize);
        }
        else
        {
            NN_LOG("ThreadCache: enabled heapSize: %zu GiB\n", pattern.second);
            m_Allocator.Initialize(nullptr, virtualSize, true);
        }
    }

    /**
     * @brief   テスト終了時に毎回呼び出される関数です。
     */
    virtual void TearDown()
    {
        m_Allocator.Finalize();
    }

protected:
    nn::mem::StandardAllocator m_Allocator;
    StandardAllocatorTestParam m_Param;
};

}   // unnamed namespace

/**
 * @brief   過去実際に G3dDemo で管理領域の断片化が起きたパターンで問題がないことを確認します。
 */
TEST_P(StandardAllocatorRealPatternTest, G3dDemo)
{
    // alloc / free をシミュレートその１（ここは繰り返さない）
    for (auto&& cmd : g_CommandList1)
    {
        switch (cmd.type)
        {
        case 1: // alloc
            cmd.ptr = m_Allocator.Allocate(cmd.size, cmd.alignment);
            break;
        case 2: // free
            m_Allocator.Free(g_CommandList1[cmd.size].ptr);
            break;
        default:
            break;
        }
    }

    for (int loop = 0; loop < 3; ++loop)
    {
        // alloc / free をシミュレートその２（ここは３回繰り返す）
        for (auto&& cmd : g_CommandList2)
        {
            switch (cmd.type)
            {
            case 1: // alloc
                cmd.ptr = m_Allocator.Allocate(cmd.size, cmd.alignment);
                if (cmd.ptr == nullptr)
                {
                    m_Allocator.Dump();
                }
                ASSERT_TRUE(cmd.ptr != nullptr);
                break;
            case 2: // free
                m_Allocator.Free(g_CommandList2[cmd.size].ptr);
                break;
            default:
                break;
            }
        }
    }
}

INSTANTIATE_TEST_CASE_P(SwitchThreadCache,
                        StandardAllocatorRealPatternTest,
                        testing::Values(std::make_pair(StandardAllocatorTestParam_DisableThreadCache, 60),
                                        std::make_pair(StandardAllocatorTestParam_EnableThreadCache, 60)));

