﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/init.h>
#include <nn/os.h>
#include <nn/g3d.h>
#include <nn/time.h>
#include "SampleSources/g3ddemo_DemoUtility.h"
#include "SampleSources/g3ddemo_GfxUtility.h"
#include <nnt/graphics/testGraphics_GetHostExecutableFilepath.h>
#include <nnt/graphics/testGraphics_CreateDirectories.h>

#include "DummyThread.h"
#include "MemoryTest.h"

/**
 *
 * @brief
 * Town デモを実行しながら、メモリテストを実行します。
 */


extern int TownMain();

extern "C" void nnMain()
{
    nn::g3d::demo::Initialize();
    nn::g3d::demo::InitializeDemo();

    StartMemoryTestThread();
    StartDummyThread();

    // town
    TownMain();

    nn::g3d::demo::FinalizeDemo();
    nn::g3d::demo::Finalize();

    return;
}
