﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/ncmutil/ncmutil_InstallUtils.h>
#include <nnt/nnt_Argument.h>

#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/lr/lr_Service.h>
#include <nn/lr/lr_LocationResolver.h>

#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/ns_ApiForDfc.h>
#include <nn/ovln/ovln_ForDevelop.h>
#include <nn/ovln/ovln_SenderForOverlay.h>
#include <nn/nifm.h>
#include <nn/nim/nim_NetworkInstallManagerApi.h>
#include <nn/ns/ns_InitializationApi.h>

namespace {
    class IntegratedTest : public testing::Test
    {
    protected:
        virtual void SetUp()
        {
#if defined( NN_BUILD_CONFIG_OS_WIN32 )
            m_Installer.SetupBisWorkingDirectory(nnt::GetHostArgv()[1]);
#endif
            m_NspDirectoryPath = std::string(nnt::GetHostArgv()[2]);
            NN_LOG("nspDirectoryPath %s\n", m_NspDirectoryPath.c_str());

        }

        virtual void TearDown()
        {
#if defined( NN_BUILD_CONFIG_OS_WIN32 )
            NN_ABORT_UNLESS_RESULT_SUCCESS(m_Installer.TearDownBisWorkingDirectory());
#endif
        }

        static void SetUpTestCase()
        {
            NN_ASSERT(nnt::GetHostArgc() > 2);
            NN_ABORT_UNLESS_RESULT_SUCCESS(nn::fs::MountHostRoot());
        }

        static void TearDownTestCase()
        {
            nn::fs::UnmountHostRoot();
        }

        nn::Result InstallAll(std::vector<std::string>* outValue)
        {
            return m_Installer.InstallAll(outValue, m_NspDirectoryPath.c_str());
        }

    private:
        nnt::ncmutil::SubmissionPackageFileInstaller m_Installer;
        std::string m_NspDirectoryPath;
    };
}

TEST_F(IntegratedTest, Basic)
{
    nn::ncm::Initialize();
#if defined( NN_BUILD_CONFIG_OS_WIN32 )
    nn::ns::InitializeDependenciesForDfc();
    nn::ns::Initialize();
#else
    nn::lr::Initialize();
#endif // NN_BUILD_CONFIG_OS_WIN32

    std::vector<std::string> installed;
    NNT_ASSERT_RESULT_SUCCESS(InstallAll(&installed));

    nn::lr::LocationResolver resolver;
    NNT_ASSERT_RESULT_SUCCESS(nn::lr::OpenLocationResolver(&resolver, nn::ncm::StorageId::BuildInUser));

    for (auto& path : installed)
    {
        nn::ncm::DataId dataId = { static_cast<nn::Bit64>(std::stoll(path, nullptr, 16)) };
        nn::lr::Path lrPath;
        NNT_ASSERT_RESULT_SUCCESS(resolver.ResolveDataPath(&lrPath, dataId));
        NN_LOG("path %s\n", lrPath.string);
    }

#if defined( NN_BUILD_CONFIG_OS_WIN32 )
    nn::ns::Finalize();
    nn::ns::FinalizeDependenciesForDfc();
#else
    nn::lr::Finalize();
#endif
    nn::ncm::Finalize();
}
