﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace LdnTestBridge
{
    internal class Program
    {
        struct Config
        {
            public int port;
            public TimeSpan duration;
        };

        private static Config ProcessArg(string [] args)
        {
            // 初期値を設定します。
            Config config = new Config();
            config.port = 2017;
            config.duration = TimeSpan.FromDays(24);

            // コマンドライン引数を解析します。
            int i = 0;
            while (i < args.Length)
            {
                if ((args[i] == "-p" || args[i] == "--port") && i + 1 < args.Length)
                {
                    config.port = int.Parse(args[i + 1]);
                    i += 2;
                }
                else if ((args[i] == "-d" || args[i] == "--duration") && i + 1 < args.Length)
                {
                    config.duration = TimeSpan.FromSeconds(int.Parse(args[i + 1]));
                    i += 2;
                }
                else
                {
                    Console.WriteLine("Invalid Argument: {0}", args[i]);
                    Environment.Exit(-1);
                }
            }
            return config;
        }

        private static void Main(string[] args)
        {
            Config config = ProcessArg(args);
            var bridge = new TestBridge();
            bridge.Start(config.port);
            Console.WriteLine("Press <Enter> to exit.");
            System.Threading.Thread.Sleep(config.duration);
            bridge.Stop();
        }
    }
}
