﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ldn.h>

// ローカル通信識別子です。必ず任天堂から割り当てられた識別子を使用します。
const nn::Bit64 LocalCommunicationId = UINT64_C(0x0005000c10000000);

// デモ用のシーン識別子です。アプリケーションが用途に応じて自由に定義し、使い分けることができます。
const nn::Bit16 BasicSampleSceneId = UINT16_C(0x0001);

// ネットワークの目的を表す識別子です。
const nn::ldn::IntentId BasicSampleIntentId =
    nn::ldn::MakeIntentId(LocalCommunicationId, BasicSampleSceneId);

// 通信の保護に使用するパスフレーズです。予想しにくい 16 バイト以上のデータを指定します。
const nn::Bit8 Passphrase[] = { 0x2D, 0x20, 0x88, 0xA5, 0x24, 0x9C, 0xD6, 0xE4,
                                0xD8, 0x50, 0x92, 0xED, 0x52, 0x5A, 0x99, 0x4C };

// データの送受信に使用する UDP ポートです。
const int UdpPort = 12345;

// パケット送信間隔の目安 (ms) です。
const int PacketInterval = 1000;

// アクセスポイントが送信するデータです。
struct AccesspointData
{
    uint32_t counter[nn::ldn::NodeCountMax];
};

// ステーションが送信するデータです。
struct StationData
{
    uint32_t counter;
};
