﻿# 与えられたパスから親ディレクトリを辿り、Siglo リポジトリの Root パスを検索します。
Function FindSigloRoot($Path)
{
    $Current = $Path
    while (($Root -eq $NULL) -and $Current)
    {
        if (Test-Path "$Current\SigloRootMark")
        {
            $Root = $Current
        }
        $Current = (Split-Path $Current -Parent)
    }
    return $Root
}

# スクリプトのパスから Siglo リポジトリの Root パスを検索します。
if ($SIGLO_ROOT -eq $NULL)
{
    Set-Variable SIGLO_ROOT `
        (FindSigloRoot (Convert-Path $($MyInvocation.MyCommand.Path))) `
        -Option Constant -Scope Script
    if ($SIGLO_ROOT -eq $null)
    {
        throw 'Siglo リポジトリが見つかりません。'
    }
}
