﻿# リポジトリのファームウェアバージョンを取得します。
Function GetFirmwareSystemVersion()
{
    $NxFirmwareVersionXmlPath = "$SIGLO_ROOT\Common\Versions\NXFirmwareVersion.xml"
    $Version = Select-Xml -Path $NxFirmwareVersionXmlPath -XPath Product/Version

    New-Object PSObject -Property @{
        Major = [int]$Version.Node.SelectSingleNode("Major").InnerText;
        Minor = [int]$Version.Node.SelectSingleNode("Minor").InnerText;
        Micro = [int]$Version.Node.SelectSingleNode("Micro").InnerText;
    }
}
