﻿# 蓄積されたコマンドです。
$script:AccumulatedDevMenuCommandList = @{}

# コマンドラインツールのパスを設定します。
$CommandLineTools = "$SIGLO_ROOT\Tools\CommandLineTools"
if ($RUN_ON_TARGET -eq $NULL)
{
    Set-Variable RUN_ON_TARGET `
        "$CommandLineTools\RunOnTarget.exe" `
        -Option Constant -Scope Script
}

# ターゲット上で実行するツールのパスを設定します。
$TargetTools = "$SIGLO_ROOT\Programs\Eris\Outputs\NX-NXFP2-a64\TargetTools"
if ($DEV_MENU_COMMAND -eq $NULL)
{
    Set-Variable DEV_MENU_COMMAND `
        "$TargetTools\DevMenuCommand\Develop\DevMenuCommand.nsp" `
        -Option Constant -Scope Script
}
if ($DEV_MENU_COMMAND_SYSTEM -eq $NULL)
{
    Set-Variable DEV_MENU_COMMAND_SYSTEM `
        "$TargetTools\DevMenuCommandSystem\Develop\DevMenuCommandSystem.nsp" `
        -Option Constant -Scope Script
}

# DevMenuCommand でコマンドを実行します。
Function DevMenuCommand($TargetName)
{
    # DevMenuCommand は DevMenuCommandSystem で代替可能です。
    $Tool = $null
    if (Test-Path $DEV_MENU_COMMAND_SYSTEM)
    {
        $Tool = $DEV_MENU_COMMAND_SYSTEM
    }
    elseif (Test-Path $DEV_MENU_COMMAND)
    {
        $Tool = $DEV_MENU_COMMAND
    }
    else
    {
        throw 'DevMenuCommand あるいは DevMenuCommandSystem が見つかりません。'
    }

    # 指定されたターゲットに対して指定されたコマンドを実行します。
    Write-Host "DevMenuCommand -t $($TargetName) -- $Args"
    $StdOut = &$RUN_ON_TARGET $Tool "-t" $($TargetName) "--" $Args

    # 標準出力に [FAILURE] が含まれていた場合は失敗扱いにします。
    if ($StdOut -match "^\[FAILURE\]")
    {
        throw $StdOut
    }
    return $StdOut
}

# DevMenuCommandSystem でコマンドを実行します。
Function DevMenuCommandSystem($TargetName)
{
    # DevMenuCommandSystem は DevMenuCommand で代替できません。
    if (!(Test-Path $DEV_MENU_COMMAND_SYSTEM))
    {
        throw 'DevMenuCommandSystem が見つかりません。'
    }

    # 指定されたターゲットに対して指定されたコマンドを実行します。
    Write-Host "DevMenuCommandSystem -t $($TargetName) -- $Args"
    $StdOut = &$RUN_ON_TARGET $DEV_MENU_COMMAND_SYSTEM "-t" $($TargetName) "--" $Args

    # 標準出力に [FAILURE] が含まれていた場合は失敗扱いにします。
    if ($StdOut -match "\[FAILURE\]")
    {
        throw $StdOut
    }
    return $StdOut
}

# インストールされているアプリケーションのリストを生成します。
Function GetInstalledApplicationList($TargetName)
{
    $Result = (DevMenuCommand $($TargetName) application list)
    return (($Result -match "^0x[0-9a-f]{16}\s+[0-9.]+\s+") -split "`r`n") | % {
        $Data = (-split $_)
        @{ Id = $Data[0]; Version = $Data[1]; Name = $Data[2] }
    }
}

# インストールされているシステムプログラムのリストを生成します。
Function GetInstalledSystemProgramList($TargetName)
{
    $Result = (DevMenuCommandSystem $($TargetName) systemprogram list)
    return (($Result -match "^0x[0-9a-f]{16}\s+") -split "`r`n") | % {
        $Data = (-split $_)
        @{ Id = $Data[0]; Version = [int]$Data[1]; Type = $Data[2]; Name = $Data[3]; }
    }
}

# アプリケーションをアンインストールします。
Function UninstallApplication($TargetName, $ApplicationId, $Push = $FALSE)
{
    $Cmdlet = if ($Push) { Get-Command PushDevMenuCommand } else { Get-Command DevMenuCommand }
    $Arguments = @($TargetName, "application", "uninstall", $ApplicationId)
    &$Cmdlet @Arguments > $NULL
}

# アプリケーションをインストールします。
Function InstallApplication($TargetName, $ApplicationPath, $Force = $FALSE, $Push = $FALSE)
{
    # アプリケーションが存在することを確認しておきます。
    if (!(Test-Path $ApplicationPath))
    {
        throw (New-Object "System.IO.FileNotFoundException" "$ApplicationPath not found")
    }

    # DevMenuCommand を使用してアプリケーションをインストールします。
    $Cmdlet = if ($Push) { Get-Command PushDevMenuCommand } else { Get-Command DevMenuCommand }
    $Arguments = @($TargetName, "application", "install", "`"$ApplicationPath`"")
    if ($Force)
    {
        $Arguments += "--force"
    }
    &$Cmdlet @Arguments > $NULL
}

# システムプログラムをアンインストールします。
Function UninstallSystemProgram($TargetName, $ProgramId, $Push = $FALSE)
{
    $Cmdlet = if ($Push) { Get-Command PushDevMenuCommandSystem } else { Get-Command DevMenuCommandSystem }
    $Arguments = @($TargetName, "systemprogram", "uninstall", $ProgramId)
    &$Cmdlet @Arguments > $NULL
}

# システムプログラムをインストールします。
Function InstallSystemProgram($TargetName, $SystemProgramPath, $Force = $FALSE, $Push = $FALSE)
{
    # アプリケーションが存在することを確認しておきます。
    if (!(Test-Path $SystemProgramPath))
    {
        throw (New-Object "System.IO.FileNotFoundException" "$SystemProgramPath not found")
    }

    # DevMenuCommandSystem を使用してアプリケーションをインストールします。
    $Cmdlet = if ($Push) { Get-Command PushDevMenuCommandSystem } else { Get-Command DevMenuCommandSystem }
    $Arguments = @($TargetName, "systemprogram", "install", "`"$SystemProgramPath`"")
    if ($Force)
    {
        $Arguments += "--force"
    }
    &$Cmdlet @Arguments > $NULL
}

# パッチをアンインストールします。
Function UninstallPatch($TargetName, $ApplicationId, $Push = $FALSE)
{
    $Cmdlet = if ($Push) { Get-Command PushDevMenuCommand } else { Get-Command DevMenuCommand }
    $Arguments = @($TargetName, "patch", "uninstall", $ApplicationId)
    &$Cmdlet @Arguments > $NULL
}

# パッチを適用します。
Function ApplyPatch($TargetName, $PatchPath, $Force = $FALSE, $Push = $FALSE)
{
    # パッチが存在することを確認しておきます。
    if (!(Test-Path $PatchPath))
    {
        throw (New-Object "System.IO.FileNotFoundException" "$PatchPath not found")
    }

    $Cmdlet = if ($Push) { Get-Command PushDevMenuCommand } else { Get-Command DevMenuCommand }
    $Arguments = @($TargetName, "patch", "install", "`"$PatchPath`"")
    if ($Force)
    {
        $Arguments += "--force"
    }
    &$Cmdlet @Arguments > $NULL
}

# まとめて実行するコマンドを追加します。
Function PushDevMenuCommand($TargetName)
{
    if (-not $script:AccumulatedDevMenuCommandList.Contains($TargetName))
    {
        $script:AccumulatedDevMenuCommandList[$TargetName] = @()
    }

    $script:AccumulatedDevMenuCommandList[$TargetName] += ($Args -join ' ')
}

# まとめて実行するコマンドを追加します。
Function PushDevMenuCommandSystem($TargetName)
{
    # DevMenuCommandSystem は DevMenuCommand で代替できません。
    if (!(Test-Path $DEV_MENU_COMMAND_SYSTEM))
    {
        throw 'DevMenuCommandSystem が見つかりません。'
    }

    if (-not $script:AccumulatedDevMenuCommandList.Contains($TargetName))
    {
        $script:AccumulatedDevMenuCommandList[$TargetName] = @()
    }

    $script:AccumulatedDevMenuCommandList[$TargetName] += ($Args -join ' ')
}

# 蓄積されたコマンドをまとめて実行します。
Function DevMenuCommandBatch()
{
    $BatchPath = "$Env:TEMP\Siglo\Lcs\Batches\$pid.txt"

    New-Item (Split-Path $BatchPath) -Type Directory -Force

    foreach ($TargetName in $script:AccumulatedDevMenuCommandList.Keys)
    {
        $BatchText = $script:AccumulatedDevMenuCommandList[$TargetName] | Out-String
        [System.IO.File]::WriteAllBytes($BatchPath, [System.Text.Encoding]::UTF8.GetBytes($BatchText))

        DevMenuCommand $TargetName "batch" $BatchPath
    }
    $script:AccumulatedDevMenuCommandList = @{}
}

# 蓄積されたコマンドをまとめて実行します。
Function DevMenuCommandSystemBatch()
{
    # DevMenuCommandSystem は DevMenuCommand で代替できません。
    if (!(Test-Path $DEV_MENU_COMMAND_SYSTEM))
    {
        throw 'DevMenuCommandSystem が見つかりません。'
    }

    foreach ($TargetName in $script:AccumulatedDevMenuCommandList.Keys)
    {
        $BatchText = $script:AccumulatedDevMenuCommandList[$TargetName] | Out-String
        [System.IO.File]::WriteAllBytes($BatchPath, [System.Text.Encoding]::UTF8.GetBytes($BatchText))

        DevMenuCommandSystem $TargetName "batch" $BatchPath
    }
    $script:AccumulatedDevMenuCommandList = @{}
}
