﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/lcs.h>
#include <nn/lcs/lcs_DebugApi.h>
#include <nn/lcs/lcs_PrivateDebugApi.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/socket.h>
#include <nnt.h>
#include <nnt/lcs/testLcs_Utility.h>
#include <nnt/ldn/testLdn_HtcsSynchronization.h>
#include <nnt/ldn/testLdn_NifmUtility.h>
#include <nnt/ldn/testLdn_Utility.h>
#include <nnt/result/testResult_Assert.h>
#include "Precondition.h"

namespace
{
    // テストを実行するヘルパです。
    nnt::lcs::TestHelper* g_pHelper;

    // Socket の初期化用バッファです。
    nn::socket::ConfigDefaultWithMemory g_SocketConfig;

} // namespace <unnamed>

//
//  Eula 関連の API の検証です。
//
TEST(LupEula, HostToAllClients)
{
    const auto cond = GetPrecondition(
        "LupEula", "HostToAllClients",
        nnt::lcs::Application::LupEula01);
    g_pHelper->RunTest(cond, "LupEula.HostToAllClients", 2);
}

//
//  Eula 同意確認中に離脱する検証です。
//
TEST(LupEula, Leave)
{
    const auto cond = GetPrecondition(
        "LupEula", "Leave",
        nnt::lcs::Application::LupEula01);
    g_pHelper->RunTest(cond, "LupEula.HostToAllClients", 2);
}

//
// テストのエントリポイントです。
//
extern "C" void nnMain()
{
    // コマンドライン引数に関する設定です。
    nnt::lcs::CommandLineParserSetting setting = { };
    setting.flag = static_cast<nn::Bit32>(
        nnt::lcs::CommandLineOptionFlag_NodeCount |
        nnt::lcs::CommandLineOptionFlag_NodeIndex |
        nnt::lcs::CommandLineOptionFlag_Resume |
        nnt::lcs::CommandLineOptionFlag_SceneId);
    setting.nodeCountMin = 2;
    setting.nodeCountMax = nnt::ldn::SynchronizationClientCountMax;

    // コマンドライン引数を解析します。
    nnt::lcs::TestConfig config;
    int argc = nn::os::GetHostArgc();
    char **argv = nn::os::GetHostArgv();
    ::testing::InitGoogleTest(&argc, argv);
    nnt::lcs::Parse(&config, setting, argc, argv);

    // socket ライブラリと ns ライブラリを初期化しておきます。
    nn::socket::Initialize(g_SocketConfig);
    nnt::lcs::NsInitializer nsInitiailzer;

    // テストの準備です。
    nnt::lcs::Setup(config.sceneId);

    // テストを実行します。
    g_pHelper = new nnt::lcs::TestHelper(config, "nnt::lcs::IntegrationLupEula");
    int exitCode = RUN_ALL_TESTS();
    delete g_pHelper;

    // 終了処理です。
    nn::socket::Finalize();
    nnt::Exit(exitCode);
}
