﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <nnt/lcs/testLcs_Utility.h>

void SetMasterHasExFatPrecondition(
    nnt::lcs::PreconditionSource* pSource,
    const char* test,
    nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(applicationId);
    auto& source = *pSource;
    if (std::strcmp(test, "PatchRequiredSystemVersion") == 0)
    {
        source.SetSystemVersion(2, 1, 1);
        source.SetApplicationVersion(2, 1, 1);
        source.SetApplicationRequiredSystemVersion(2, 1, 1);
        source.SetExFatDriverEnabled(true, false, false);
    }
    else if (std::strcmp(test, "LcsRequiredSystemVersion") == 0)
    {
        source.SetSystemVersion(1, 2, 1);
        source.SetApplicationVersion(1, 2, 1);
        source.SetSystemRequiredSystemVersion(1, 2, 1);
        source.SetExFatDriverEnabled(false, true, false);
    }
    else if (std::strcmp(test, "ApplicationDeliveryProtocol") == 0)
    {
        source.SetSystemVersion(1, 1, 2);
        source.SetApplicationVersion(1, 1, 2);
        source.SetApplicationDeliveryProtocolVersion(1, 1, 2, false);
        source.SetExFatDriverEnabled(false, false, true);
    }
    else
    {
        NN_ABORT("Unknown Test: MasterHasExFat.%s\n", test);
    }
}

void SetEveryoneHasExFatPrecondition(
    nnt::lcs::PreconditionSource* pSource,
    const char* test,
    nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(applicationId);
    auto& source = *pSource;
    if (std::strcmp(test, "PatchRequiredSystemVersion") == 0)
    {
        source.SetSystemVersion(1, 2, 1);
        source.SetApplicationVersion(1, 2, 1);
        source.SetApplicationRequiredSystemVersion(1, 2, 1);
        source.SetExFatDriverEnabled(true, true, true);
    }
    else if (std::strcmp(test, "LcsRequiredSystemVersion") == 0)
    {
        source.SetSystemVersion(1, 1, 2);
        source.SetApplicationVersion(1, 1, 2);
        source.SetSystemRequiredSystemVersion(1, 1, 2);
        source.SetExFatDriverEnabled(true, true, true);
    }
    else if (std::strcmp(test, "ApplicationDeliveryProtocol") == 0)
    {
        source.SetSystemVersion(2, 1, 1);
        source.SetApplicationVersion(2, 1, 1);
        source.SetApplicationDeliveryProtocolVersion(2, 1, 1, false);
        source.SetExFatDriverEnabled(true, true, true);
    }
    else
    {
        NN_ABORT("Unknown Test: EveryoneHasExFat.%s\n", test);
    }
}

void SetNoOneHasExFatPrecondition(
    nnt::lcs::PreconditionSource* pSource,
    const char* test,
    nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(applicationId);
    auto& source = *pSource;
    if (std::strcmp(test, "PatchRequiredSystemVersion") == 0)
    {
        source.SetSystemVersion(1, 1, 2);
        source.SetApplicationVersion(1, 1, 2);
        source.SetApplicationRequiredSystemVersion(1, 1, 2);
        source.SetExFatDriverEnabled(false, false, false);
    }
    else if (std::strcmp(test, "LcsRequiredSystemVersion") == 0)
    {
        source.SetSystemVersion(2, 1, 1);
        source.SetApplicationVersion(2, 1, 1);
        source.SetSystemRequiredSystemVersion(2, 1, 1);
        source.SetExFatDriverEnabled(false, false, false);
    }
    else if (std::strcmp(test, "ApplicationDeliveryProtocol") == 0)
    {
        source.SetSystemVersion(1, 2, 1);
        source.SetApplicationVersion(1, 2, 1);
        source.SetApplicationDeliveryProtocolVersion(1, 2, 1, false);
        source.SetExFatDriverEnabled(false, false, false);
    }
    else
    {
        NN_ABORT("Unknown Test: NoOneHasExFat.%s\n", test);
    }
}

void SetSlaveHasExFatPrecondition(
    nnt::lcs::PreconditionSource* pSource,
    const char* test,
    nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(applicationId);
    auto& source = *pSource;
    if (std::strcmp(test, "PatchRequiredSystemVersion1") == 0)
    {
        source.SetSystemVersion(2, 1, 1);
        source.SetApplicationVersion(2, 1, 1);
        source.SetApplicationRequiredSystemVersion(2, 1, 1);
        source.SetExFatDriverEnabled(false, true, true);
    }
    else if (std::strcmp(test, "PatchRequiredSystemVersion2") == 0)
    {
        source.SetSystemVersion(1, 2, 2);
        source.SetApplicationVersion(1, 2, 1);
        source.SetApplicationRequiredSystemVersion(1, 2, 1);
        source.SetExFatDriverEnabled(true, false, false);
    }
    else if (std::strcmp(test, "PatchRequiredSystemVersion3") == 0)
    {
        source.SetSystemVersion(1, 2, 3);
        source.SetApplicationVersion(1, 2, 3);
        source.SetApplicationRequiredSystemVersion(1, 2, 3);
        source.SetExFatDriverEnabled(true, false, false);
    }
    else if (std::strcmp(test, "LcsRequiredSystemVersion1") == 0)
    {
        source.SetSystemVersion(1, 2, 1);
        source.SetApplicationVersion(1, 2, 1);
        source.SetSystemRequiredSystemVersion(1, 2, 1);
        source.SetExFatDriverEnabled(true, false, true);
    }
    else if (std::strcmp(test, "LcsRequiredSystemVersion2") == 0)
    {
        source.SetSystemVersion(2, 1, 2);
        source.SetApplicationVersion(1, 1, 2);
        source.SetSystemRequiredSystemVersion(2, 1, 2);
        source.SetExFatDriverEnabled(false, true, false);
    }
    else if (std::strcmp(test, "LcsRequiredSystemVersion3") == 0)
    {
        source.SetSystemVersion(1, 2, 3);
        source.SetApplicationVersion(1, 1, 2);
        source.SetSystemRequiredSystemVersion(1, 2, 3);
        source.SetExFatDriverEnabled(true, true, false);
    }
    else if (std::strcmp(test, "LcsRequiredSystemVersion4") == 0)
    {
        source.SetSystemVersion(2, 1, 1);
        source.SetApplicationVersion(1, 2, 2);
        source.SetSystemRequiredSystemVersion(2, 1, 1);
        source.SetExFatDriverEnabled(false, true, true);
    }
    else if (std::strcmp(test, "ApplicationDeliveryProtocol1") == 0)
    {
        source.SetSystemVersion(1, 1, 2);
        source.SetApplicationVersion(1, 1, 2);
        source.SetApplicationDeliveryProtocolVersion(1, 1, 2, false);
        source.SetExFatDriverEnabled(true, true, false);
    }
    else if (std::strcmp(test, "ApplicationDeliveryProtocol2") == 0)
    {
        source.SetSystemVersion(2, 2, 1);
        source.SetApplicationVersion(2, 1, 1);
        source.SetApplicationDeliveryProtocolVersion(2, 2, 1, false);
        source.SetExFatDriverEnabled(false, false, true);
    }
    else if (std::strcmp(test, "ApplicationDeliveryProtocol3") == 0)
    {
        source.SetSystemVersion(1, 3, 2);
        source.SetApplicationVersion(1, 1, 2);
        source.SetApplicationDeliveryProtocolVersion(1, 2, 1, false);
        source.SetExFatDriverEnabled(true, false, false);
    }
    else if (std::strcmp(test, "ApplicationDeliveryProtocol4") == 0)
    {
        source.SetSystemVersion(2, 1, 1);
        source.SetApplicationVersion(1, 2, 2);
        source.SetApplicationDeliveryProtocolVersion(2, 1, 1, false);
        source.SetExFatDriverEnabled(false, true, true);
    }
    else if (std::strcmp(test, "PatchShare") == 0)
    {
        source.SetSystemVersion(3, 2, 1);
        source.SetApplicationVersion(2, 1, 1);
        source.SetExFatDriverEnabled(false, true, true);
    }
    else
    {
        NN_ABORT("Unknown Test: SlaveHasExFat.%s\n", test);
    }
}

nnt::lcs::Precondition GetPrecondition(
    const char* testcase, const char* test, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(testcase);
    NN_UNUSED(test);
    auto source = nnt::lcs::CreateDefaultPreconditionSource();
    source.application.id = applicationId;
    if (std::strcmp(testcase, "MasterHasExFat") == 0)
    {
        SetMasterHasExFatPrecondition(&source, test, applicationId);
    }
    else if (std::strcmp(testcase, "EveryoneHasExFat") == 0)
    {
        SetEveryoneHasExFatPrecondition(&source, test, applicationId);
    }
    else if (std::strcmp(testcase, "NoOneHasExFat") == 0)
    {
        SetNoOneHasExFatPrecondition(&source, test, applicationId);
    }
    else if (std::strcmp(testcase, "SlaveHasExFat") == 0)
    {
        SetSlaveHasExFatPrecondition(&source, test, applicationId);
    }
    else
    {
        NN_ABORT("Unknown Testcase: %s\n", testcase);
    }
    return Calculate(source);
}

nnt::lcs::Precondition GetPrecondition(
    const char* testcase, const char* test, uint64_t applicationId) NN_NOEXCEPT
{
    nn::ncm::ApplicationId id = { applicationId };
    return GetPrecondition(testcase, test, id);
}
