﻿Param(
    [Parameter(Mandatory=$TRUE)][string[]] $ConfigFiles
)

# スクリプトをロードします。
$SCRIPT_DIR = (Split-Path -Parent $MyInvocation.MyCommand.Path)
$LDN_SCRIPT_DIR = (Convert-Path $SCRIPT_DIR\..\..\..\Ldn\Sources\Scripts)
. $LDN_SCRIPT_DIR\Siglo\Bundle
. $SCRIPT_DIR\Manager\Contents
. $SCRIPT_DIR\Manager\Utility
Import-Module $SIGLO_ROOT\Integrate\Scripts\Modules\HostBridge\HostBridge

# セットアップの開始を通知するログを表示します。
Write-Host "Setup: $($ConfigFiles)"

# テストで使用するコンテンツを生成しておきます。
CreateTempDirectory
$Contents = (ReadContentsFromJson "$SCRIPT_DIR\Contents")
CreateTestContents $Contents

# PC に接続されている開発機を取得します。
$Targets = GetTargetList

# 全開発機を並行してセットアップします。
# SIGLO-70370? のワークアラウンド。セットアップに失敗した時は HostBridge を再起動してセットアップを再試行します。
for ($RetryCount = 1; $RetryCount-- -gt -1;)
{
    $InstallJobs = Wait-Job ($Targets | % {
        Start-Job -ArgumentList $_,$ConfigFiles,$SCRIPT_DIR -ScriptBlock {
            Param($Target,$ConfigFiles,$SCRIPT_DIR)
            &"$SCRIPT_DIR\SetupTarget.ps1" $Target.Address $Target.Name $Target.Index $ConfigFiles
        }
    })

    # エラーが起きたターゲットのリストを取得します。
    $FailedTargets = 0..($InstallJobs.Length - 1) | ? {
        Receive-Job $InstallJobs[$_] -AutoRemoveJob -Wait 2>&1
    } | % {
        $Targets[$_]
    }

    # 全てのターゲットが成功したら終了します。
    if (-not $FailedTargets)
    {
        break
    }

    # エラーが起きたターゲットの HostBridge を再起動します。
    $FailedTargets | % {
        Stop-SaveHostBridgeLog -HostBridgeAddress $_.Address
        Restart-HostBridge $_.Address
    }
    $FailedTargets | % {
        Wait-HostBridge $_.Address | Write-Host
        Start-SaveHostBridgeLog -HostBridgeAddress $_.Address
    }
}
