﻿# exFAT を無効化します。
Function DisableExFatTask($Target, $BootImagePackageExFat)
{
    # exFAT ドライバのインストール状況を確認します。
    $InstalledVersion = $NULL
    foreach ($Record in $Target.InstalledSystemPrograms)
    {
        if ($Record.Id -eq $BootImagePackageExFat.Id)
        {
            $InstalledVersion = $Record.Version
        }
    }

    # exFAT ドライバをアンインストールします。
    if ($InstalledVersion -ne $NULL)
    {
        UninstallSystemProgram $Target.Name $BootImagePackageExFat.Id
    }

    # exFAT ドライバを無効状態にします。
    PushDevMenuCommandSystem $Target.Name "systemupdate" "update-bootimages"
    PushDevMenuCommandSystem $Target.Name "systemupdate" "clear-exfat-status"
}

# exFAT を有効化します。
Function EnableExFatTask($Target, $BootImagePackageExFat, $Build)
{
    # exFAT ドライバのインストール状況を確認します。
    $InstalledVersion = $NULL
    foreach ($Record in $Target.InstalledSystemPrograms)
    {
        if ($Record.Id -eq $BootImagePackageExFat.Id)
        {
            $InstalledVersion = $Record.Version
        }
    }

    # exFAT ドライバをインストールします。
    if ($InstalledVersion -eq $NULL)
    {
        $Path = ResolvePath $BootImagePackageExFat.Path $Build
        InstallSystemProgram $Target.Name $Path
    }

    # exFAT ドライバを有効状態にします。
    PushDevMenuCommandSystem $Target.Name "systemupdate" "update-bootimages"
}

# exFAT の有効無効を切り換えるタスクです。
Function SetExFatEnabledTask($Target, $Settings, $Contents)
{
    $BootImagePackageExFat = $Contents.SystemData['BootImagePackageExFat']
    if ($Settings.enabled)
    {
        $Build = if ($Settings.build) { $Settings.build } else { 'Develop' }
        EnableExFatTask $Target $BootImagePackageExFat $Build
    }
    else
    {
        DisableExFatTask $Target $BootImagePackageExFat
    }
}
