﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nnt { namespace lbl {

// 全ての設定値に統一の値を割り当てます。
void SetUniformedValueToSetting(float value) NN_NOEXCEPT;

// 全ての設定値に最大値を割り当てます。
void SetMaxValueToSetting() NN_NOEXCEPT;

// 全ての設定値に最小値を割り当てます。
void SetMinValueToSetting() NN_NOEXCEPT;

// 安定した自動輝度調整on時に適用される輝度設定値を取得する。
float GetStableAutoAppliedBrightnessSetting(float brightness, float sensor) NN_NOEXCEPT;

class LblInitializer
{
public:
    LblInitializer();
    ~LblInitializer();
};

}}
