﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/jit/plugin/jit_Plugin.h>

#include <nn/nn_Common.h>
#include <cstring>
#include <nn/jit/plugin/jit_PluginUtility.h>
#include "../TestVmJitAarch64.h"

#include <nn/nn_Log.h>

namespace nn { namespace jit { namespace plugin {

void ConfigurePlugin() NN_NOEXCEPT
{
    EnableDevelopmentFunctions();
    SetCodeMemorySecurityForDevelopment(jit::MemorySecurityMode_Default);
    SetWorkMemorySecurityForDevelopment(jit::MemorySecurityMode_Default);
}

void OnPrepared(const nn::jit::plugin::JitPluginEnvironment& info) NN_NOEXCEPT
{
    NN_UNUSED(info);
}

int Control(const nn::jit::plugin::JitPluginEnvironment& info, uint64_t tag, const void* inData, size_t inDataSize, void* outBuffer, size_t outBufferSize) NN_NOEXCEPT
{
    NN_UNUSED(info);
    NN_UNUSED(tag);
    NN_UNUSED(inData);
    NN_UNUSED(inDataSize);
    NN_UNUSED(outBuffer);
    NN_UNUSED(outBufferSize);
    return 0;
}

int GenerateCode(nn::jit::CodeRange* pGeneratedRx, nn::jit::CodeRange* pGeneratedRo, const nn::jit::plugin::JitPluginEnvironment& environment, uint64_t tag, const void* source, size_t sourceSize, const nn::jit::CodeRange& rxBuffer, const nn::jit::CodeRange& roBuffer, const void* inData, size_t inDataSize, void* outBuffer, size_t outBufferSize) NN_NOEXCEPT
{
    using namespace nn::jit::testvm;

    int32_t pc;
    if (!(inDataSize == sizeof(pc)))
    {
        return 1;
    }
    std::memcpy(&pc, inData, sizeof(pc));

    size_t codeSize;
    uint32_t instructionCount;
    auto codeData = static_cast<char*>(environment.rxWritable) + rxBuffer.offset;
    JitRunner::GenerateCodeImpl(&codeSize, &instructionCount, codeData, static_cast<const Instruction*>(source), pc);

    pGeneratedRx->offset = rxBuffer.offset;
    pGeneratedRx->size = codeSize;
    *pGeneratedRo = {};
    return 0;
}

}}}
