﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include <nnt.h>
#include <nn/nn_Result.h>
#include <nn/http.h>
#include <nn/npns.h>

namespace nnt {
namespace npns {
namespace util {

class NotificationPublisher
{
public:
    NotificationPublisher(nn::http::ConnectionBroker& cb, const char* pNdidAccessToken);
    nn::Result Send(const nn::npns::NotificationToken token, const char* pPayload, bool bStoreOffline = false);
    nn::Result SendByTopic(const char* pTopicName, const char* pPayload);

    nn::Result SendByTopic(nn::ApplicationId appId, const char* pPrefix, const char* pPayload);
    nn::Result CreateTopic(char* pNameOut, size_t length, nn::ApplicationId appId, const char* pPrefix);

    nn::Result DiscardResponseBody(nn::http::Response* pRes);

protected:
    nn::Result SetupRequest(nn::http::Request* pReq);

private:
    nn::http::ConnectionBroker&  m_ConnectionBroker;
    const char* m_pNdidAccessToken;
};


}
}
}
