﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Compiler.h>

#define GTEST_HAS_TR1_TUPLE 0 // NOLINT(preprocessor/const)
#define GTEST_LANG_CXX11 1 // NOLINT(preprocessor/const)

#if   defined(NN_BUILD_CONFIG_COMPILER_VC)
    #pragma warning ( push )
    #pragma warning ( disable : 4668 )
    #include <gmock/gmock.h>
    #include <gtest/gtest.h>
    #pragma warning ( pop )
#elif defined(NN_BUILD_CONFIG_COMPILER_CLANG) || \
      defined(NN_BUILD_CONFIG_COMPILER_GCC)
    #include <nnt/gmock/gmock.h>
    #include <nnt/gtest/gtest.h>
#else
    #error   "未サポートのコンパイラ種別が指定されています。"
#endif
