﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// プラットフォームによる実装分岐用のマクロを自動定義します。
#if defined(NN_NINTENDO_SDK)
    #define NNT_NPT_PLATFORM_NX
#else
    #error "サポートされないプラットフォームです。"
#endif //defined(NN_NINTENDO_SDK)

#include <nn/nfc.h>
#include <nn/nfc/nfc_PrivateResult.h>

#define NNT_NPT_MULTI_2DEVICES  // ２つのデバイスで試験を行うときに有効にする

namespace nnt { namespace npt {
    // 読み書きの失敗時にリトライする回数と待機時間 (ms) です。
    const int RetryCountMax           = 5;
    const int RetryInterval           = 100;

    // デフォルトのタイムアウト時間 (ms) です。
    const int ActivateTimeout         = 5000;
    const int DeactivateTimeout       = 5000;
    const int ConnectTimeout          = 5000;
    const int DisconnectTimeout       = 5000;
    const int SendCommandTimeout      = 3000;

}} // end of namespace nnt::npt
