﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testMifare_Config.h"

namespace nnt { namespace mifare { namespace wrapper {
    //==================================================
    // API実行時のログ設定
    //==================================================
    enum LogMode
    {
        LogMode_None = 0,
        LogMode_Aging = 1 << 0,
    };

    void SetApiCallLoggingMode(const uint32_t mode) NN_NOEXCEPT;

    //==================================================
    // MIFAREライブラリ実行用のラッパー関数
    //==================================================
    nn::Result Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    nn::Result ListDevices(NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceHandle* pOutBuffer, int* pOutCount, int bufferCount) NN_NOEXCEPT;
    nn::Result StartDetection(const NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result StartDetection() NN_NOEXCEPT;
    nn::Result StopDetection(const NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result StopDetection() NN_NOEXCEPT;
    nn::Result GetTagInfo(NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::TagInfo* pOutTagInfo, const NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result GetTagInfo(NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::TagInfo* pOutTagInfo) NN_NOEXCEPT;
    nn::Result AttachActivateEvent(nn::os::SystemEventType* pEvent, const NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result AttachActivateEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT;
    nn::Result AttachDeactivateEvent(nn::os::SystemEventType* pEvent, const NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result AttachDeactivateEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT;
    nn::Result AttachAvailabilityChangeEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT;
    NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::State GetState() NN_NOEXCEPT;
    NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceState GetDeviceState(const NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceState GetDeviceState() NN_NOEXCEPT;
    nn::Result Read(NNT_NFC_COMMON_IF_TYPE_MIFARE(ReadBlockData) * pOutBlockData, const NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceHandle& deviceHandle, const NNT_NFC_COMMON_IF_TYPE_MIFARE(ReadBlockParameter) * pBlockParameter, size_t blockCount) NN_NOEXCEPT;
    nn::Result Read(NNT_NFC_COMMON_IF_TYPE_MIFARE(ReadBlockData) * pOutBlockData, const NNT_NFC_COMMON_IF_TYPE_MIFARE(ReadBlockParameter) * pBlockParameter, size_t blockCount) NN_NOEXCEPT;
    nn::Result Write(const NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceHandle& deviceHandle, const NNT_NFC_COMMON_IF_TYPE_MIFARE(WriteBlockParameter) * pBlockParameter, size_t blockCount) NN_NOEXCEPT;
    nn::Result Write(const NNT_NFC_COMMON_IF_TYPE_MIFARE(WriteBlockParameter) * pBlockParameter, size_t blockCount) NN_NOEXCEPT;
    nn::Result GetNpadId(nn::hid::NpadIdType* pOutNpadId, const NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result GetNpadId(nn::hid::NpadIdType* pOutNpadId) NN_NOEXCEPT;
#if !defined(NNT_NFP_BUILD_CONFIG_OLD_LIBRARY) && defined(NNT_MIFARE_PLATFORM_NX)
    nn::Result InitializeSystem() NN_NOEXCEPT;
    void FinalizeSystem() NN_NOEXCEPT;
    nn::Result InitializeDebug() NN_NOEXCEPT;
    void FinalizeDebug() NN_NOEXCEPT;
#endif
    void SetErrorVisible(bool visible) NN_NOEXCEPT;
    bool IsErrorVisible() NN_NOEXCEPT;
}}} // end of namespace nnt::mifare::wrapper
