﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/htcs.h>
#include <nn/os.h>

namespace nnt { namespace htcs { namespace util {
    enum ThreadMode
    {
        ThreadMode_Recv,
        ThreadMode_Send,
        ThreadMode_Echo,
    };

    struct ThreadArgs
    {
        ThreadArgs()
        {
            address.family = nn::htcs::HTCS_AF_HTCS;
            address.peerName = nn::htcs::GetPeerNameAny();
            recvFlag = 0;
        }

        nn::htcs::SockAddrHtcs address;
        nn::os::Barrier *pBarrier;
        ThreadMode mode;
        size_t size;
        int64_t count;
        bool verbose;
        int recvFlag;
    };

    void ClientThread(void *pArgs);
    void ServerThread(void *pArgs);
}}}
