﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/lmem/lmem_ExpHeap.h>

namespace nnt {
namespace gfx {

/**
 * @brief スクリーンキャプチャクラス
 *
 * @details
*/
class NntGfxScreenCapture
{
public:
    /**
     * @brief コンストラクタ
     *
    */
    NntGfxScreenCapture();


    /**
     * @brief デストラクタ
     *
    */
    ~NntGfxScreenCapture();


#ifdef EFT_IS_CAFE
    /**
     * @brief 初期化処理
     *
     * @param[in]  pHeapHandle  ヒープハンドル
    */
    void Initialize( nn::lmem::HeapHandle pHeapHandle );
#else
    /**
     * @brief 初期化処理
     *
     * @details Windows版では何も行いません
    */
    void Initialize( void );
#endif


    /**
     * @brief 破棄処理
     *
    */
    void Release();


    /**
     * @brief キャプチャ処理
     *
     * @param[out] pPixels      キャプチャデータの格納先
     * @param[in]  width        横幅
     * @param[in]  height       縦幅
     * @param[in]  format       画像フォーマット
     * @param[in]  type
    */
    void Capture( void* pPixels, int width, int height, int format, int type );

#ifdef EFT_IS_CAFE
    /**
     * @brief キャプチャ画像の横幅を取得
     *
     * @return キャプチャ画像の横幅を返します。
    */
    int GetWidth() const;


    /**
     * @brief キャプチャ画像の縦幅を取得
     *
     * @return キャプチャ画像の縦幅を返します。
    */
    int GetHeight() const;


    /**
     * @brief ピクセルデータを取得
     *
     * @return ピクセルデータを返します。
    */
    const uint8_t* GetPixels() const;
#endif

private:

#ifdef EFT_IS_CAFE
    nn::lmem::HeapHandle      m_HeapHandle;    //!< 拡張ヒープ
    int                       m_Width;         //!< キャプチャ画像の横幅(未使用)
    int                       m_Height;        //!< キャプチャ画像の縦幅(未使用)
    uint8_t*                  m_pRgbPixels;    //!< RGBデータ(未使用)

    u8*                       m_pColorConvertPixels;   //!< 色変換ピクセルデータ
    GX2ColorBuffer*           m_pColorConvertBuffer;   //!< 色変換バッファ

    u8*                       m_pTilingConvertPixels;  //!< タイリング変換ピクセルデータ
    GX2ColorBuffer*           m_pTilingConvertBuffer;  //!< タイリング変換バッファ
#endif
};

}
}
