﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

namespace nnt {
namespace gfx {

/**
* @brief バッファの比較処理クラス
*
* @details
*/
class NntGfxCompare
{
public:

    /**
     * @brief 誤差を許容したバッファの比較処理
     *
     * @param[in]  src          比較するバッファ1
     * @param[in]  srcSize      比較するバッファ1のサイズ
     * @param[in]  org          比較するバッファ2
     * @param[in]  orgSize      比較するバッファ2のサイズ
     * @param[in]  result       比較処理の結果
     * @param[out] dst          差分データの出力先バッファ
     * @param[in]  errorVal     1バイトあたりの許容誤差のサイズ
     * @param[in]  errorColorRed 差分値をR255として出すか
     * @return     比較処理が成功したか否か
     *
     * @details バッファ同士をサイズ分誤差を許容した比較処理を行います。
     *          比較は1バイト単位で行うため、許容誤差の値は1バイト単位に対する値を設定する必要があります。（デフォルトは15）
    */
    static bool Compare( const uint8_t* src, size_t srcSize, const uint8_t* org, size_t orgSize, bool& result, uint8_t* dst=NULL, int errorVal=15, bool errorColorRed=false );

private:

};

}
}

