﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/g3d_ResFile.h>
#include <nn/nn_Assert.h>

namespace nnt {
    namespace g3d {
        // G3d のテストのための初期化処理
        void InitializeG3dTest(nn::gfx::Device& device) NN_NOEXCEPT;

        // G3d のテストのための終了時処理
        void FinalizeG3dTest(nn::gfx::Device& device) NN_NOEXCEPT;


        // ファイル読み込み関数
        // 利用後は、UnLoadFile 関数で領域の解放が必要
        void* LoadFile(size_t* pOutReadSize, const char* filePath, size_t alignment) NN_NOEXCEPT;

        // ファイルの解放関数
        void UnloadFile(void* ptr) NN_NOEXCEPT;


        // メモリ領域を確保する関数
        void* Allocate(size_t allocateSize) NN_NOEXCEPT;

        // アラインメントを指定してメモリ領域を確保する関数
        void* AlignedAllocate(size_t allocateSize, size_t alignment) NN_NOEXCEPT;

        // アラインメントを指定してメモリ領域を確保する関数
        // template で指定された型へのキャストも行う
        template< typename T >
        T* AlignedAllocate(size_t allocateSize, size_t alignment) NN_NOEXCEPT {
            void* buffer = AlignedAllocate(allocateSize, alignment);
            NN_ASSERT_NOT_NULL(buffer);
            return reinterpret_cast<T*>(buffer);
        };

        // 利用したメモリ領域を解放する関数
        void Deallocate(void* ptr) NN_NOEXCEPT;
    }
}

