﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs.h>
#include <nn/fs/fsa/fs_IFileSystem.h>
#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/fsUtil/testFs_util_function.h>

namespace nnt { namespace fs { namespace util {

/**
   @brief TestFsでメモリーリークチェックするフィクスチャです。
*/
class CheckMemoryLeakFixture
{
public:
    CheckMemoryLeakFixture() NN_NOEXCEPT;
protected:
    void StartMemoryCheck() NN_NOEXCEPT;
    void StopMemoryLeakCheck() NN_NOEXCEPT;
    void DisableCheck() NN_NOEXCEPT;
private:
    int64_t m_MemoryAllocatedSize;
    bool m_Enabled;
};

/**
   @brief SetUp/TearDown 時に GlobalNewDeleteFlag をチェックするフィクスチャです。
   @details DeathTest を実装する場合は継承先のフィクスチャで DisableCheck() を実行してください。
*/
class CheckGlobalNewDeleteFlagTestFixture : public ::testing::Test
{
public:
    CheckGlobalNewDeleteFlagTestFixture() NN_NOEXCEPT;
protected:
    virtual void SetUp() NN_NOEXCEPT;
    virtual void TearDown() NN_NOEXCEPT;
    void DisableCheck() NN_NOEXCEPT;
private:
    bool m_Enabled;
};

/**
   @brief SetUp/TearDown 時に作業ディレクトリの作成／削除を事前にするフィクスチャです。
*/
class PrepareWorkDirFixture
{
public:
    PrepareWorkDirFixture() NN_NOEXCEPT;

    void CreateWorkRootPath() NN_NOEXCEPT;
    void DeleteWorkRootPath() NN_NOEXCEPT;
    String GetWorkRootPath() NN_NOEXCEPT;

private:
    TemporaryHostDirectory m_HostDirectory;
};


}}}
