﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/util/util_FormatString.h>
#include <nn/TargetConfigs/build_Compiler.h>

#include <nnt/nntest.h>
#include <nnt/fsUtil/testFs_util_allocator.h>

#define NNT_FS_SCOPED_TRACE_IMPL(NAME, ...)\
    auto NN_MACRO_CONCATENATE(scopedLockGlobalNewDeleteChecker_, __LINE__) = nnt::fs::util::GetScopedLockForGlobalNewDeleteChecker(); \
    EXPECT_FALSE(nnt::fs::util::IsGlobalNewDeleteCalled()); \
    auto NAME = nnt::fs::util::AllocateBuffer(300); \
    nn::util::SNPrintf(NAME.get(), 300, __VA_ARGS__); \
    auto NN_MACRO_CONCATENATE(isStackTraceDumpOnGlobalNewDeleteCallEnabled_, __LINE__) = nnt::fs::util::IsStackTraceDumpOnGlobalNewDeleteCallEnabled(); \
    nnt::fs::util::SetStackTraceDumpOnGlobalNewDeleteCallEnabled(false); \
    SCOPED_TRACE(NAME.get()); \
    nnt::fs::util::ResetGlobalNewDeleteFlag(); \
    nnt::fs::util::SetStackTraceDumpOnGlobalNewDeleteCallEnabled(NN_MACRO_CONCATENATE(isStackTraceDumpOnGlobalNewDeleteCallEnabled_, __LINE__)); \
    NN_MACRO_CONCATENATE(scopedLockGlobalNewDeleteChecker_, __LINE__).unlock()

#define NNT_FS_SCOPED_TRACE(...)\
    NNT_FS_SCOPED_TRACE_IMPL( NN_MAKE_TEMPORARY_NAME(message), __VA_ARGS__)

// Generic では SCOPED_TRACE はスレッド セーフではないので使用しません
#if defined(NN_BUILD_CONFIG_OS_WIN)
#define NNT_FS_SCOPED_TRACE_SAFE(...)
#else
#define NNT_FS_SCOPED_TRACE_SAFE(...) NNT_FS_SCOPED_TRACE(__VA_ARGS__)
#endif // defined(NN_BUILD_CONFIG_OS_WIN)

// ASSERT_NO_FATAL_FAILURE が定義されない環境への対応
#if defined(NN_SDK_BUILD_DEBUG) && defined(NN_BUILD_CONFIG_TOOLCHAIN_VC_VS2013)
#define NNT_FS_ASSERT_NO_FATAL_FAILURE
#elif defined(NN_BUILD_CONFIG_COMPILER_VC)
#define NNT_FS_ASSERT_NO_FATAL_FAILURE ASSERT_NO_FATAL_FAILURE
#else
#define NNT_FS_ASSERT_NO_FATAL_FAILURE(statement) \
    do \
    { \
        (statement); \
        if( ::testing::Test::HasFatalFailure() ) \
        { \
            return; \
        } \
    } while( NN_STATIC_CONDITION(false) )
#endif // defined(NN_BUILD_CONFIG_COMPILER_VC)
