﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nnt { namespace es {

    const int caNewCertSize = 1024;
    unsigned char caNewCert[] = {
        0x00, 0x01, 0x00, 0x03, 0x19, 0x49, 0x42, 0x9d, 0x1e, 0x58, 0xa6, 0x2e, 0x7e, 0x8b, 0x56, 0xd1, 0xb7, 0x6a, 0xe3, 0x02, 0xfd, 0x8b, 0x97, 0x49,
        0x1f, 0x77, 0x87, 0x45, 0xf7, 0x53, 0x88, 0xc4, 0xdd, 0x0b, 0xeb, 0x1d, 0xf1, 0x22, 0xfb, 0x96, 0x42, 0x15, 0x14, 0x97, 0x76, 0x4a, 0x53, 0xcf,
        0x78, 0x15, 0x18, 0x45, 0xe4, 0x2c, 0xa8, 0xfd, 0xe4, 0x86, 0xfd, 0x2a, 0x4f, 0x53, 0xf8, 0xa1, 0xba, 0x00, 0x8a, 0x74, 0x85, 0xff, 0x73, 0xb3,
        0xbf, 0x7e, 0x3c, 0x98, 0x07, 0x29, 0xd0, 0x65, 0x6b, 0x69, 0x32, 0x19, 0xad, 0xe8, 0x35, 0xeb, 0x5f, 0xff, 0xfc, 0xcb, 0x7c, 0xbb, 0x5e, 0x30,
        0x7f, 0xe0, 0x68, 0x8b, 0x88, 0x8e, 0xf2, 0xd2, 0x05, 0x3f, 0xb7, 0xe7, 0x91, 0xe9, 0x85, 0xfd, 0x15, 0xef, 0x10, 0xd7, 0x9c, 0xca, 0x88, 0xd6,
        0xbb, 0x15, 0xe8, 0xe4, 0x71, 0x4a, 0x98, 0xee, 0x09, 0xbf, 0x7b, 0x8a, 0xf0, 0x53, 0x23, 0x2b, 0x64, 0x50, 0xe6, 0xd5, 0xfd, 0xff, 0xc2, 0x0a,
        0x6d, 0x1e, 0xa6, 0xa2, 0x38, 0x12, 0xe1, 0x01, 0x45, 0x25, 0xd5, 0x6d, 0x40, 0x82, 0x70, 0x3b, 0x86, 0x98, 0x69, 0x59, 0xa7, 0x3c, 0xd1, 0xa1,
        0x43, 0x64, 0xd2, 0xc2, 0xda, 0xea, 0x96, 0xb0, 0x95, 0xf7, 0x6c, 0x46, 0xe4, 0xff, 0x41, 0x55, 0x46, 0x5e, 0x70, 0xef, 0x1e, 0xd3, 0x10, 0x53,
        0xd9, 0x70, 0x11, 0xe0, 0x10, 0xcc, 0x93, 0xe7, 0x91, 0x40, 0x13, 0x68, 0x7f, 0xa3, 0xa8, 0x02, 0x99, 0x6d, 0x1e, 0x55, 0x7b, 0x1c, 0xcc, 0x7a,
        0x7e, 0x8f, 0x58, 0x65, 0xc1, 0x74, 0x2e, 0x28, 0xe2, 0x6d, 0xef, 0x38, 0xa9, 0x3a, 0xb5, 0xd8, 0x2d, 0x43, 0xec, 0xcc, 0xbf, 0x0b, 0xef, 0x22,
        0xe1, 0xfd, 0x57, 0xe2, 0x86, 0x43, 0x33, 0x58, 0x2f, 0xed, 0xea, 0xbc, 0x01, 0x2f, 0x98, 0x6d, 0xdf, 0xc3, 0xe9, 0x44, 0x79, 0x73, 0x47, 0x03,
        0x08, 0x45, 0x5b, 0xdc, 0x57, 0xaa, 0x17, 0x0b, 0x84, 0x42, 0x7f, 0x73, 0xa2, 0x9b, 0x48, 0xf6, 0xda, 0x13, 0x5f, 0x66, 0xc7, 0x45, 0xc1, 0x42,
        0xa8, 0x4a, 0xfb, 0x0e, 0x6a, 0x5e, 0xed, 0x85, 0xd7, 0xb9, 0x71, 0x99, 0x36, 0xf8, 0xce, 0x2b, 0x62, 0x1f, 0x39, 0x5f, 0x40, 0xdc, 0x03, 0xbe,
        0xf8, 0x85, 0x4c, 0x11, 0x17, 0xff, 0x0c, 0x12, 0x86, 0x41, 0xcc, 0x78, 0x43, 0xb9, 0x7b, 0x43, 0x46, 0xdb, 0x22, 0x6f, 0x60, 0x26, 0xac, 0xb5,
        0x6c, 0x27, 0x8b, 0x8e, 0x0e, 0xa7, 0x9a, 0x2d, 0x65, 0xef, 0x79, 0x8e, 0x10, 0x78, 0xad, 0x80, 0xed, 0x4b, 0x96, 0x04, 0xd2, 0xf0, 0x8b, 0x2c,
        0xd6, 0x4a, 0x23, 0xa3, 0xdb, 0x27, 0x08, 0x33, 0xb4, 0x02, 0xf8, 0x08, 0x51, 0xf3, 0x5b, 0xed, 0x3e, 0xe4, 0x57, 0x7c, 0x66, 0x60, 0xfb, 0xf1,
        0x6d, 0x94, 0x13, 0xe0, 0x9c, 0x91, 0x7a, 0x49, 0xd4, 0x2c, 0x6d, 0xa3, 0x75, 0xbc, 0x27, 0xf0, 0x23, 0x0d, 0xb9, 0x8f, 0x89, 0x73, 0xab, 0x02,
        0x7b, 0x52, 0x2c, 0xd5, 0x7e, 0xc0, 0x3d, 0x25, 0xe8, 0xb3, 0xfc, 0x34, 0x94, 0xc9, 0x7f, 0xb1, 0x08, 0xfe, 0x18, 0xc6, 0x8a, 0x43, 0x36, 0xe4,
        0x6c, 0x26, 0xb6, 0xf2, 0x80, 0xd2, 0x7e, 0x34, 0xbe, 0x28, 0x7c, 0x3e, 0x46, 0x87, 0xbc, 0x9d, 0x77, 0x6b, 0x76, 0xd9, 0x28, 0xd1, 0xb6, 0x35,
        0x2e, 0xc0, 0x34, 0x7d, 0x72, 0x94, 0xaa, 0x93, 0x60, 0x26, 0x8d, 0x26, 0xf5, 0xf6, 0x52, 0x06, 0x4a, 0xf2, 0x40, 0xd7, 0xd0, 0x0c, 0x7c, 0x5e,
        0xa3, 0xc3, 0x2d, 0xe6, 0x2d, 0x9b, 0x5c, 0x4b, 0x4c, 0xab, 0x6f, 0xd7, 0xbd, 0x37, 0x1d, 0x57, 0xc2, 0x16, 0x60, 0x95, 0x91, 0x0e, 0x4a, 0xd8,
        0xe9, 0xed, 0x18, 0x1e, 0xf7, 0x61, 0x93, 0x61, 0x53, 0x89, 0x2d, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x52, 0x6f, 0x6f, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x43, 0x41, 0x30, 0x30,
        0x30, 0x30, 0x30, 0x30, 0x30, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x12, 0x2a, 0x46, 0xc9, 0xcc, 0x2d, 0xc4, 0xdf, 0x29, 0x30, 0xe4,
        0xdf, 0x3f, 0x8c, 0x70, 0xa0, 0x78, 0x94, 0x87, 0x75, 0xad, 0x5e, 0x9a, 0xa6, 0x04, 0xc5, 0xb4, 0xd8, 0xea, 0xff, 0x2a, 0xa1, 0xd2, 0x14, 0x67,
        0x65, 0x64, 0xef, 0xca, 0x28, 0xcc, 0x00, 0x15, 0x45, 0x54, 0xa1, 0xa3, 0xea, 0x13, 0x79, 0xe9, 0xe6, 0xca, 0xac, 0xed, 0x15, 0x93, 0xfe, 0x88,
        0xd8, 0x9a, 0xc6, 0xb8, 0xac, 0xcc, 0xab, 0x6e, 0x20, 0x7c, 0xeb, 0x7c, 0xca, 0x29, 0x80, 0x9e, 0x29, 0x80, 0x44, 0x06, 0x62, 0xb7, 0xd4, 0x38,
        0x2a, 0x15, 0xda, 0x43, 0x08, 0x57, 0x45, 0xa9, 0xaa, 0xe5, 0x9a, 0xa0, 0x5b, 0xdb, 0x32, 0xf6, 0x68, 0x69, 0xa2, 0xdd, 0x42, 0x95, 0x38, 0x6c,
        0x87, 0xec, 0xdd, 0x35, 0x08, 0xa2, 0xcf, 0x60, 0xd0, 0x1e, 0x23, 0xec, 0x2f, 0xe6, 0x98, 0xf4, 0x70, 0xd6, 0x00, 0x15, 0x49, 0xa2, 0xf0, 0x67,
        0x59, 0x13, 0x1e, 0x53, 0x4c, 0x70, 0x06, 0x05, 0x7d, 0xef, 0x1d, 0x18, 0xa8, 0x3f, 0x0a, 0xc7, 0x9c, 0xfe, 0x80, 0xff, 0x5a, 0x91, 0xf2, 0xbe,
        0xd4, 0xa0, 0x83, 0x70, 0x61, 0x19, 0x0a, 0x03, 0x29, 0x90, 0x21, 0x65, 0x40, 0x3c, 0x9a, 0x90, 0x8f, 0xb6, 0x15, 0x73, 0x9f, 0x3c, 0xe3, 0x3b,
        0xf1, 0xba, 0xea, 0x16, 0xc2, 0x5b, 0xce, 0xd7, 0x96, 0x3f, 0xac, 0xc9, 0xd2, 0x4d, 0x9c, 0x0a, 0xd7, 0x6f, 0xc0, 0x20, 0xb2, 0xc4, 0xb8, 0x4c,
        0x10, 0xa7, 0x41, 0xa2, 0xcc, 0x7d, 0x9b, 0xac, 0x3a, 0xac, 0xcc, 0xa3, 0x52, 0x9b, 0xac, 0x31, 0x6a, 0x9a, 0xa7, 0x5d, 0x2a, 0x26, 0xc7, 0xd7,
        0xd2, 0x88, 0xcb, 0xa4, 0x66, 0xc5, 0xfe, 0x5f, 0x45, 0x4a, 0xe6, 0x79, 0x74, 0x4a, 0x90, 0xa1, 0x57, 0x72, 0xdb, 0x3b, 0x0e, 0x47, 0xa4, 0x9a,
        0xf0, 0x31, 0xd1, 0x6d, 0xbe, 0xab, 0x33, 0x2b, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    };

    const int xsNewCertSize = 768;
    unsigned char xsNewCert[] = {
        0x00, 0x01, 0x00, 0x04, 0x60, 0x34, 0x83, 0xF7, 0xF4, 0xEF, 0x3C, 0x86, 0x3F, 0xF7, 0xB4, 0x68, 0x21, 0xE9, 0xD8, 0x39, 0x83, 0xEF, 0xB0, 0xBA,
        0x29, 0xC4, 0x5B, 0x10, 0xDF, 0xB2, 0xE8, 0xA2, 0x68, 0xAE, 0x06, 0x08, 0x4D, 0xFE, 0xB0, 0xB9, 0x68, 0x0B, 0x6D, 0x40, 0xD6, 0xDF, 0x82, 0xCA,
        0xE7, 0xD6, 0x51, 0xE2, 0x8F, 0x31, 0x36, 0x4F, 0x5A, 0xB5, 0x67, 0xDD, 0x9D, 0xCC, 0xFC, 0xBB, 0x5E, 0xFF, 0x8F, 0x1C, 0xEA, 0x92, 0x48, 0x9C,
        0x04, 0x6E, 0x8B, 0xED, 0x2A, 0xF0, 0xD7, 0xF9, 0xCA, 0x0B, 0xD5, 0x0F, 0x68, 0x36, 0x33, 0xD6, 0x81, 0xB0, 0x8D, 0x1A, 0xF4, 0x17, 0xD7, 0xB7,
        0xF8, 0x76, 0x2A, 0xD8, 0x8E, 0x3A, 0xF0, 0xD1, 0xC4, 0x5D, 0xAC, 0x54, 0x07, 0xB9, 0xD8, 0xF2, 0x4F, 0x16, 0x7A, 0xED, 0xC7, 0xC5, 0xDB, 0xCF,
        0x4E, 0x0E, 0x17, 0x6E, 0xC3, 0x41, 0xD4, 0xF9, 0xBA, 0x8A, 0xDF, 0xE7, 0x49, 0xCF, 0x37, 0xF4, 0x56, 0x88, 0x65, 0x38, 0x86, 0x56, 0x6A, 0x90,
        0x45, 0xED, 0x89, 0xAD, 0x35, 0x3D, 0xD2, 0x89, 0xE3, 0x26, 0x31, 0x86, 0x7B, 0xDF, 0xD7, 0xFC, 0x67, 0x73, 0x8B, 0xDF, 0x0E, 0x1E, 0x85, 0x8F,
        0x3B, 0xF9, 0xDE, 0xE2, 0x5B, 0x02, 0x20, 0x6F, 0x0B, 0x7F, 0xFB, 0x61, 0xF8, 0x66, 0xDA, 0x4D, 0x86, 0x2D, 0x77, 0xDD, 0xBD, 0xA9, 0x66, 0x8B,
        0xB6, 0x1C, 0xBD, 0xEF, 0xAC, 0xB2, 0x58, 0x3C, 0xE5, 0xC9, 0xFA, 0xB2, 0x2F, 0xC9, 0x0E, 0xF8, 0xEB, 0x06, 0x95, 0x47, 0x43, 0xE5, 0xA3, 0x2A,
        0x37, 0xA3, 0x51, 0x3C, 0x6C, 0x79, 0x5B, 0xC8, 0xE0, 0xC6, 0x5E, 0x2F, 0x17, 0x0B, 0x43, 0x5A, 0x8C, 0x44, 0x77, 0x65, 0x38, 0x1C, 0x40, 0x50,
        0x42, 0x7F, 0x88, 0xE9, 0x82, 0x8E, 0x6E, 0x94, 0x14, 0x4D, 0x28, 0x44, 0x1C, 0x7F, 0x9C, 0x7F, 0x6D, 0x92, 0xFE, 0x5B, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x6F, 0x6F, 0x74, 0x2D, 0x43, 0x41, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x34, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x01, 0x58, 0x53, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x32, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xBA, 0x27, 0x84, 0x28, 0x76, 0x5D, 0x87, 0x9A, 0x7F, 0x21, 0x54, 0x04, 0xC6, 0xEE, 0x4E, 0x0A, 0x0D, 0x3F, 0x66, 0xC3, 0x3B, 0xC7, 0xF8, 0xA3,
        0x2F, 0xD8, 0x98, 0xE5, 0x2C, 0xB7, 0xB6, 0x34, 0x43, 0xCE, 0xD8, 0xB0, 0x05, 0x27, 0xD8, 0x9D, 0xED, 0xC6, 0xBB, 0xF6, 0x0A, 0xD1, 0xC5, 0xC9,
        0x92, 0x30, 0x21, 0xDD, 0x55, 0x5F, 0x9B, 0xAD, 0x4B, 0xE0, 0xC0, 0xC4, 0x06, 0xD3, 0x70, 0x29, 0x15, 0xE5, 0xB3, 0x4A, 0xC2, 0xD2, 0xAB, 0xE5,
        0x03, 0xC3, 0x2A, 0x3A, 0x23, 0xB4, 0x38, 0x34, 0xC9, 0x15, 0x7B, 0x9A, 0x0A, 0xF2, 0xE4, 0xE9, 0xC0, 0x3B, 0xED, 0xE2, 0xB4, 0xC1, 0x15, 0xF5,
        0x35, 0x3D, 0xFC, 0x66, 0xBD, 0x04, 0xA6, 0xC0, 0x79, 0x97, 0x0E, 0x38, 0xCB, 0xDD, 0x5A, 0x50, 0xA2, 0xB9, 0x8F, 0xF2, 0xD7, 0x65, 0xFC, 0xF8,
        0x33, 0x81, 0xE9, 0xE0, 0xE8, 0x49, 0xC3, 0x57, 0x35, 0x78, 0x37, 0x8F, 0xF6, 0x59, 0x51, 0x61, 0x3E, 0x95, 0xF7, 0x5E, 0xE8, 0xEF, 0x26, 0x18,
        0x3A, 0x40, 0xAA, 0xE4, 0xA7, 0x6D, 0x73, 0x84, 0xEA, 0x47, 0x8D, 0x2C, 0xDC, 0xE8, 0x0F, 0xBA, 0x03, 0x21, 0xA6, 0xBF, 0x8D, 0x69, 0x98, 0x3C,
        0x3A, 0xA7, 0xAE, 0x54, 0x43, 0xB7, 0x2B, 0xFE, 0x41, 0x0B, 0xF1, 0x32, 0x3C, 0xBD, 0x88, 0xC3, 0x56, 0x0E, 0xA1, 0x3D, 0x17, 0xD3, 0x8A, 0x2E,
        0x34, 0x04, 0x1D, 0xE7, 0xAA, 0xF3, 0x89, 0xDE, 0x43, 0x75, 0x22, 0x5C, 0xA8, 0x7E, 0xE3, 0x49, 0xC7, 0x60, 0xC7, 0xD9, 0x9B, 0xE7, 0xE7, 0x37,
        0xC6, 0x26, 0x1C, 0xC7, 0x4E, 0x25, 0xAE, 0x46, 0x52, 0x7A, 0xC9, 0x61, 0x9F, 0x93, 0x90, 0x57, 0x08, 0x8D, 0x74, 0x35, 0xA6, 0xDE, 0x7B, 0x25,
        0xAB, 0x82, 0xDD, 0x54, 0x10, 0xF2, 0x57, 0x9C, 0xAE, 0xF1, 0x49, 0x1A, 0x90, 0x9D, 0x30, 0x2B, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    };

    const int CertificateSize = caNewCertSize + xsNewCertSize;
    unsigned char Certificate[] = { // ca + xs
        0x00, 0x01, 0x00, 0x03, 0x19, 0x49, 0x42, 0x9d, 0x1e, 0x58, 0xa6, 0x2e, 0x7e, 0x8b, 0x56, 0xd1, 0xb7, 0x6a, 0xe3, 0x02, 0xfd, 0x8b, 0x97, 0x49,
        0x1f, 0x77, 0x87, 0x45, 0xf7, 0x53, 0x88, 0xc4, 0xdd, 0x0b, 0xeb, 0x1d, 0xf1, 0x22, 0xfb, 0x96, 0x42, 0x15, 0x14, 0x97, 0x76, 0x4a, 0x53, 0xcf,
        0x78, 0x15, 0x18, 0x45, 0xe4, 0x2c, 0xa8, 0xfd, 0xe4, 0x86, 0xfd, 0x2a, 0x4f, 0x53, 0xf8, 0xa1, 0xba, 0x00, 0x8a, 0x74, 0x85, 0xff, 0x73, 0xb3,
        0xbf, 0x7e, 0x3c, 0x98, 0x07, 0x29, 0xd0, 0x65, 0x6b, 0x69, 0x32, 0x19, 0xad, 0xe8, 0x35, 0xeb, 0x5f, 0xff, 0xfc, 0xcb, 0x7c, 0xbb, 0x5e, 0x30,
        0x7f, 0xe0, 0x68, 0x8b, 0x88, 0x8e, 0xf2, 0xd2, 0x05, 0x3f, 0xb7, 0xe7, 0x91, 0xe9, 0x85, 0xfd, 0x15, 0xef, 0x10, 0xd7, 0x9c, 0xca, 0x88, 0xd6,
        0xbb, 0x15, 0xe8, 0xe4, 0x71, 0x4a, 0x98, 0xee, 0x09, 0xbf, 0x7b, 0x8a, 0xf0, 0x53, 0x23, 0x2b, 0x64, 0x50, 0xe6, 0xd5, 0xfd, 0xff, 0xc2, 0x0a,
        0x6d, 0x1e, 0xa6, 0xa2, 0x38, 0x12, 0xe1, 0x01, 0x45, 0x25, 0xd5, 0x6d, 0x40, 0x82, 0x70, 0x3b, 0x86, 0x98, 0x69, 0x59, 0xa7, 0x3c, 0xd1, 0xa1,
        0x43, 0x64, 0xd2, 0xc2, 0xda, 0xea, 0x96, 0xb0, 0x95, 0xf7, 0x6c, 0x46, 0xe4, 0xff, 0x41, 0x55, 0x46, 0x5e, 0x70, 0xef, 0x1e, 0xd3, 0x10, 0x53,
        0xd9, 0x70, 0x11, 0xe0, 0x10, 0xcc, 0x93, 0xe7, 0x91, 0x40, 0x13, 0x68, 0x7f, 0xa3, 0xa8, 0x02, 0x99, 0x6d, 0x1e, 0x55, 0x7b, 0x1c, 0xcc, 0x7a,
        0x7e, 0x8f, 0x58, 0x65, 0xc1, 0x74, 0x2e, 0x28, 0xe2, 0x6d, 0xef, 0x38, 0xa9, 0x3a, 0xb5, 0xd8, 0x2d, 0x43, 0xec, 0xcc, 0xbf, 0x0b, 0xef, 0x22,
        0xe1, 0xfd, 0x57, 0xe2, 0x86, 0x43, 0x33, 0x58, 0x2f, 0xed, 0xea, 0xbc, 0x01, 0x2f, 0x98, 0x6d, 0xdf, 0xc3, 0xe9, 0x44, 0x79, 0x73, 0x47, 0x03,
        0x08, 0x45, 0x5b, 0xdc, 0x57, 0xaa, 0x17, 0x0b, 0x84, 0x42, 0x7f, 0x73, 0xa2, 0x9b, 0x48, 0xf6, 0xda, 0x13, 0x5f, 0x66, 0xc7, 0x45, 0xc1, 0x42,
        0xa8, 0x4a, 0xfb, 0x0e, 0x6a, 0x5e, 0xed, 0x85, 0xd7, 0xb9, 0x71, 0x99, 0x36, 0xf8, 0xce, 0x2b, 0x62, 0x1f, 0x39, 0x5f, 0x40, 0xdc, 0x03, 0xbe,
        0xf8, 0x85, 0x4c, 0x11, 0x17, 0xff, 0x0c, 0x12, 0x86, 0x41, 0xcc, 0x78, 0x43, 0xb9, 0x7b, 0x43, 0x46, 0xdb, 0x22, 0x6f, 0x60, 0x26, 0xac, 0xb5,
        0x6c, 0x27, 0x8b, 0x8e, 0x0e, 0xa7, 0x9a, 0x2d, 0x65, 0xef, 0x79, 0x8e, 0x10, 0x78, 0xad, 0x80, 0xed, 0x4b, 0x96, 0x04, 0xd2, 0xf0, 0x8b, 0x2c,
        0xd6, 0x4a, 0x23, 0xa3, 0xdb, 0x27, 0x08, 0x33, 0xb4, 0x02, 0xf8, 0x08, 0x51, 0xf3, 0x5b, 0xed, 0x3e, 0xe4, 0x57, 0x7c, 0x66, 0x60, 0xfb, 0xf1,
        0x6d, 0x94, 0x13, 0xe0, 0x9c, 0x91, 0x7a, 0x49, 0xd4, 0x2c, 0x6d, 0xa3, 0x75, 0xbc, 0x27, 0xf0, 0x23, 0x0d, 0xb9, 0x8f, 0x89, 0x73, 0xab, 0x02,
        0x7b, 0x52, 0x2c, 0xd5, 0x7e, 0xc0, 0x3d, 0x25, 0xe8, 0xb3, 0xfc, 0x34, 0x94, 0xc9, 0x7f, 0xb1, 0x08, 0xfe, 0x18, 0xc6, 0x8a, 0x43, 0x36, 0xe4,
        0x6c, 0x26, 0xb6, 0xf2, 0x80, 0xd2, 0x7e, 0x34, 0xbe, 0x28, 0x7c, 0x3e, 0x46, 0x87, 0xbc, 0x9d, 0x77, 0x6b, 0x76, 0xd9, 0x28, 0xd1, 0xb6, 0x35,
        0x2e, 0xc0, 0x34, 0x7d, 0x72, 0x94, 0xaa, 0x93, 0x60, 0x26, 0x8d, 0x26, 0xf5, 0xf6, 0x52, 0x06, 0x4a, 0xf2, 0x40, 0xd7, 0xd0, 0x0c, 0x7c, 0x5e,
        0xa3, 0xc3, 0x2d, 0xe6, 0x2d, 0x9b, 0x5c, 0x4b, 0x4c, 0xab, 0x6f, 0xd7, 0xbd, 0x37, 0x1d, 0x57, 0xc2, 0x16, 0x60, 0x95, 0x91, 0x0e, 0x4a, 0xd8,
        0xe9, 0xed, 0x18, 0x1e, 0xf7, 0x61, 0x93, 0x61, 0x53, 0x89, 0x2d, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x52, 0x6f, 0x6f, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x43, 0x41, 0x30, 0x30,
        0x30, 0x30, 0x30, 0x30, 0x30, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x12, 0x2a, 0x46, 0xc9, 0xcc, 0x2d, 0xc4, 0xdf, 0x29, 0x30, 0xe4,
        0xdf, 0x3f, 0x8c, 0x70, 0xa0, 0x78, 0x94, 0x87, 0x75, 0xad, 0x5e, 0x9a, 0xa6, 0x04, 0xc5, 0xb4, 0xd8, 0xea, 0xff, 0x2a, 0xa1, 0xd2, 0x14, 0x67,
        0x65, 0x64, 0xef, 0xca, 0x28, 0xcc, 0x00, 0x15, 0x45, 0x54, 0xa1, 0xa3, 0xea, 0x13, 0x79, 0xe9, 0xe6, 0xca, 0xac, 0xed, 0x15, 0x93, 0xfe, 0x88,
        0xd8, 0x9a, 0xc6, 0xb8, 0xac, 0xcc, 0xab, 0x6e, 0x20, 0x7c, 0xeb, 0x7c, 0xca, 0x29, 0x80, 0x9e, 0x29, 0x80, 0x44, 0x06, 0x62, 0xb7, 0xd4, 0x38,
        0x2a, 0x15, 0xda, 0x43, 0x08, 0x57, 0x45, 0xa9, 0xaa, 0xe5, 0x9a, 0xa0, 0x5b, 0xdb, 0x32, 0xf6, 0x68, 0x69, 0xa2, 0xdd, 0x42, 0x95, 0x38, 0x6c,
        0x87, 0xec, 0xdd, 0x35, 0x08, 0xa2, 0xcf, 0x60, 0xd0, 0x1e, 0x23, 0xec, 0x2f, 0xe6, 0x98, 0xf4, 0x70, 0xd6, 0x00, 0x15, 0x49, 0xa2, 0xf0, 0x67,
        0x59, 0x13, 0x1e, 0x53, 0x4c, 0x70, 0x06, 0x05, 0x7d, 0xef, 0x1d, 0x18, 0xa8, 0x3f, 0x0a, 0xc7, 0x9c, 0xfe, 0x80, 0xff, 0x5a, 0x91, 0xf2, 0xbe,
        0xd4, 0xa0, 0x83, 0x70, 0x61, 0x19, 0x0a, 0x03, 0x29, 0x90, 0x21, 0x65, 0x40, 0x3c, 0x9a, 0x90, 0x8f, 0xb6, 0x15, 0x73, 0x9f, 0x3c, 0xe3, 0x3b,
        0xf1, 0xba, 0xea, 0x16, 0xc2, 0x5b, 0xce, 0xd7, 0x96, 0x3f, 0xac, 0xc9, 0xd2, 0x4d, 0x9c, 0x0a, 0xd7, 0x6f, 0xc0, 0x20, 0xb2, 0xc4, 0xb8, 0x4c,
        0x10, 0xa7, 0x41, 0xa2, 0xcc, 0x7d, 0x9b, 0xac, 0x3a, 0xac, 0xcc, 0xa3, 0x52, 0x9b, 0xac, 0x31, 0x6a, 0x9a, 0xa7, 0x5d, 0x2a, 0x26, 0xc7, 0xd7,
        0xd2, 0x88, 0xcb, 0xa4, 0x66, 0xc5, 0xfe, 0x5f, 0x45, 0x4a, 0xe6, 0x79, 0x74, 0x4a, 0x90, 0xa1, 0x57, 0x72, 0xdb, 0x3b, 0x0e, 0x47, 0xa4, 0x9a,
        0xf0, 0x31, 0xd1, 0x6d, 0xbe, 0xab, 0x33, 0x2b, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x01, 0x00, 0x04, 0x60, 0x34, 0x83, 0xF7, 0xF4, 0xEF, 0x3C, 0x86, 0x3F, 0xF7, 0xB4, 0x68, 0x21, 0xE9, 0xD8, 0x39, 0x83, 0xEF, 0xB0, 0xBA,
        0x29, 0xC4, 0x5B, 0x10, 0xDF, 0xB2, 0xE8, 0xA2, 0x68, 0xAE, 0x06, 0x08, 0x4D, 0xFE, 0xB0, 0xB9, 0x68, 0x0B, 0x6D, 0x40, 0xD6, 0xDF, 0x82, 0xCA,
        0xE7, 0xD6, 0x51, 0xE2, 0x8F, 0x31, 0x36, 0x4F, 0x5A, 0xB5, 0x67, 0xDD, 0x9D, 0xCC, 0xFC, 0xBB, 0x5E, 0xFF, 0x8F, 0x1C, 0xEA, 0x92, 0x48, 0x9C,
        0x04, 0x6E, 0x8B, 0xED, 0x2A, 0xF0, 0xD7, 0xF9, 0xCA, 0x0B, 0xD5, 0x0F, 0x68, 0x36, 0x33, 0xD6, 0x81, 0xB0, 0x8D, 0x1A, 0xF4, 0x17, 0xD7, 0xB7,
        0xF8, 0x76, 0x2A, 0xD8, 0x8E, 0x3A, 0xF0, 0xD1, 0xC4, 0x5D, 0xAC, 0x54, 0x07, 0xB9, 0xD8, 0xF2, 0x4F, 0x16, 0x7A, 0xED, 0xC7, 0xC5, 0xDB, 0xCF,
        0x4E, 0x0E, 0x17, 0x6E, 0xC3, 0x41, 0xD4, 0xF9, 0xBA, 0x8A, 0xDF, 0xE7, 0x49, 0xCF, 0x37, 0xF4, 0x56, 0x88, 0x65, 0x38, 0x86, 0x56, 0x6A, 0x90,
        0x45, 0xED, 0x89, 0xAD, 0x35, 0x3D, 0xD2, 0x89, 0xE3, 0x26, 0x31, 0x86, 0x7B, 0xDF, 0xD7, 0xFC, 0x67, 0x73, 0x8B, 0xDF, 0x0E, 0x1E, 0x85, 0x8F,
        0x3B, 0xF9, 0xDE, 0xE2, 0x5B, 0x02, 0x20, 0x6F, 0x0B, 0x7F, 0xFB, 0x61, 0xF8, 0x66, 0xDA, 0x4D, 0x86, 0x2D, 0x77, 0xDD, 0xBD, 0xA9, 0x66, 0x8B,
        0xB6, 0x1C, 0xBD, 0xEF, 0xAC, 0xB2, 0x58, 0x3C, 0xE5, 0xC9, 0xFA, 0xB2, 0x2F, 0xC9, 0x0E, 0xF8, 0xEB, 0x06, 0x95, 0x47, 0x43, 0xE5, 0xA3, 0x2A,
        0x37, 0xA3, 0x51, 0x3C, 0x6C, 0x79, 0x5B, 0xC8, 0xE0, 0xC6, 0x5E, 0x2F, 0x17, 0x0B, 0x43, 0x5A, 0x8C, 0x44, 0x77, 0x65, 0x38, 0x1C, 0x40, 0x50,
        0x42, 0x7F, 0x88, 0xE9, 0x82, 0x8E, 0x6E, 0x94, 0x14, 0x4D, 0x28, 0x44, 0x1C, 0x7F, 0x9C, 0x7F, 0x6D, 0x92, 0xFE, 0x5B, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x6F, 0x6F, 0x74, 0x2D, 0x43, 0x41, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x34, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x01, 0x58, 0x53, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x32, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xBA, 0x27, 0x84, 0x28, 0x76, 0x5D, 0x87, 0x9A, 0x7F, 0x21, 0x54, 0x04, 0xC6, 0xEE, 0x4E, 0x0A, 0x0D, 0x3F, 0x66, 0xC3, 0x3B, 0xC7, 0xF8, 0xA3,
        0x2F, 0xD8, 0x98, 0xE5, 0x2C, 0xB7, 0xB6, 0x34, 0x43, 0xCE, 0xD8, 0xB0, 0x05, 0x27, 0xD8, 0x9D, 0xED, 0xC6, 0xBB, 0xF6, 0x0A, 0xD1, 0xC5, 0xC9,
        0x92, 0x30, 0x21, 0xDD, 0x55, 0x5F, 0x9B, 0xAD, 0x4B, 0xE0, 0xC0, 0xC4, 0x06, 0xD3, 0x70, 0x29, 0x15, 0xE5, 0xB3, 0x4A, 0xC2, 0xD2, 0xAB, 0xE5,
        0x03, 0xC3, 0x2A, 0x3A, 0x23, 0xB4, 0x38, 0x34, 0xC9, 0x15, 0x7B, 0x9A, 0x0A, 0xF2, 0xE4, 0xE9, 0xC0, 0x3B, 0xED, 0xE2, 0xB4, 0xC1, 0x15, 0xF5,
        0x35, 0x3D, 0xFC, 0x66, 0xBD, 0x04, 0xA6, 0xC0, 0x79, 0x97, 0x0E, 0x38, 0xCB, 0xDD, 0x5A, 0x50, 0xA2, 0xB9, 0x8F, 0xF2, 0xD7, 0x65, 0xFC, 0xF8,
        0x33, 0x81, 0xE9, 0xE0, 0xE8, 0x49, 0xC3, 0x57, 0x35, 0x78, 0x37, 0x8F, 0xF6, 0x59, 0x51, 0x61, 0x3E, 0x95, 0xF7, 0x5E, 0xE8, 0xEF, 0x26, 0x18,
        0x3A, 0x40, 0xAA, 0xE4, 0xA7, 0x6D, 0x73, 0x84, 0xEA, 0x47, 0x8D, 0x2C, 0xDC, 0xE8, 0x0F, 0xBA, 0x03, 0x21, 0xA6, 0xBF, 0x8D, 0x69, 0x98, 0x3C,
        0x3A, 0xA7, 0xAE, 0x54, 0x43, 0xB7, 0x2B, 0xFE, 0x41, 0x0B, 0xF1, 0x32, 0x3C, 0xBD, 0x88, 0xC3, 0x56, 0x0E, 0xA1, 0x3D, 0x17, 0xD3, 0x8A, 0x2E,
        0x34, 0x04, 0x1D, 0xE7, 0xAA, 0xF3, 0x89, 0xDE, 0x43, 0x75, 0x22, 0x5C, 0xA8, 0x7E, 0xE3, 0x49, 0xC7, 0x60, 0xC7, 0xD9, 0x9B, 0xE7, 0xE7, 0x37,
        0xC6, 0x26, 0x1C, 0xC7, 0x4E, 0x25, 0xAE, 0x46, 0x52, 0x7A, 0xC9, 0x61, 0x9F, 0x93, 0x90, 0x57, 0x08, 0x8D, 0x74, 0x35, 0xA6, 0xDE, 0x7B, 0x25,
        0xAB, 0x82, 0xDD, 0x54, 0x10, 0xF2, 0x57, 0x9C, 0xAE, 0xF1, 0x49, 0x1A, 0x90, 0x9D, 0x30, 0x2B, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    };
}}
