﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

#include <nn/codec/codec_OpusCommon.h>
#include <nn/codec/codec_OpusEncoderTypes.h>
#include <nn/codec/detail/codec_OpusEncoderTypesInternal.h>

namespace nnt {
namespace codec {
namespace util {

/**
 * @brief       libopus の各種値を sdk の列挙型に変換します。
 */
nn::codec::OpusResult ConvertResult(int result) NN_NOEXCEPT;
nn::codec::OpusBandwidth ConvertBandwidth(int bandwidth) NN_NOEXCEPT;

/**
 * @brief       opus パケット情報をダンプします。
 */
void DumpOpusPacket(const uint8_t* packet, std::size_t size, int streamCount) NN_NOEXCEPT;

}}} // nnt::codec::util
