﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstddef> // nullptr, std::size_t
#include <cstdlib> // std::malloc, std::free

#include <nnt/codecUtil/testCodec_TestBase.h>
#include <nnt/codecUtil/testCodec_ObjectBase.h>

namespace nnt {
namespace codec {

template <typename EncoderType>
class OpusEncoderBase
    : protected ObjectBase
{

protected:
    OpusEncoderBase() NN_NOEXCEPT
        : encoder()
        , encoderWorkBufferAddress(nullptr)
        , encoderWorkBufferSize(0)
    {}

    virtual ~OpusEncoderBase() NN_NOEXCEPT
    {
        if (nullptr != encoderWorkBufferAddress)
        {
            std::free(encoderWorkBufferAddress);
        }
        encoderWorkBufferAddress = nullptr;
    }

    virtual void Initialize(const TestParameterSet& parameterSet) NN_NOEXCEPT
    {
        // Define some aliases
        const int& sampleRate = parameterSet.sampleRate;
        const int& channelCount = parameterSet.channelCount;
        NN_ASSERT(sampleRate != 0);
        NN_ASSERT(channelCount != 0);
        // Initializing
        encoderWorkBufferSize = encoder.GetWorkBufferSize(sampleRate, channelCount);
        encoderWorkBufferAddress = std::malloc(encoderWorkBufferSize);
        ASSERT_NE(nullptr, encoderWorkBufferAddress);
        // encoder.Initialize() を呼ぶかどうかはテスト次第なので、ここではしない。
        m_IsInitialized = true;
    }

    virtual void Finalize() NN_NOEXCEPT
    {
        m_IsInitialized = false;
        if (encoder.IsInitialized())
        {
            encoder.Finalize();
        }
        if (nullptr != encoderWorkBufferAddress)
        {
            std::free(encoderWorkBufferAddress);
        }
        encoderWorkBufferAddress = nullptr;
        encoderWorkBufferSize = 0;
    }

    EncoderType encoder;
    void* encoderWorkBufferAddress;
    std::size_t encoderWorkBufferSize;
};

}} // nnt::codec
