﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

namespace nnt {
namespace codec {
namespace util {

class CoreSelector
{
public:
    CoreSelector() NN_NOEXCEPT
        : m_CoreCount(0)
        , m_IsInitialized(false)
        , m_Counter(0)

    {
        const nn::Bit64 coreMask = nn::os::GetThreadAvailableCoreMask();
        m_CoreCount = MakeCoreNumberArray(m_CoreNumberArray, coreMask);
        m_IsInitialized = true;
    }

    inline bool IsInitialized() const NN_NOEXCEPT
    {
        return m_IsInitialized;
    }

    inline int GetCoreCount() const NN_NOEXCEPT
    {
        return m_CoreCount;
    }

    // コア番号を返して、内部カウンタを進める。
    inline int PostIncrement() NN_NOEXCEPT
    {
        return static_cast<int>(m_CoreNumberArray[m_Counter++ % m_CoreCount]);
    }

private:

    int MakeCoreNumberArray(uint8_t* array, nn::Bit64 mask) NN_NOEXCEPT
    {
        int count = 0;
        for (auto i = 0; mask != 0; mask >>=1, ++i)
        {
            if (mask & 1)
            {
                array[i] = static_cast<uint8_t>(i);
                count++;
            }
        }
        return count;
    }

    static const int CoreNumberMaximum = 64;
    int m_CoreCount;
    uint8_t m_CoreNumberArray[CoreNumberMaximum];
    bool    m_IsInitialized;
    uint8_t m_Counter;
};

}}} // nnt::codec::util
