﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/atk.h>
#include <nn/mem.h>
#include <nn/nn_Abort.h>
#include <nn/util/util_FormatString.h>

namespace nnt{ namespace atk { namespace util {

// クラスとしては 2 つ以上生成できるようになっていますが、
// 同一のマウント名のものをマウント、アンマウントするといった不都合が生じないように、
// 一つのテスト項目につき一つのみ Fs セットアップクラスを使うようにしてください。
class FsCommonSetup
{
public:
    static const char* RomMountName;
    static const char* ContentsMountName;
    static const char* TestResultsMountName;
    static const char* TestBinariesMountName;

    class InitializeParam
    {
    public:
        InitializeParam() NN_NOEXCEPT
        : m_IsRomMounted(true)
        , m_IsContentsDirMounted(false)
        , m_IsTestResultsDirMounted(false)
        , m_IsTestBinariesDirMounted(false)
        {
        }

        // 共通リソースとして用意された Rom をマウントするか設定します。
        // FsCommonSetup::Initialize 後、マウントされる場合は FsCommonSetup::RomMountName がマウント名となります。
        // デフォルトは true です。
        void SetRomMounted(bool flag)
        {
            m_IsRomMounted = flag;
        }
        // 共通リソースとして用意された Rom をマウントするかどうかを取得します。
        // デフォルトは true です。
        bool IsRomMounted()
        {
            return m_IsRomMounted;
        }
        // 各テストが独自に用意しているリソースが格納される、 Contents ディレクトリをマウントするか設定します。
        // (実行ファイルのフォルダ)/../Contents に該当のディレクトリが存在します。
        //
        // FsCommonSetup::Initialize 後、マウントされる場合は FsCommonSetup::ContentsMountName がマウント名となります。
        // デフォルトは false です。
        void SetContentsDirectoryMounted(bool flag)
        {
            m_IsContentsDirMounted = flag;
        }
        // 各テストが独自に用意しているリソースが格納される、 Contents ディレクトリをマウントするかどうかを取得します。
        // デフォルトは false です。
        bool IsContentsDirectoryMounted()
        {
            return m_IsContentsDirMounted;
        }
        // テストが出力した結果を格納する、 TestResults ディレクトリをマウントするか設定します。
        // (SdkRoot)/Externals/TestBinaries/Atk/TestResults に該当のディレクトリが存在します。
        //
        // FsCommonSetup::Initialize 後、マウントされる場合は FsCommonSetup::TestResultsMountName がマウント名となります。
        // デフォルトは false です。
        void SetTestResultsDirectoryMounted(bool flag)
        {
            m_IsTestResultsDirMounted = flag;
        }
        // テストが出力した結果を格納する、 TestResults ディレクトリをマウントするかどうかを取得します。
        // デフォルトは false です。
        bool IsTestResultsDirectoryMounted()
        {
            return m_IsTestResultsDirMounted;
        }
        // Atk 用のテストバイナリが存在する、 TestBinaries ディレクトリをマウントするか設定します。
        // (SdkRoot)/Externals/TestBinaries/Atk に該当のディレクトリが存在します。
        //
        // FsCommonSetup::Initialize 後、マウントされた場合は FsCommonSetup::TestBinariesMountName がマウント名となります。
        // デフォルトは false です。
        void SetTestBinariesDirectoryMounted(bool flag)
        {
            m_IsTestBinariesDirMounted = flag;
        }
        // Atk 用のテストバイナリが存在する、 TestBinaries ディレクトリをマウントするかどうかを取得します。
        // デフォルトは false です。
        bool IsTestBinariesDirectoryMounted()
        {
            return m_IsTestBinariesDirMounted;
        }

    private:
        bool m_IsRomMounted;
        bool m_IsContentsDirMounted;
        bool m_IsTestResultsDirMounted;
        bool m_IsTestBinariesDirMounted;
    };

    FsCommonSetup() NN_NOEXCEPT;
    virtual ~FsCommonSetup() NN_NOEXCEPT;

    virtual void Initialize() NN_NOEXCEPT;
    virtual void Initialize(InitializeParam& param) NN_NOEXCEPT;
    virtual void Finalize() NN_NOEXCEPT;

private:
    InitializeParam m_Param;

    static const size_t MountRomCacheBufferSize = 4 * 1024;
    static char m_MountRomCacheBuffer[MountRomCacheBufferSize];
};


}}}
