﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "testImageJpeg_LibjpegApi.h"

/**
    @file TGAフォーマットのバイナリデータを扱うクラスを宣言します。
 */

namespace nnt { namespace image { namespace jpeg {

/**
    @brief TGAフォーマットについて色々な静的関数を提供するクラスです。
    @details    対応するのは無圧縮24bit, 32bitのTGAフォーマットです。
                画像の回転などには非対応です。
                (ピクセルデータが下から格納されていること前提です。)
 */
class Tga
{
public:
    /**
        @brief TGAフォーマットのデータから、画像の幅と高さを取得します。
        @param[out] pOutDim 画像の幅と高さが格納されます。
        @param[in] tga TGAフォーマットのバイナリデータを指定します。
        @param[in] size tgaのバイト数を指定します。
        @return pOutDimに有効な幅と高さが格納されたときにtrueを返します。
     */
    static bool GetDimension(
        Dimension *pOutDim,
        const void *tga, const size_t size);

    /**
        @brief TGAフォーマットのデータから、RGBA 32bit 形式でピクセルデータを取得します。
        @param[out] pixel ピクセルデータの格納先を指定します。
        @param[in] pixelSize pixelのバイト数を指定します。
        @param[in] lineAlignment pixelの行アラインメントを指定します。
        @param[in] tga TGAフォーマットのバイナリデータを指定します。
        @param[in] size tgaのバイト数を指定します。
        @return pixelに有効なピクセルデータが格納されたときにtrueを返します。
     */
    static void GetPixels(
        uint32_t *pixel,
        const size_t pixelSize,
        const int lineAlignment,
        const void *tga,
        const size_t tgaSize);
};

}}}
