﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/vi.h>
#include <nn/vi/vi_CmuLuma.h>
#include <nn/am/service/am_DisplayLayerControl.h>

namespace {
    nn::vi::Display* g_pDisplaysInternal = reinterpret_cast<nn::vi::Display*>(0x1);
    nn::vi::Display* g_pDisplaysExternal = reinterpret_cast<nn::vi::Display*>(0x2);
    float g_CurrentLumaInternal = .0f;
    float g_CurrentLumaExternal = .0f;
}

namespace nn { namespace vi {

    void Initialize() NN_NOEXCEPT
    {
    }

    Result OpenDisplay(Display** pOutDisplay, const char* name) NN_NOEXCEPT
    {
        if ( !std::strncmp(name, "Internal", 8) )
        {
            *pOutDisplay = g_pDisplaysInternal;
            NN_RESULT_SUCCESS;
        }
        if ( !std::strncmp(name, "External", 8) )
        {
            *pOutDisplay = g_pDisplaysExternal;
            NN_RESULT_SUCCESS;
        }
        NN_RESULT_THROW(nn::vi::ResultNotFound());
    }
    void CloseDisplay(Display* pDisplay) NN_NOEXCEPT
    {
        NN_UNUSED(pDisplay);
    }

    Result SetDisplayCmuLuma(Display* pDisplay, float luma) NN_NOEXCEPT
    {
        if ( pDisplay == g_pDisplaysInternal )
        {
            g_CurrentLumaInternal = luma;
            NN_RESULT_SUCCESS;
        }
        if ( pDisplay == g_pDisplaysExternal )
        {
            g_CurrentLumaExternal = luma;
            NN_RESULT_SUCCESS;
        }
        NN_RESULT_THROW(nn::vi::ResultOperationFailed());
    }
    Result GetDisplayCmuLuma(float* pOutLuma, const Display* pDisplay) NN_NOEXCEPT
    {
        if ( pDisplay == g_pDisplaysInternal )
        {
            *pOutLuma = g_CurrentLumaInternal;
            NN_RESULT_SUCCESS;
        }
        if ( pDisplay == g_pDisplaysExternal )
        {
            *pOutLuma = g_CurrentLumaExternal;
            NN_RESULT_SUCCESS;
        }
        NN_RESULT_THROW(nn::vi::ResultOperationFailed());
    }

}} // namespace nn::vi

namespace nn{ namespace am{ namespace service{

    Result SetDisplayCmuLuma(const char* displayName, float targetLuma) NN_NOEXCEPT
    {
        if( !strncmp(displayName, "Internal", 8) )
        {
            g_CurrentLumaInternal = targetLuma;
            NN_RESULT_SUCCESS;
        }
        if( !strncmp(displayName, "External", 8) )
        {
            g_CurrentLumaExternal = targetLuma;
            NN_RESULT_SUCCESS;
        }
        NN_RESULT_THROW(nn::vi::ResultNotFound());
    }

}}} // namespace nn::am::service
