﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/i2c/i2c.h>

#include "tool_Max17050.h"

namespace nnt { namespace i2c { namespace max17050 {

nn::Result DumpRegisters()
{
    const uint8_t regFieldRegion[][2] = {
        { 0x00, 0x0B },
        { 0x0D, 0x13 },
        { 0x16, 0x1F },
        { 0x21, 0x25 },
        { 0x27, 0x2F },
        { 0x32, 0x32 },
        { 0x36, 0x3A },
        { 0x3D, 0x3F },
        { 0x42, 0x42 },
        { 0x45, 0x46 },
        { 0x4D, 0x4D },
        { 0x80, 0xAF },
        { 0xFB, 0xFB },
        { 0xFF, 0xFF },
    };

    NN_LOG("[max17050] Start to dump\n");

    nn::i2c::Initialize();

    nn::i2c::I2cSession i2c;
    uint16_t value = 0;

    nn::i2c::OpenSession(&i2c, nn::i2c::I2cDevice_Max17050);

    for ( int region = 0; region < (sizeof(regFieldRegion) / sizeof(regFieldRegion[0])); region++ )
    {
        for ( uint8_t index = regFieldRegion[region][0]; index <= regFieldRegion[region][1]; index++ )
        {
            NN_RESULT_DO(nn::i2c::ReadSingleRegister(&value, i2c, &index));

            NN_LOG("[max17050] %02x : %04X\n", index, value);

            if ( index == 0xFF ) break;
        }
    }

    nn::i2c::CloseSession(i2c);

    nn::i2c::Finalize();

    NN_LOG("[max17050] End\n");

    NN_RESULT_SUCCESS;
}

}}}  // namespace nnt::i2c::max17050
