﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * Npadの入力状態をツール上にだすだけのやつ
 */

#include "PrintNpadLog.h"

void nnt::PrintNpadButtonState(float x, float y, size_t index)
{
    auto ctrl = gController.GetControllerFromIndex(index);

    char buttons[29];

    buttons[0] = (ctrl->IsHold(nn::hid::NpadButton::A::Mask)) ? 'A' : '-';
    buttons[1] = (ctrl->IsHold(nn::hid::NpadButton::B::Mask)) ? 'B' : '-';
    buttons[2] = (ctrl->IsHold(nn::hid::NpadButton::X::Mask)) ? 'X' : '-';
    buttons[3] = (ctrl->IsHold(nn::hid::NpadButton::Y::Mask)) ? 'Y' : '-';
    buttons[4] = (ctrl->IsHold(nn::hid::NpadButton::StickL::Mask)) ? 'L' : '-';
    buttons[5] = (ctrl->IsHold(nn::hid::NpadButton::StickL::Mask)) ? 'S' : '-';
    buttons[6] = (ctrl->IsHold(nn::hid::NpadButton::StickR::Mask)) ? 'R' : '-';
    buttons[7] = (ctrl->IsHold(nn::hid::NpadButton::StickR::Mask)) ? 'S' : '-';
    buttons[8] = (ctrl->IsHold(nn::hid::NpadButton::L::Mask)) ? 'L' : '-';
    buttons[9] = (ctrl->IsHold(nn::hid::NpadButton::R::Mask)) ? 'R' : '-';
    buttons[10] = (ctrl->IsHold(nn::hid::NpadButton::ZL::Mask)) ? 'Z' : '-';
    buttons[11] = (ctrl->IsHold(nn::hid::NpadButton::ZL::Mask)) ? 'L' : '-';
    buttons[12] = (ctrl->IsHold(nn::hid::NpadButton::ZR::Mask)) ? 'Z' : '-';
    buttons[13] = (ctrl->IsHold(nn::hid::NpadButton::ZR::Mask)) ? 'R' : '-';
    buttons[14] = (ctrl->IsHold(nn::hid::NpadButton::Plus::Mask)) ? '+' : '-';
    buttons[15] = (ctrl->IsHold(nn::hid::NpadButton::Minus::Mask)) ? '-' : '-';
    buttons[16] = (ctrl->IsHold(nn::hid::NpadButton::Left::Mask)) ? '<' : '-';
    buttons[17] = (ctrl->IsHold(nn::hid::NpadButton::Up::Mask)) ? '^' : '-';
    buttons[18] = (ctrl->IsHold(nn::hid::NpadButton::Right::Mask)) ? '>' : '-';
    buttons[19] = (ctrl->IsHold(nn::hid::NpadButton::Down::Mask)) ? 'v' : '-';
    buttons[20] = (ctrl->IsHold(nn::hid::NpadButton::StickLRight::Mask)) ? '>' : '-';
    buttons[21] = (ctrl->IsHold(nn::hid::NpadButton::StickLUp::Mask)) ? '^' : '-';
    buttons[22] = (ctrl->IsHold(nn::hid::NpadButton::StickLLeft::Mask)) ? '<' : '-';
    buttons[23] = (ctrl->IsHold(nn::hid::NpadButton::StickLDown::Mask)) ? 'v' : '-';
    buttons[24] = (ctrl->IsHold(nn::hid::NpadButton::StickRRight::Mask)) ? '>' : '-';
    buttons[25] = (ctrl->IsHold(nn::hid::NpadButton::StickRUp::Mask)) ? '^' : '-';
    buttons[26] = (ctrl->IsHold(nn::hid::NpadButton::StickRLeft::Mask)) ? '<' : '-';
    buttons[27] = (ctrl->IsHold(nn::hid::NpadButton::StickRDown::Mask)) ? 'v' : '-';
    buttons[28] = '\n';

    gTextWriter.SetCursor(x, y);
    gTextWriter.Print("NPad Hold：");
    gTextWriter.SetCursor(x + 120, y);
    gTextWriter.Print("%s", buttons);

    auto LeftAnalogStick = ctrl->GetNormalizedLeftAnalogStickState();
    auto RightAnalogStick = ctrl->GetNormalizedRightAnalogStickState();

    gTextWriter.SetCursor(x, y + 20);
    gTextWriter.Print("StickL：");
    gTextWriter.SetCursor(x + 120, y + 20);
    gTextWriter.Print("(%.3f, %.3f)\n", LeftAnalogStick.x, LeftAnalogStick.y);
    gTextWriter.SetCursor(x, y + 40);
    gTextWriter.Print("StickR：");
    gTextWriter.SetCursor(x + 120, y + 40);
    gTextWriter.Print("(%.3f, %.3f)\n", RightAnalogStick.x, RightAnalogStick.y);
}
