﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include "hidfw/gfx.h"
#include "hidfw/hid.h"
#include <nn/oe.h>

#include "CursolSelect.h"
#include "RondeUtility.h"
#include "HidbusRonde.h"

namespace nnt {
namespace menuf {
    void PollingReadRondeData(HidbusState * state, RondeData * data, size_t index) NN_NOEXCEPT;
    void FuncInitFin(nnt::Cursol* cursol, HidbusState* state, size_t index) NN_NOEXCEPT;
    void FuncHidbus(nnt::Cursol* cursol, HidbusState* state) NN_NOEXCEPT;
    void FuncTransMode(nnt::Cursol* cursol, HidbusState* state, RondeData* data, size_t index) NN_NOEXCEPT;
    void FuncData(nnt::Cursol* cursol, HidbusState* state) NN_NOEXCEPT;
    void FuncPollingNumSelect(nnt::Cursol* cursol, HidbusState* state) NN_NOEXCEPT;
}}
