﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "hidfw/gfx.h"
#include "hidfw/hid.h"
#include "hidfw/layout.h"

namespace nnt {
    enum MenuSelect
    {
        Menu_InitFin = 0,
        Menu_Hidbus,
        Menu_TransMode,
        Menu_Data,
        Menu_PollingNumSelect,
    };

    enum InitFin
    {
        InitFin_GetHandle = 0,
        InitFin_Init,
        InitFin_Fin,
    };

    enum Hidbus
    {
        Hidbus_Enable = 0,
        Hidbus_Disable,
    };

    enum TransMode
    {
        TransMode_EnablePolling6Axis = 0,
        TransMode_EnablePollingNo6Axis,
        TransMode_DisablePolling,
        TransMode_SendAndReceive,
        TransMode_GetPollingData,
        TransMode_StopGetPollingData,
    };

    enum Data
    {
        Data_UniqueId = 0,
        Data_PollingFormat,
        Data_FwVersion,
        Data_SCal,
        Data_UCal,
        Data_WriteUCal,
    };

    enum Menustate
    {
        Menustate_OutForcus = 0,
        Menustate_ForcusLeft,
        Menustate_ForcusRight,
    };

    struct Cursol
    {
        MenuSelect menu;                // どのメニューを選択しているか
        InitFin initfin;                // 初期化、ファイナライズのどちらか
        Hidbus hidbus;                  // Hidbusが有効か否か
        TransMode trsmode;              // 通信モードはどれか
        Data data;                      // どのデータを送受信するか
        int pollingNumSelect;           // PollingMode時のcount数
        Menustate menustate;            // メニューの選択状況
        bool IsSelectedLeft;            // 何かしらの選択があった場合はTRUE
        bool IsSelectedRight;           // 何かしらの選択があった場合はTRUE
        bool IsSelectedWriteUserCal;    // ユーザーCal書き込みを選択した場合True
        int userCalIndex;
        int16_t osMax;     //!< osMax
        int16_t hkMax;     //!< hkMax
        int16_t zeroMin;   //!< zeroMin
        int16_t zeroMax;   //!< zeroMax
    };

    void InitializeCursol(Cursol * cursol, size_t index);

    void SetUserCal(Cursol * cursol, size_t index);

    void GetAndDrawCursolPosition(Cursol* cursol, float x, float y, size_t index);
}
