﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/util/util_Vector.h>

#include "IMotionDetector.h"

class SpinMotionDetector final : public IMotionDetector
{
    NN_DISALLOW_COPY(SpinMotionDetector);
    NN_DISALLOW_MOVE(SpinMotionDetector);

public:

    SpinMotionDetector() NN_NOEXCEPT;

    virtual ~SpinMotionDetector() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Reset() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Update(const SixAxisSensorRawState& rawState) NN_NOEXCEPT NN_OVERRIDE;

    virtual int GetMotions(MotionState* pOutStates, int count) NN_NOEXCEPT NN_OVERRIDE;

private:
    struct Config
    {
        int64_t samplingNumber; // 直近の符号変化時のサンプリング番号
        int count;              // ゼロ交差検出回数

        Config()
        {
            samplingNumber = 0;
            count = 0;
        }
    };

private:

    bool IsSpinMotionDetected() const NN_NOEXCEPT;

private:

    SixAxisSensorRawState m_SixAxisSensorRawState; // 直近のセンサー値

    Config m_Configs[2]; // 0: X, 1: Y

    int m_ThresholdSpinCount;

    // MEMO:
    // ゼロ交差の順序性をチェックすれば適切にスピンしているか検出できる
    // ∵ スピンしているときは X -> Y -> X -> Y -> ... と交互にゼロ交差するため
    // 現状交互でなくてもスピン判定している

    // 閾値
    int64_t m_ThresholdSignInversionSamplingNumberDelta; // 0 付近で値がふらついたときのハンドリングのため
    int64_t m_ThresholdTimeoutSamplingNumber; // 検出のタイムアウト
    float  m_ThresholdGyroLengthSquared; // 静止時の角速度の符号変化を検出しないため
};
