﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

#include "../Simple2D_Types.h"

namespace s2d { namespace detail {

/**
 * @brief   標準のフォントサイズ
 */
const int DefaultFontSize = 40;

/**
 * @brief   初期化パラメータ
 */
struct FontInitializationParameters
{
    bool    isDynamicMode;  //!< テクスチャ動的生成モード
    int     baseFontSize;   //!< 基準となるフォントサイズ

    /**
     * @brief   デフォルトパラメータを生成
     */
    static FontInitializationParameters CreateDefault() NN_NOEXCEPT
    {
        FontInitializationParameters params = {};
        params.isDynamicMode = false;
        params.baseFontSize  = DefaultFontSize;

        return params;
    }
};

void InitializeSharedFont(const FontInitializationParameters& param) NN_NOEXCEPT;
void FinalizeSharedFont() NN_NOEXCEPT;

int GetSharedFontBaseSize() NN_NOEXCEPT;
GLuint GetSharedFontTextureId() NN_NOEXCEPT;
float GetSharedFontLineHeight() NN_NOEXCEPT;

bool IsValidSharedFontCharacter(uint32_t character) NN_NOEXCEPT;
void GetSharedFontGridSize(Size* pOutSize) NN_NOEXCEPT;
void GetSharedFontCharacterSize(Size* pOutSize, uint32_t character) NN_NOEXCEPT;
void GetSharedFontTextureCoord(Point2D* pOutCoord, uint32_t character) NN_NOEXCEPT;

}}  // s2d::detail
