﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "NpadController.h"
#include "IScene.h"

class SceneControllerStatus final : public IScene
{
    NN_DISALLOW_COPY(SceneControllerStatus);
    NN_DISALLOW_MOVE(SceneControllerStatus);

private:
    NpadControllerList* m_pCoutrollers;
    bool m_IsMenuLocked;

public:
    SceneControllerStatus() NN_NOEXCEPT;
    virtual ~SceneControllerStatus() NN_NOEXCEPT NN_OVERRIDE { /* 何もしない */ };
    void SetNpadControllerList(NpadControllerList* pControllers) NN_NOEXCEPT;
    virtual PackedButton Control(const PackedButton& button) NN_NOEXCEPT NN_OVERRIDE;

protected:
    virtual void DrawImpl(RecordablePosition& position) NN_NOEXCEPT NN_OVERRIDE;
    virtual std::string GetGuideString() NN_NOEXCEPT NN_OVERRIDE
    {
        if (m_IsMenuLocked)
        {
            return "\uE0EF/\uE0F0 Unlock   \uE102 Scroll";
        }
        return "\uE0EF/\uE0F0 Lock   \uE102 Scroll";
    }
    virtual std::string GetSceneName() NN_NOEXCEPT NN_OVERRIDE
    {
        return "Npad State View";
    }
};
