﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "PlayReportUsageMonitor.h"
#include "SceneLog.h"
#include "ScreenStatics.h"
#include "ScreenUtil.h"
#include "s2d/Simple2D.h"

nn::hid::NpadIdType GetNpadIdType(int controllerNumber)
{
    switch (controllerNumber)
    {
    case 1:
        return nn::hid::NpadId::No1;
    case 2:
        return nn::hid::NpadId::No2;
    case 3:
        return nn::hid::NpadId::No3;
    case 4:
        return nn::hid::NpadId::No4;
    case 5:
        return nn::hid::NpadId::No5;
    case 6:
        return nn::hid::NpadId::No6;
    case 7:
        return nn::hid::NpadId::No7;
    case 8:
        return nn::hid::NpadId::No8;
    default:
        return nn::hid::NpadId::Handheld;
    }
}

void DrawPlayReportDeviceType(PositionInScene& position, const nn::hid::system::PlayReportDeviceType& usageDeviceType)
{
    position.x += PrintAndStep(position.Get(), "Device:", true);
    switch (usageDeviceType)
    {
    case nn::hid::system::PlayReportDeviceType_JoyConLeft:
        s2d::DrawText(position.Get(), "[%02d] Joy-Con(L)", usageDeviceType);
        break;
    case nn::hid::system::PlayReportDeviceType_JoyConRight:
        s2d::DrawText(position.Get(), "[%02d] Joy-Con(R)", usageDeviceType);
        break;
    case nn::hid::system::PlayReportDeviceType_SwitchProController:
        s2d::DrawText(position.Get(), "[%02d] SwitchProController", usageDeviceType);
        break;
    case nn::hid::system::PlayReportDeviceType_UsbController:
        s2d::DrawText(position.Get(), "[%02d] UsbController", usageDeviceType);
        break;
    default:
        s2d::DrawText(position.Get(), "[%02d] Unknown", usageDeviceType);
        break;
    }
    position.x += XSizeDeviceType + XSizePadding * 3;
}

void DrawPlayReportStyle(PositionInScene& position, const nn::hid::system::PlayReportPlayStyle& style)
{
    position.x += PrintAndStep(position.Get(), "Style:", true);
    switch (style)
    {
    case nn::hid::system::PlayReportPlayStyle_Handheld:
        s2d::DrawText(position.Get(), "[%02d] Handheld", style);
        break;
    case nn::hid::system::PlayReportPlayStyle_JoyConDual:
        s2d::DrawText(position.Get(), "[%02d] Joy-Con Dual", style);
        break;
    case nn::hid::system::PlayReportPlayStyle_JoyConLeftHorizontal:
        s2d::DrawText(position.Get(), "[%02d] Joy-Con (L) Hor", style);
        break;
    case nn::hid::system::PlayReportPlayStyle_JoyConLeftVertical:
        s2d::DrawText(position.Get(), "[%02d] Joy-Con (L) Ver", style);
        break;
    case nn::hid::system::PlayReportPlayStyle_JoyConRightHorizontal:
        s2d::DrawText(position.Get(), "[%02d] Joy-Con (R) Hor", style);
        break;
    case nn::hid::system::PlayReportPlayStyle_JoyConRightVertical:
        s2d::DrawText(position.Get(), "[%02d] Joy-Con (R) Ver", style);
        break;
    case nn::hid::system::PlayReportPlayStyle_SwitchProController:
        s2d::DrawText(position.Get(), "[%02d] Pro Controller", style);
        break;
    default:
        s2d::DrawText(position.Get(), "[%02d] Unknown", style);
        break;
    }
    position.x += XSizeDeviceType + XSizePadding * 3;
}

void SceneLog::DrawImpl(NpadControllers& controllers, PositionInScene& position) NN_NOEXCEPT
{
    NN_UNUSED(controllers);

    const auto& usages = ActivityMonitor::GetInstance().GetUsages();

    for (auto it = usages.begin();
        it != usages.end();
        ++it)
    {
        position.x = PositionSceneText.x;
        s2d::DrawText(position.Get(), "[%02d]", std::distance(usages.begin(), it));

        for (int i = 0; i < (*it).count; ++i)
        {
            auto& usage = (*it).usages[i];
            position.x = PositionSceneText.x + XSizeNpadLabel;
            s2d::DrawText(position.Get(), "%02d:");
            position.x += XSizeNpadLabel;
            DrawNpadIdType(position, GetNpadIdType(usage.controllerNumber));
            DrawPlayReportDeviceType(position, usage.deviceType);
            DrawPlayReportStyle(position, usage.style);
        }
    }
}
