﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/nn_Log.h>

#include "PalmaHandler.h"

namespace
{
const nn::hid::PalmaConnectionHandle InvalidHandle = { 0 };
bool g_IsOnPairing = false;
}

PalmaHandler::PalmaHandler() NN_NOEXCEPT :
    m_Handle(InvalidHandle)
{
    // 何もしない
}

void PalmaHandler::Initialize(const nn::hid::NpadIdType& id) NN_NOEXCEPT
{
    m_NpadId = id;
}

void PalmaHandler::Update(bool styleAvailable) NN_NOEXCEPT
{
    if (styleAvailable == false)
    {
        m_Handle = InvalidHandle;
        return;
    }

    if (m_Handle._storage == InvalidHandle._storage)
    {
        if (nn::hid::GetPalmaConnectionHandle(&m_Handle, m_NpadId).IsFailure())
        {
            return;
        }
        else
        {
            // デバイスが接続された
            if (g_IsOnPairing == true)
            {
                nn::hid::PairPalma(m_Handle);
            }
        }
    }
}

void PalmaHandler::StartScan() NN_NOEXCEPT
{
    NN_LOG("Start Scanning\n");
    nn::hid::EnablePairedPalmaConnection();
}

void PalmaHandler::StopScan() NN_NOEXCEPT
{
    NN_LOG("Stop Scanning\n");
    nn::hid::DisablePairedPalmaConnection();
}

void PalmaHandler::StartPairing() NN_NOEXCEPT
{
    NN_LOG("Start Pairing\n");
    nn::hid::EnableAnyPalmaConnection();
    g_IsOnPairing = true;
}

void PalmaHandler::StopPairing() NN_NOEXCEPT
{
    NN_LOG("Stop Pairing\n");
    g_IsOnPairing = false;
    nn::hid::DisableAnyPalmaConnection();
}
