﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "frm_VrMd.h"

namespace frm {
namespace vr {

    /* Singleton パターン */
    VrMd& VrMd::GetInstance() NN_NOEXCEPT
    {
        static VrMd Instance;
        return Instance;
    }

    /* ------------------------------------------------------------ */
    // PRIVATE関数
    /* ------------------------------------------------------------ */

    /* ------------------------------------------------------------ */
    // PUBLIC関数
    /* ------------------------------------------------------------ */

    void VrMd::Start() NN_NOEXCEPT
    {
        nn::pl::BeginVrMode();
    }

    bool VrMd::UpdateState() NN_NOEXCEPT
    {
        bool onoff;
        onoff = nn::pl::IsVrMode();

        return onoff;
    }

    void VrMd::Stop() NN_NOEXCEPT
    {
        nn::pl::EndVrMode();
    }
}
}
// [EOF]
