﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
    @brief
    本体 6 軸センサーの値を波形表示します
*/

#pragma once

#include <cstdlib>
#include <string>
#include <vector>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

#include <FontSys.h>
#include <GraphicsSys.h>
#include <Color.h>
#include <frm_SixAxis.h>

namespace main {

    struct SensorBuffer
    {
        float X;
        float Y;
        float Z;
    };
    const int SensorBufferNum = 60;

    class DrawWave
    {
    private:
        void WriteAxis(GraphicsSystem* pGraphicsSystem, float offsetX, float offsetY) NN_NOEXCEPT;
        void BufferSensorDataAxis(frm::hid::SixAxisState* pState, SensorBuffer* pAccelBuffer, SensorBuffer* pAngulerRateBuffer) NN_NOEXCEPT;
        void DrawWaveData(GraphicsSystem* pGraphicsSystem, SensorBuffer* value, float offsetX, float offsetY) NN_NOEXCEPT;

    public:
        void Draw(nn::gfx::util::DebugFontTextWriter* pTextWriter,
                            GraphicsSystem* pGraphicsSystem,
                            frm::hid::SixAxisState sixAxisState,
                            SensorBuffer* pAccelBuffer,
                            SensorBuffer* pAngulerRateBuffer,
                            const float offsetX,
                            const float accelOffsetY) NN_NOEXCEPT;
    };
}
