﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/hid.h>
#include <nn/os.h>
#include <nn/TargetConfigs/build_Base.h>

namespace nnt { namespace hid {

//!< Npad のサンプリング間隔を返します。
inline ::nn::TimeSpanType GetNpadSamplingInterval() NN_NOEXCEPT
{
    return ::nn::TimeSpanType::FromMilliSeconds(5);
}

}} // namespace nnt::hid
